/*     */ package org.jboss.net.protocol.file;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FilenameFilter;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.net.protocol.URLLister.URLFilter;
/*     */ import org.jboss.net.protocol.URLListerBase;
/*     */ 
/*     */ public class FileURLLister extends URLListerBase
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(FileURLLister.class);
/*     */ 
/*     */   public Collection listMembers(URL baseUrl, URLLister.URLFilter filter)
/*     */     throws IOException
/*     */   {
/*  52 */     return listMembers(baseUrl, filter, false);
/*     */   }
/*     */ 
/*     */   public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs)
/*     */     throws IOException
/*     */   {
/*  58 */     String baseUrlString = baseUrl.toString();
/*  59 */     if (!baseUrlString.endsWith("/"))
/*     */     {
/*  61 */       throw new IOException("Does not end with '/', not a directory url: " + baseUrlString);
/*     */     }
/*     */ 
/*  65 */     File dir = new File(baseUrl.getPath());
/*  66 */     if (!dir.isDirectory())
/*     */     {
/*  68 */       throw new FileNotFoundException("Not pointing to a directory, url: " + baseUrlString);
/*     */     }
/*     */ 
/*  72 */     ArrayList resultList = new ArrayList();
/*     */ 
/*  75 */     listFiles(baseUrl, filter, scanNonDottedSubDirs, resultList);
/*     */ 
/*  78 */     return resultList;
/*     */   }
/*     */ 
/*     */   private void listFiles(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs, ArrayList resultList)
/*     */     throws IOException
/*     */   {
/*  92 */     File baseDir = new File(baseUrl.getPath());
/*  93 */     String[] filenames = baseDir.list(new FilenameFilter(filter, baseUrl, baseDir)
/*     */     {
/*     */       public boolean accept(File dir, String name)
/*     */       {
/*     */         try
/*     */         {
/*  99 */           return this.val$filter.accept(this.val$baseUrl, name);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 103 */           FileURLLister.log.debug("Unexpected exception filtering entry '" + name + "' in directory '" + this.val$baseDir + "'", e);
/* 104 */         }return true;
/*     */       }
/*     */     });
/* 109 */     if (filenames == null)
/*     */     {
/* 115 */       throw new IOException("Could not list directory '" + baseDir + "', reason unknown");
/*     */     }
/*     */ 
/* 119 */     String baseUrlString = baseUrl.toString();
/*     */ 
/* 121 */     for (int i = 0; i < filenames.length; i++)
/*     */     {
/* 123 */       String filename = filenames[i];
/*     */ 
/* 126 */       File file = new File(baseDir, filename);
/* 127 */       boolean isDir = file.isDirectory();
/*     */ 
/* 130 */       URL subUrl = createURL(baseUrlString, filename, isDir);
/*     */ 
/* 136 */       if ((scanNonDottedSubDirs) && (isDir) && (filename.indexOf('.') == -1))
/*     */       {
/* 139 */         listFiles(subUrl, filter, scanNonDottedSubDirs, resultList);
/*     */       }
/*     */       else
/*     */       {
/* 144 */         resultList.add(subUrl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private URL createURL(String baseUrlString, String filename, boolean isDirectory)
/*     */   {
/*     */     try
/*     */     {
/* 158 */       return new URL(baseUrlString + filename + (isDirectory ? "/" : ""));
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */     }
/* 163 */     throw new IllegalStateException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.file.FileURLLister
 * JD-Core Version:    0.6.0
 */