/*     */ package org.jboss.net.protocol.file;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FilePermission;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.FileNameMap;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.net.URLDecoder;
/*     */ import java.security.Permission;
/*     */ 
/*     */ public class FileURLConnection extends URLConnection
/*     */ {
/*  51 */   static boolean decodeFilePaths = true;
/*     */   protected File file;
/*     */ 
/*     */   public FileURLConnection(URL url)
/*     */     throws MalformedURLException, IOException
/*     */   {
/*  63 */     super(url);
/*  64 */     String path = url.getPath();
/*  65 */     if (decodeFilePaths) {
/*  66 */       path = URLDecoder.decode(path, "UTF-8");
/*     */     }
/*     */ 
/*  69 */     this.file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
/*     */ 
/*  71 */     this.doOutput = false;
/*     */   }
/*     */ 
/*     */   public File getFile()
/*     */   {
/*  79 */     return this.file;
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/*  89 */     if (this.connected) {
/*  90 */       return;
/*     */     }
/*  92 */     if (!this.file.exists())
/*     */     {
/*  94 */       throw new FileNotFoundException(this.file.getPath());
/*     */     }
/*     */ 
/*  97 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream() throws IOException
/*     */   {
/* 102 */     if (!this.connected) {
/* 103 */       connect();
/*     */     }
/* 105 */     return new FileInputStream(this.file);
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream() throws IOException
/*     */   {
/* 110 */     if (!this.connected)
/* 111 */       connect();
/* 112 */     SecurityManager sm = System.getSecurityManager();
/* 113 */     if (sm != null)
/*     */     {
/* 116 */       FilePermission p = new FilePermission(this.file.getPath(), "write");
/* 117 */       sm.checkPermission(p);
/*     */     }
/* 119 */     return new FileOutputStream(this.file);
/*     */   }
/*     */ 
/*     */   public String getHeaderField(String name)
/*     */   {
/* 128 */     String headerField = null;
/* 129 */     if (name.equalsIgnoreCase("last-modified")) {
/* 130 */       headerField = String.valueOf(getLastModified());
/* 131 */     } else if (name.equalsIgnoreCase("content-length")) {
/* 132 */       headerField = String.valueOf(this.file.length());
/* 133 */     } else if (name.equalsIgnoreCase("content-type"))
/*     */     {
/* 135 */       headerField = getFileNameMap().getContentTypeFor(this.file.getName());
/* 136 */       if (headerField == null)
/*     */       {
/*     */         try
/*     */         {
/* 140 */           InputStream is = getInputStream();
/* 141 */           BufferedInputStream bis = new BufferedInputStream(is);
/* 142 */           headerField = URLConnection.guessContentTypeFromStream(bis);
/* 143 */           bis.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/* 150 */     else if (name.equalsIgnoreCase("date")) {
/* 151 */       headerField = String.valueOf(this.file.lastModified());
/*     */     }
/*     */     else
/*     */     {
/* 155 */       headerField = super.getHeaderField(name);
/*     */     }
/* 157 */     return headerField;
/*     */   }
/*     */ 
/*     */   public Permission getPermission()
/*     */     throws IOException
/*     */   {
/* 165 */     return new FilePermission(this.file.getPath(), "read");
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */   {
/* 173 */     return this.file.lastModified();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  54 */     String flag = System.getProperty("org.jboss.net.protocol.file.decodeFilePaths");
/*  55 */     if (flag != null)
/*  56 */       decodeFilePaths = Boolean.valueOf(flag).booleanValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.file.FileURLConnection
 * JD-Core Version:    0.6.0
 */