/*    */ package org.jboss.naming.interceptors;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import javax.naming.CommunicationException;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.ServiceUnavailableException;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.proxy.Interceptor;
/*    */ 
/*    */ public class ExceptionInterceptor extends Interceptor
/*    */   implements Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = 6010013004557885014L;
/*    */ 
/*    */   public Object invoke(Invocation mi)
/*    */     throws Throwable
/*    */   {
/* 54 */     Object value = null;
/*    */     try
/*    */     {
/* 57 */       value = getNext().invoke(mi);
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 61 */       throw e;
/*    */     }
/*    */     catch (IOException e)
/*    */     {
/* 65 */       CommunicationException ce = new CommunicationException("Operation failed");
/* 66 */       ce.setRootCause(e);
/* 67 */       throw ce;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 71 */       ServiceUnavailableException sue = new ServiceUnavailableException("Unexpected failure");
/* 72 */       sue.setRootCause(t);
/* 73 */       throw sue;
/*    */     }
/*    */ 
/* 76 */     return value;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.interceptors.ExceptionInterceptor
 * JD-Core Version:    0.6.0
 */