/*     */ package org.jboss.naming.client.java;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.OperationNotSupportedException;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.corba.ORBFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class javaURLContextFactory
/*     */   implements ObjectFactory
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(javaURLContextFactory.class);
/*     */   public static final String J2EE_CLIENT_NAME_PROP = "j2ee.clientName";
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env)
/*     */     throws Exception
/*     */   {
/*  66 */     String clientName = (String)env.get("j2ee.clientName");
/*  67 */     if (clientName == null)
/*     */     {
/*  70 */       clientName = (String)AccessController.doPrivileged(new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*     */           try
/*     */           {
/*  77 */             return System.getProperty("j2ee.clientName");
/*     */           }
/*     */           catch (SecurityException e) {
/*     */           }
/*  81 */           return null;
/*     */         }
/*     */       });
/*  86 */       if (clientName == null) {
/*  87 */         throw new NamingException("Failed to find j2ee.clientName in jndi env");
/*     */       }
/*     */     }
/*  90 */     Object result = null;
/*     */ 
/*  92 */     if (nameCtx == null)
/*  93 */       nameCtx = new InitialContext(env);
/*  94 */     if (obj == null)
/*     */     {
/*  97 */       InvocationHandler handler = new EncContextProxy(nameCtx, clientName);
/*  98 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  99 */       Class[] ifaces = { Context.class };
/* 100 */       result = Proxy.newProxyInstance(loader, ifaces, handler);
/*     */     }
/* 102 */     return result;
/*     */   }
/*     */ 
/*     */   private static class EncContextProxy implements InvocationHandler {
/*     */     Context lookupCtx;
/*     */     String clientName;
/*     */ 
/*     */     EncContextProxy(Context lookupCtx, String clientName) {
/* 112 */       this.lookupCtx = lookupCtx;
/* 113 */       this.clientName = clientName;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object proxy, Method method, Object[] args)
/*     */       throws Throwable
/*     */     {
/* 121 */       String methodName = method.getName();
/* 122 */       if (methodName.equals("toString") == true) {
/* 123 */         return "Client ENC(" + this.clientName + ")";
/*     */       }
/* 125 */       if (!methodName.equals("lookup"))
/* 126 */         throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
/* 127 */       NameParser parser = this.lookupCtx.getNameParser("");
/* 128 */       Name name = null;
/* 129 */       if ((args[0] instanceof String))
/* 130 */         name = parser.parse((String)args[0]);
/*     */       else {
/* 132 */         name = (Name)args[0];
/*     */       }
/*     */ 
/* 135 */       if ((name.size() < 2) || (!"java:comp".equals(name.get(0))) || (!"env".equals(name.get(1)))) {
/* 136 */         return getSpecialObject(name);
/*     */       }
/* 138 */       Context clientCtx = (Context)this.lookupCtx.lookup(this.clientName);
/*     */       try
/*     */       {
/* 143 */         clientCtx = (Context)clientCtx.lookup("env");
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 148 */         javaURLContextFactory.log.trace("No env sub context found", e);
/*     */       }
/*     */ 
/* 152 */       Name bindingName = name.getSuffix(2);
/* 153 */       Object binding = clientCtx.lookup(bindingName);
/*     */ 
/* 155 */       return binding;
/*     */     }
/*     */ 
/*     */     public Object getSpecialObject(Name name) throws NamingException
/*     */     {
/* 160 */       if ((name.size() > 0) && ("java:comp".equals(name.get(0))))
/*     */       {
/* 162 */         if ((name.size() == 2) && ("ORB".equals(name.get(1))))
/* 163 */           return ORBFactory.getORB();
/* 164 */         if ((name.size() == 2) && ("HandleDelegate".equals(name.get(1))))
/* 165 */           return HandleDelegateFactory.getHandleDelegateSingleton();
/*     */       }
/* 167 */       throw new NamingException("Name not found " + name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.client.java.javaURLContextFactory
 * JD-Core Version:    0.6.0
 */