/*     */ package org.jboss.naming;
/*     */ 
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class NamingAlias extends ServiceMBeanSupport
/*     */   implements NamingAliasMBean
/*     */ {
/*     */   private String fromName;
/*     */   private String toName;
/*     */ 
/*     */   public NamingAlias()
/*     */   {
/*  47 */     this(null, null);
/*     */   }
/*     */ 
/*     */   public NamingAlias(String fromName, String toName)
/*     */   {
/*  52 */     this.fromName = fromName;
/*  53 */     this.toName = toName;
/*     */   }
/*     */ 
/*     */   public String getFromName()
/*     */   {
/*  66 */     return this.fromName;
/*     */   }
/*     */ 
/*     */   public void setFromName(String name)
/*     */     throws NamingException
/*     */   {
/*  79 */     removeLinkRef(this.fromName);
/*  80 */     this.fromName = name;
/*  81 */     createLinkRef();
/*     */   }
/*     */ 
/*     */   public String getToName()
/*     */   {
/*  96 */     return this.toName;
/*     */   }
/*     */ 
/*     */   public void setToName(String name)
/*     */     throws NamingException
/*     */   {
/* 111 */     this.toName = name;
/*     */ 
/* 113 */     createLinkRef();
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 118 */     if (this.fromName == null)
/* 119 */       throw new IllegalStateException("fromName is null");
/* 120 */     if (this.toName == null)
/* 121 */       throw new IllegalStateException("toName is null");
/* 122 */     createLinkRef();
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 127 */     removeLinkRef(this.fromName);
/*     */   }
/*     */ 
/*     */   private void createLinkRef() throws NamingException
/*     */   {
/* 132 */     if ((super.getState() == 2) || (super.getState() == 3))
/* 133 */       Util.createLinkRef(this.fromName, this.toName);
/*     */   }
/*     */ 
/*     */   private void removeLinkRef(String name)
/*     */     throws NamingException
/*     */   {
/* 141 */     if (super.getState() == 1)
/* 142 */       Util.removeLinkRef(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.NamingAlias
 * JD-Core Version:    0.6.0
 */