/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.LinkRef;
/*     */ import javax.naming.NameClassPair;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.web.AbstractWebDeployerMBean;
/*     */ import org.jboss.web.WebApplication;
/*     */ 
/*     */ public class JNDIView extends ServiceMBeanSupport
/*     */   implements JNDIViewMBean
/*     */ {
/*  68 */   protected static final String[] g_haAttributes = { "BindAddress", "Port" };
/*     */   protected String haNamingService;
/*     */ 
/*     */   public String list(boolean verbose)
/*     */   {
/*  91 */     StringBuffer buffer = new StringBuffer(4096);
/*  92 */     Context context = null;
/*  93 */     ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/*  99 */       Iterator it = (Iterator)this.server.getAttribute(AbstractWebDeployerMBean.OBJECT_NAME, "DeployedApplications");
/*     */ 
/* 101 */       if (it.hasNext() == true)
/*     */       {
/* 103 */         buffer.append("<h1>Web Applications</h1>\n");
/*     */       }
/*     */ 
/* 106 */       while (it.hasNext() == true)
/*     */       {
/* 108 */         WebApplication webApplication = (WebApplication)it.next();
/*     */ 
/* 110 */         Thread.currentThread().setContextClassLoader(webApplication.getMetaData().getENCLoader());
/*     */ 
/* 112 */         buffer.append("<h2>java:comp namespace of the " + webApplication.getCanonicalName() + " application:</h2>\n");
/*     */         try
/*     */         {
/* 117 */           context = new InitialContext();
/* 118 */           context = (Context)context.lookup("java:comp");
/*     */         }
/*     */         catch (NamingException e)
/*     */         {
/* 122 */           buffer.append("Failed on lookup, " + e.toString(true));
/* 123 */           formatException(buffer, e);
/* 124 */         }continue;
/*     */ 
/* 126 */         buffer.append("<pre>\n");
/* 127 */         list(context, " ", buffer, verbose);
/* 128 */         buffer.append("</pre>\n");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 134 */       this.log.debug("Unable to list web applications ENC", e);
/*     */     }
/*     */ 
/* 139 */     Set ejbModules = null;
/*     */     try
/*     */     {
/* 142 */       ejbModules = this.server.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 146 */       this.log.error("getDeployedApplications failed", e);
/* 147 */       buffer.append("Failed to getDeployedApplications\n");
/* 148 */       formatException(buffer, e);
/* 149 */       buffer.insert(0, "<pre>");
/* 150 */       buffer.append("</pre>");
/* 151 */       return buffer.toString();
/*     */     }
/*     */ 
/* 155 */     HashSet ejb2Ids = new HashSet();
/* 156 */     for (Iterator i = ejbModules.iterator(); i.hasNext(); )
/*     */     {
/* 158 */       ObjectName app = (ObjectName)i.next();
/* 159 */       String module = app.getKeyProperty("module");
/* 160 */       if (module == null)
/* 161 */         module = app.toString();
/* 162 */       buffer.append("<h1>Ejb 2.1 Module: " + module + "</h1>\n");
/*     */       try
/*     */       {
/* 165 */         Collection containers = (Collection)this.server.getAttribute(app, "Containers");
/* 166 */         for (iter = containers.iterator(); iter.hasNext(); )
/*     */         {
/* 168 */           Container con = (Container)iter.next();
/*     */ 
/* 173 */           Thread.currentThread().setContextClassLoader(con.getClassLoader());
/* 174 */           String bean = con.getBeanMetaData().getEjbName();
/* 175 */           Object on = con.getJmxName();
/* 176 */           buffer.append("<h2>java:comp namespace of the " + bean + " bean:</h2>\n");
/*     */ 
/* 178 */           context = (Context)ENCFactory.getEncById().get(on);
/* 179 */           ejb2Ids.add(on);
/* 180 */           if (context == null)
/*     */           {
/* 182 */             buffer.append("Failed to retrieve context for " + on);
/* 183 */             continue;
/*     */           }
/* 185 */           buffer.append("<pre>\n");
/* 186 */           list(context, " ", buffer, verbose);
/* 187 */           buffer.append("</pre>\n");
/*     */         }
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/*     */         Iterator iter;
/* 192 */         this.log.error("getConainers failed", e);
/* 193 */         buffer.append("<pre>");
/* 194 */         buffer.append("Failed to get ejbs in module\n");
/* 195 */         formatException(buffer, e);
/* 196 */         buffer.append("</pre>");
/*     */       }
/*     */     }
/*     */ 
/* 200 */     buffer.append("<h1> Other components with java:comp namespace</h1>\n");
/* 201 */     for (Iterator i$ = ENCFactory.getEncById().keySet().iterator(); i$.hasNext(); ) { Object key = i$.next();
/*     */ 
/* 204 */       if (!ejb2Ids.contains(key)) {
/* 205 */         context = (Context)ENCFactory.getEncById().get(key);
/* 206 */         buffer.append("<h2>java:comp namespace of the component " + key + " :</h2>\n");
/* 207 */         buffer.append("<pre>\n");
/* 208 */         list(context, " ", buffer, verbose);
/* 209 */         buffer.append("</pre>\n");
/*     */       }
/*     */     }
/*     */ 
/* 213 */     Thread.currentThread().setContextClassLoader(currentLoader);
/*     */     try
/*     */     {
/* 216 */       context = new InitialContext();
/* 217 */       context = (Context)context.lookup("java:");
/* 218 */       buffer.append("<h1>java: Namespace</h1>\n");
/* 219 */       buffer.append("<pre>\n");
/* 220 */       list(context, " ", buffer, verbose);
/* 221 */       buffer.append("</pre>\n");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 225 */       this.log.error("lookup for java: failed", e);
/* 226 */       buffer.append("Failed to get InitialContext, " + e.toString(true));
/* 227 */       formatException(buffer, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 233 */       context = new InitialContext();
/* 234 */       buffer.append("<h1>Global JNDI Namespace</h1>\n");
/* 235 */       buffer.append("<pre>\n");
/* 236 */       list(context, " ", buffer, verbose);
/* 237 */       buffer.append("</pre>\n");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 241 */       this.log.error("Failed to get InitialContext", e);
/* 242 */       buffer.append("Failed to get InitialContext, " + e.toString(true));
/* 243 */       formatException(buffer, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 249 */       String url = getHAUrl();
/* 250 */       if (url != null)
/*     */       {
/* 252 */         Hashtable env = new Hashtable();
/* 253 */         env.put("java.naming.provider.url", url);
/* 254 */         context = new InitialContext(env);
/* 255 */         buffer.append("<h1>HA-JNDI Namespace</h1>\n");
/* 256 */         buffer.append("<pre>\n");
/* 257 */         list(context, " ", buffer, verbose);
/* 258 */         buffer.append("</pre>\n");
/*     */       }
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 263 */       this.log.error("Failed to get InitialContext", ne);
/* 264 */       buffer.append("Failed to get InitialContext, " + ne.toString(true));
/* 265 */       formatException(buffer, ne);
/*     */     }
/* 267 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String listXML()
/*     */   {
/* 279 */     StringBuffer buffer = new StringBuffer(4096);
/* 280 */     Set ejbModules = null;
/* 281 */     Context context = null;
/* 282 */     ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 284 */     openJndiTag(buffer);
/*     */     try
/*     */     {
/* 289 */       Iterator it = (Iterator)this.server.getAttribute(AbstractWebDeployerMBean.OBJECT_NAME, "DeployedApplications");
/*     */ 
/* 291 */       while (it.hasNext() == true)
/*     */       {
/* 293 */         WebApplication webApplication = (WebApplication)it.next();
/* 294 */         openWebModuleTag(buffer, webApplication.getCanonicalName());
/*     */ 
/* 296 */         Thread.currentThread().setContextClassLoader(webApplication.getMetaData().getENCLoader());
/*     */         try
/*     */         {
/* 300 */           context = new InitialContext();
/* 301 */           context = (Context)context.lookup("java:comp");
/*     */ 
/* 303 */           listXML(context, buffer);
/*     */         }
/*     */         catch (NamingException e)
/*     */         {
/* 307 */           buffer.append("Failed on lookup, " + e.toString(true));
/* 308 */           formatException(buffer, e);
/*     */         }
/*     */         finally
/*     */         {
/* 313 */           closeWebModuleTag(buffer);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 319 */       this.log.debug("Unable to list web applications ENC", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 327 */       ejbModules = this.server.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 331 */       this.log.error("getDeployedApplications failed", e);
/* 332 */       appendErrorTag(buffer, "Failed to getDeployedApplications " + e.toString());
/*     */ 
/* 334 */       closeJndiTag(buffer);
/* 335 */       return buffer.toString();
/*     */     }
/*     */ 
/* 338 */     HashSet ejb2Ids = new HashSet();
/*     */ 
/* 340 */     for (Iterator i = ejbModules.iterator(); i.hasNext(); )
/*     */     {
/* 342 */       ObjectName app = (ObjectName)i.next();
/* 343 */       openEjbModuleTag(buffer, app.getKeyProperty("url"));
/*     */ 
/* 345 */       Collection containers = null;
/*     */       try
/*     */       {
/* 349 */         containers = (Collection)this.server.getAttribute(app, "Containers");
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 353 */         this.log.error("getContainers failed", t);
/* 354 */         appendPreExceptionTag(buffer, "Failed to get ejbs in module", t);
/*     */       }
/*     */ 
/* 357 */       for (Iterator iter = containers.iterator(); iter.hasNext(); )
/*     */       {
/* 359 */         Container con = (Container)iter.next();
/* 360 */         Object on = con.getJmxName();
/* 361 */         ejb2Ids.add(on);
/*     */ 
/* 366 */         Thread.currentThread().setContextClassLoader(con.getClassLoader());
/* 367 */         String bean = con.getBeanMetaData().getEjbName();
/* 368 */         openContextTag(buffer);
/* 369 */         appendBeanTag(buffer, bean);
/* 370 */         Context context1 = (Context)ENCFactory.getEncById().get(on);
/* 371 */         if (context1 == null)
/*     */         {
/* 373 */           appendErrorTag(buffer, "Failed to find ENC of EJB: " + on);
/*     */ 
/* 375 */           context1 = null;
/*     */         }
/*     */ 
/* 378 */         if (context1 != null)
/*     */         {
/*     */           try
/*     */           {
/* 382 */             listXML(context1, buffer);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 386 */             appendErrorTag(buffer, "Failed on list contents, " + t.toString());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 391 */         closeContextTag(buffer);
/*     */       }
/*     */ 
/* 394 */       closeEjbModuleTag(buffer);
/*     */     }
/*     */ 
/* 398 */     for (Iterator i$ = ENCFactory.getEncById().keySet().iterator(); i$.hasNext(); ) { Object key = i$.next();
/*     */ 
/* 401 */       if (!ejb2Ids.contains(key)) {
/* 402 */         context = (Context)ENCFactory.getEncById().get(key);
/* 403 */         buffer.append("<other-encs>");
/* 404 */         openContextTag(buffer);
/* 405 */         appendBeanTag(buffer, key.toString());
/* 406 */         listXML(context, buffer);
/* 407 */         closeContextTag(buffer);
/* 408 */         buffer.append("</other-encs>");
/*     */       }
/*     */     }
/* 411 */     Thread.currentThread().setContextClassLoader(currentLoader);
/*     */     try
/*     */     {
/* 414 */       context = new InitialContext();
/* 415 */       context = (Context)context.lookup("java:");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 419 */       this.log.error("Failed to get InitialContext for (java:)", e);
/* 420 */       appendErrorTag(buffer, "Failed to get InitialContext for (java:), " + e.toString(true));
/*     */     }
/*     */ 
/* 425 */     if (context != null)
/*     */     {
/* 427 */       openContextTag(buffer);
/* 428 */       appendJavaNameTag(buffer);
/*     */       try
/*     */       {
/* 431 */         listXML(context, buffer);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 435 */         this.log.error("Failed to list contents of (java:)", t);
/* 436 */         appendErrorTag(buffer, "Failed to list contents of (java:), " + t.toString());
/*     */       }
/*     */ 
/* 440 */       closeContextTag(buffer);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 447 */       context = new InitialContext();
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 451 */       this.log.error("Failed to get InitialContext", e);
/* 452 */       appendErrorTag(buffer, "Failed to get InitialContext, " + e.toString(true));
/*     */     }
/*     */ 
/* 456 */     if (context != null)
/*     */     {
/* 458 */       openContextTag(buffer);
/* 459 */       appendGlobalNameTag(buffer);
/*     */       try
/*     */       {
/* 462 */         listXML(context, buffer);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 466 */         this.log.error("Failed to list global contents ", t);
/* 467 */         appendErrorTag(buffer, "Failed to list global contents, " + t.toString());
/*     */       }
/*     */ 
/* 470 */       closeContextTag(buffer);
/*     */     }
/*     */ 
/* 475 */     String url = null;
/*     */     try
/*     */     {
/* 478 */       url = getHAUrl();
/* 479 */       if (url != null)
/*     */       {
/* 481 */         Hashtable env = new Hashtable();
/* 482 */         env.put("java.naming.provider.url", url);
/* 483 */         context = new InitialContext(env);
/*     */       }
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 488 */       this.log.error("Failed to get InitialContext", e);
/* 489 */       appendErrorTag(buffer, "Failed to get InitialContext, " + e.toString(true));
/*     */     }
/*     */ 
/* 493 */     if ((url != null) && (context != null))
/*     */     {
/* 495 */       openContextTag(buffer);
/* 496 */       appendHANameTag(buffer);
/*     */       try
/*     */       {
/* 499 */         listXML(context, buffer);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 503 */         this.log.error("Failed to list HA-JNDI contents ", t);
/* 504 */         appendErrorTag(buffer, "Failed to list HA-JNDI contents, " + t.toString());
/*     */       }
/*     */ 
/* 507 */       closeContextTag(buffer);
/*     */     }
/*     */ 
/* 511 */     closeJndiTag(buffer);
/*     */ 
/* 513 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String getHANamingService()
/*     */   {
/* 518 */     return this.haNamingService;
/*     */   }
/*     */ 
/*     */   public void setHANamingService(String serviceName)
/*     */   {
/* 523 */     this.haNamingService = serviceName;
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 529 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   private void list(Context ctx, String indent, StringBuffer buffer, boolean verbose)
/*     */   {
/* 534 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 537 */       NamingEnumeration ne = ctx.list("");
/* 538 */       while (ne.hasMore())
/*     */       {
/* 540 */         NameClassPair pair = (NameClassPair)ne.next();
/* 541 */         this.log.trace("pair: " + pair);
/*     */ 
/* 543 */         String name = pair.getName();
/* 544 */         String className = pair.getClassName();
/* 545 */         boolean recursive = false;
/* 546 */         boolean isLinkRef = false;
/* 547 */         boolean isProxy = false;
/* 548 */         Class c = null;
/*     */         try
/*     */         {
/* 551 */           c = loader.loadClass(className);
/* 552 */           this.log.trace("type: " + c);
/*     */ 
/* 554 */           if (Context.class.isAssignableFrom(c))
/* 555 */             recursive = true;
/* 556 */           if (LinkRef.class.isAssignableFrom(c)) {
/* 557 */             isLinkRef = true;
/*     */           }
/* 559 */           isProxy = Proxy.isProxyClass(c);
/*     */         }
/*     */         catch (ClassNotFoundException cnfe)
/*     */         {
/* 564 */           if (className.startsWith("$Proxy"))
/*     */           {
/* 566 */             isProxy = true;
/*     */             try
/*     */             {
/* 570 */               Object p = ctx.lookup(name);
/* 571 */               c = p.getClass();
/*     */             }
/*     */             catch (NamingException e)
/*     */             {
/* 575 */               Throwable t = e.getRootCause();
/* 576 */               if ((t instanceof ClassNotFoundException))
/*     */               {
/* 579 */                 String msg = t.getMessage();
/* 580 */                 if (msg != null)
/*     */                 {
/* 583 */                   className = msg;
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 590 */         buffer.append(indent + " +- " + name);
/*     */ 
/* 593 */         if (isLinkRef)
/*     */         {
/*     */           try
/*     */           {
/* 598 */             this.log.trace("looking up LinkRef; name=" + name);
/* 599 */             Object obj = ctx.lookupLink(name);
/* 600 */             this.log.trace("Object type: " + obj.getClass());
/*     */ 
/* 602 */             LinkRef link = (LinkRef)obj;
/* 603 */             buffer.append("[link -> ");
/* 604 */             buffer.append(link.getLinkName());
/* 605 */             buffer.append(']');
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 609 */             this.log.debug("Invalid LinkRef for: " + name, t);
/* 610 */             buffer.append("invalid]");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 615 */         if (isProxy)
/*     */         {
/* 617 */           buffer.append(" (proxy: " + pair.getClassName());
/* 618 */           if (c != null)
/*     */           {
/* 620 */             Class[] ifaces = c.getInterfaces();
/* 621 */             buffer.append(" implements ");
/* 622 */             for (int i = 0; i < ifaces.length; i++)
/*     */             {
/* 624 */               buffer.append(ifaces[i]);
/* 625 */               buffer.append(',');
/*     */             }
/* 627 */             buffer.setCharAt(buffer.length() - 1, ')');
/*     */           }
/*     */           else
/*     */           {
/* 631 */             buffer.append(" implements " + className + ")");
/*     */           }
/*     */         }
/* 634 */         else if (verbose)
/*     */         {
/* 636 */           buffer.append(" (class: " + pair.getClassName() + ")");
/*     */         }
/*     */ 
/* 639 */         buffer.append('\n');
/* 640 */         if (recursive)
/*     */         {
/*     */           try
/*     */           {
/* 644 */             Object value = ctx.lookup(name);
/* 645 */             if ((value instanceof Context))
/*     */             {
/* 647 */               Context subctx = (Context)value;
/* 648 */               list(subctx, indent + " |  ", buffer, verbose);
/*     */             }
/*     */             else
/*     */             {
/* 652 */               buffer.append(indent + " |   NonContext: " + value);
/* 653 */               buffer.append('\n');
/*     */             }
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 658 */             buffer.append("Failed to lookup: " + name + ", errmsg=" + t.getMessage());
/* 659 */             buffer.append('\n');
/*     */           }
/*     */         }
/*     */       }
/* 663 */       ne.close();
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 667 */       buffer.append("error while listing context " + ctx.toString() + ": " + ne.toString(true));
/* 668 */       formatException(buffer, ne);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void listXML(Context ctx, StringBuffer buffer)
/*     */   {
/* 674 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 677 */       NamingEnumeration ne = ctx.list("");
/* 678 */       while (ne.hasMore())
/*     */       {
/* 680 */         NameClassPair pair = (NameClassPair)ne.next();
/* 681 */         boolean recursive = false;
/* 682 */         boolean isLinkRef = false;
/*     */         try
/*     */         {
/* 685 */           Class c = loader.loadClass(pair.getClassName());
/* 686 */           if (Context.class.isAssignableFrom(c))
/* 687 */             recursive = true;
/* 688 */           if (LinkRef.class.isAssignableFrom(c)) {
/* 689 */             isLinkRef = true;
/*     */           }
/*     */         }
/*     */         catch (ClassNotFoundException cnfe)
/*     */         {
/*     */         }
/* 695 */         String name = pair.getName();
/* 696 */         if (isLinkRef)
/*     */         {
/* 698 */           Object obj = null;
/* 699 */           LinkRef link = null;
/*     */           try
/*     */           {
/* 702 */             obj = ctx.lookupLink(name);
/* 703 */             link = (LinkRef)obj;
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 707 */             this.log.error("Invalid LinkRef for: " + name, t);
/*     */ 
/* 709 */             appendLinkRefErrorTag(buffer);
/*     */           }
/*     */ 
/* 712 */           appendLinkRefTag(buffer, link, pair);
/*     */         }
/* 716 */         else if (recursive)
/*     */         {
/* 718 */           Object value = null;
/*     */           try
/*     */           {
/* 722 */             value = ctx.lookup(name);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 726 */             appendErrorTag(buffer, "Failed to lookup: " + name + ", errmsg=" + t.getMessage());
/*     */           }
/*     */ 
/* 731 */           if ((value instanceof Context))
/*     */           {
/* 733 */             Context subctx = (Context)value;
/* 734 */             openContextTag(buffer);
/* 735 */             appendNCPTag(buffer, pair);
/*     */             try
/*     */             {
/* 739 */               listXML(subctx, buffer);
/*     */             }
/*     */             catch (Throwable t)
/*     */             {
/* 743 */               appendErrorTag(buffer, "Failed to list contents of: " + name + ", errmsg=" + t.getMessage());
/*     */             }
/*     */ 
/* 748 */             closeContextTag(buffer);
/*     */           }
/*     */           else
/*     */           {
/* 752 */             appendNonContextTag(buffer, pair);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 757 */           appendLeafTag(buffer, pair);
/*     */         }
/*     */       }
/*     */ 
/* 761 */       ne.close();
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 765 */       appendErrorTag(buffer, "error while listing context " + ctx.toString() + ": " + ne.toString(true));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void openJndiTag(StringBuffer buffer)
/*     */   {
/* 773 */     buffer.append("<jndi>\n");
/*     */   }
/*     */ 
/*     */   private void closeJndiTag(StringBuffer buffer)
/*     */   {
/* 778 */     buffer.append("</jndi>\n");
/*     */   }
/*     */ 
/*     */   private void openWebModuleTag(StringBuffer buffer, String file)
/*     */   {
/* 783 */     buffer.append("<webmodule>\n");
/* 784 */     buffer.append("<file>").append(file).append("</file>\n");
/*     */   }
/*     */ 
/*     */   private void closeWebModuleTag(StringBuffer buffer)
/*     */   {
/* 789 */     buffer.append("</webmodule>\n");
/*     */   }
/*     */ 
/*     */   private void openEjbModuleTag(StringBuffer buffer, String file)
/*     */   {
/* 794 */     buffer.append("<ejbmodule>\n");
/* 795 */     buffer.append("<file>" + file + "</file>\n");
/*     */   }
/*     */ 
/*     */   private void closeEjbModuleTag(StringBuffer buffer)
/*     */   {
/* 800 */     buffer.append("</ejbmodule>\n");
/*     */   }
/*     */ 
/*     */   private void appendPreExceptionTag(StringBuffer buffer, String msg, Throwable t)
/*     */   {
/* 807 */     buffer.append("<pre>\n" + msg + "\n");
/* 808 */     formatException(buffer, t);
/* 809 */     buffer.append("</pre>\n");
/*     */   }
/*     */ 
/*     */   private void appendBeanTag(StringBuffer buffer, String bean)
/*     */   {
/* 814 */     buffer.append("<name>java:comp</name>\n");
/* 815 */     buffer.append("<attribute name='bean'>" + bean + "</attribute>\n");
/*     */   }
/*     */ 
/*     */   private void appendJavaNameTag(StringBuffer buffer)
/*     */   {
/* 820 */     buffer.append("<name>java:</name>\n");
/*     */   }
/*     */ 
/*     */   private void appendGlobalNameTag(StringBuffer buffer)
/*     */   {
/* 825 */     buffer.append("<name>Global</name>\n");
/*     */   }
/*     */ 
/*     */   private void appendHANameTag(StringBuffer buffer)
/*     */   {
/* 830 */     buffer.append("<name>HA</name>\n");
/*     */   }
/*     */ 
/*     */   private void appendLinkRefTag(StringBuffer buffer, LinkRef link, NameClassPair ncp)
/*     */   {
/* 837 */     buffer.append("<link-ref>\n");
/* 838 */     buffer.append("<name>" + ncp.getName() + "</name>\n");
/*     */     try
/*     */     {
/* 841 */       String lName = link.getLinkName();
/* 842 */       buffer.append("<link>" + lName + "</link>\n");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 846 */       appendErrorTag(buffer, "Failed to getLinkName, " + e.toString(true));
/*     */     }
/*     */ 
/* 849 */     buffer.append("<attribute name='class'>" + ncp.getClassName() + "</attribute>\n");
/*     */ 
/* 851 */     buffer.append("</link-ref>\n");
/*     */   }
/*     */ 
/*     */   private void appendLinkRefErrorTag(StringBuffer buffer)
/*     */   {
/* 856 */     buffer.append("<link-ref>\n");
/* 857 */     buffer.append("<name>Invalid</name>\n");
/* 858 */     buffer.append("</link-ref>\n");
/*     */   }
/*     */ 
/*     */   private void openContextTag(StringBuffer buffer)
/*     */   {
/* 863 */     buffer.append("<context>\n");
/*     */   }
/*     */ 
/*     */   private void closeContextTag(StringBuffer buffer)
/*     */   {
/* 868 */     buffer.append("</context>\n");
/*     */   }
/*     */ 
/*     */   private void appendNonContextTag(StringBuffer buffer, NameClassPair ncp)
/*     */   {
/* 873 */     buffer.append("<non-context>\n");
/* 874 */     appendNCPTag(buffer, ncp);
/* 875 */     buffer.append("</non-context>\n");
/*     */   }
/*     */ 
/*     */   private void appendLeafTag(StringBuffer buffer, NameClassPair ncp)
/*     */   {
/* 880 */     buffer.append("<leaf>\n");
/* 881 */     appendNCPTag(buffer, ncp);
/* 882 */     buffer.append("</leaf>\n");
/*     */   }
/*     */ 
/*     */   private void appendNCPTag(StringBuffer buffer, NameClassPair ncp)
/*     */   {
/* 887 */     buffer.append("<name>" + ncp.getName() + "</name>\n");
/* 888 */     buffer.append("<attribute name='class'>" + ncp.getClassName() + "</attribute>\n");
/*     */   }
/*     */ 
/*     */   private void appendErrorTag(StringBuffer buffer, String msg)
/*     */   {
/* 894 */     buffer.append("<error>\n");
/* 895 */     buffer.append("<message>" + msg + "</message>\n");
/* 896 */     buffer.append("</error>\n");
/*     */   }
/*     */ 
/*     */   private void formatException(StringBuffer buffer, Throwable t)
/*     */   {
/* 901 */     StringWriter sw = new StringWriter();
/* 902 */     PrintWriter pw = new PrintWriter(sw);
/* 903 */     buffer.append("<pre>\n");
/* 904 */     t.printStackTrace(pw);
/* 905 */     buffer.append(sw.toString());
/* 906 */     buffer.append("</pre>\n");
/*     */   }
/*     */ 
/*     */   private String getHAUrl()
/*     */   {
/* 911 */     String bindAddress = null;
/* 912 */     String portNumber = null;
/*     */ 
/* 914 */     AttributeList list = getHAJndiAttributes();
/*     */ 
/* 916 */     if (list == null) {
/* 917 */       return null;
/*     */     }
/*     */ 
/* 920 */     Object o = list.get(0);
/* 921 */     if (o != null) {
/* 922 */       bindAddress = ((Attribute)o).getValue().toString();
/*     */     }
/*     */ 
/* 925 */     o = list.get(1);
/* 926 */     if (o != null) {
/* 927 */       portNumber = ((Attribute)o).getValue().toString();
/*     */     }
/* 929 */     if ((bindAddress != null) && (portNumber != null)) {
/* 930 */       return "jnp://" + bindAddress + ":" + portNumber;
/*     */     }
/* 932 */     return null;
/*     */   }
/*     */ 
/*     */   private AttributeList getHAJndiAttributes()
/*     */   {
/* 937 */     if (this.haNamingService == null)
/*     */     {
/* 940 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 945 */       ObjectName name = new ObjectName(this.haNamingService);
/* 946 */       return this.server.getAttributes(name, g_haAttributes);
/*     */     }
/*     */     catch (InstanceNotFoundException e1)
/*     */     {
/* 951 */       return null;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 956 */       this.log.error("JNDIView.getHAJndiAttributes() failed", e);
/* 957 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.JNDIView
 * JD-Core Version:    0.6.0
 */