/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.AuthenticationException;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.InitialContextFactory;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.security.auth.login.LoginContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
/*     */ import org.jboss.aspects.remoting.IsLocalInterceptor;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.aspects.security.SecurityClientInterceptor;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.auth.callback.UsernamePasswordHandler;
/*     */ import org.jnp.interfaces.Naming;
/*     */ import org.jnp.interfaces.NamingContext;
/*     */ 
/*     */ public class JBossRemotingContextFactory
/*     */   implements InitialContextFactory, ObjectFactory
/*     */ {
/*     */   static void associateSecurityInformation(Object principal, Object credentials)
/*     */   {
/*     */     Principal securityPrincipal;
/*     */     Principal securityPrincipal;
/*  77 */     if ((principal instanceof Principal))
/*     */     {
/*  79 */       securityPrincipal = (Principal)principal;
/*     */     }
/*     */     else
/*     */     {
/*  84 */       String username = principal.toString();
/*  85 */       securityPrincipal = new SimplePrincipal(username);
/*     */     }
/*     */ 
/*  88 */     SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials);
/*     */   }
/*     */ 
/*     */   static void login(Object principal, Object credentials, Object prop) throws AuthenticationException
/*     */   {
/*  93 */     String protocol = prop.toString();
/*     */     try
/*     */     {
/*     */       String username;
/*     */       String username;
/*  98 */       if ((principal instanceof Principal))
/*     */       {
/* 100 */         Principal p = (Principal)principal;
/* 101 */         username = p.getName();
/*     */       }
/*     */       else
/*     */       {
/* 105 */         username = principal.toString();
/*     */       }
/* 107 */       UsernamePasswordHandler handler = new UsernamePasswordHandler(username, credentials);
/*     */ 
/* 110 */       LoginContext lc = new LoginContext(protocol, handler);
/* 111 */       lc.login();
/*     */     }
/*     */     catch (LoginException e)
/*     */     {
/* 115 */       AuthenticationException ex = new AuthenticationException("Failed to login using protocol=" + protocol);
/* 116 */       ex.setRootCause(e);
/* 117 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Context getInitialContext(Hashtable env)
/*     */     throws NamingException
/*     */   {
/* 125 */     Class[] interfaces = { Naming.class };
/*     */ 
/* 130 */     Object credentials = env.get("java.naming.security.credentials");
/* 131 */     Object principal = env.get("java.naming.security.principal");
/* 132 */     Object protocol = env.get("java.naming.security.protocol");
/*     */     Interceptor[] interceptors;
/*     */     Interceptor[] interceptors;
/* 134 */     if ((principal != null) && (credentials != null))
/*     */     {
/* 136 */       if (protocol != null)
/*     */       {
/* 138 */         login(principal, credentials, protocol);
/*     */       }
/*     */       else
/*     */       {
/* 142 */         associateSecurityInformation(principal, credentials);
/*     */       }
/* 144 */       Interceptor[] tmp = { IsLocalInterceptor.singleton, SecurityClientInterceptor.singleton, InvokeRemoteInterceptor.singleton };
/* 145 */       interceptors = tmp;
/*     */     }
/*     */     else
/*     */     {
/* 149 */       Interceptor[] tmp = { IsLocalInterceptor.singleton, InvokeRemoteInterceptor.singleton };
/* 150 */       interceptors = tmp;
/*     */     }
/*     */ 
/* 153 */     if (NamingContext.localServer != null) return new NamingContext(env, null, NamingContext.localServer);
/*     */ 
/* 155 */     String providerUrl = (String)env.get("java.naming.provider.url");
/* 156 */     if (providerUrl == null)
/*     */     {
/* 158 */       throw new RuntimeException("PROVIDER_URL not provided in jndi.properties.  Automatic discovery not implemented yet.");
/*     */     }Naming naming;
/*     */     try {
/* 162 */       naming = (Naming)Remoting.createPojiProxy("JNDI", interfaces, providerUrl, interceptors);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 166 */       throw new RuntimeException("Unable to create Naming proxy", e);
/*     */     }
/*     */ 
/* 169 */     return new NamingContext(env, null, naming);
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 179 */     Context ctx = getInitialContext(environment);
/* 180 */     Reference ref = (Reference)obj;
/* 181 */     return ctx.lookup((String)ref.get("URL").getContent());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.JBossRemotingContextFactory
 * JD-Core Version:    0.6.0
 */