/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.net.URL;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.naming.CompositeName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.Referenceable;
/*     */ import javax.naming.ldap.Control;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class ExternalContext extends ServiceMBeanSupport
/*     */   implements ExternalContextMBean
/*     */ {
/*     */   private boolean remoteAccess;
/*  71 */   private SerializableInitialContext contextInfo = new SerializableInitialContext();
/*     */ 
/*     */   public ExternalContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ExternalContext(String jndiName, String contextPropsURL)
/*     */     throws IOException, NamingException
/*     */   {
/*  84 */     setJndiName(jndiName);
/*  85 */     setPropertiesURL(contextPropsURL);
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  95 */     return this.contextInfo.getJndiName();
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */     throws NamingException
/*     */   {
/* 105 */     this.contextInfo.setJndiName(jndiName);
/* 106 */     if (super.getState() == 3)
/*     */     {
/* 108 */       unbind(jndiName);
/*     */       try
/*     */       {
/* 111 */         rebind();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 115 */         NamingException ne = new NamingException("Failed to update jndiName");
/* 116 */         ne.setRootCause(e);
/* 117 */         throw ne;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getRemoteAccess()
/*     */   {
/* 127 */     return this.remoteAccess;
/*     */   }
/*     */ 
/*     */   public void setRemoteAccess(boolean remoteAccess)
/*     */   {
/* 135 */     this.remoteAccess = remoteAccess;
/*     */   }
/*     */ 
/*     */   public boolean getCacheContext()
/*     */   {
/* 143 */     return this.contextInfo.getCacheContext();
/*     */   }
/*     */ 
/*     */   public void setCacheContext(boolean cacheContext)
/*     */   {
/* 151 */     this.contextInfo.setCacheContext(cacheContext);
/*     */   }
/*     */ 
/*     */   public String getInitialContext()
/*     */   {
/* 169 */     return this.contextInfo.getInitialContext();
/*     */   }
/*     */ 
/*     */   public void setInitialContext(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/* 187 */     this.contextInfo.loadClass(className);
/*     */   }
/*     */ 
/*     */   public void setPropertiesURL(String contextPropsURL)
/*     */     throws IOException
/*     */   {
/* 197 */     this.contextInfo.loadProperties(contextPropsURL);
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties props)
/*     */     throws IOException
/*     */   {
/* 207 */     this.contextInfo.setProperties(props);
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */     throws IOException
/*     */   {
/* 217 */     return this.contextInfo.getProperties();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 226 */     rebind();
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 235 */     if (this.contextInfo.getCacheContext())
/* 236 */       unbind(this.contextInfo.getJndiName());
/*     */   }
/*     */ 
/*     */   private static Context createContext(Context rootContext, Name name) throws NamingException
/*     */   {
/* 241 */     Context subctx = rootContext;
/* 242 */     for (int n = 0; n < name.size(); n++)
/*     */     {
/* 244 */       String atom = name.get(n);
/*     */       try
/*     */       {
/* 247 */         Object obj = subctx.lookup(atom);
/* 248 */         subctx = (Context)obj;
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 253 */         subctx = subctx.createSubcontext(atom);
/*     */       }
/*     */     }
/*     */ 
/* 257 */     return subctx;
/*     */   }
/*     */ 
/*     */   private void rebind() throws Exception
/*     */   {
/* 262 */     Context ctx = this.contextInfo.newContext();
/* 263 */     Context rootCtx = new InitialContext();
/*     */ 
/* 265 */     this.log.debug("ctx=" + ctx + ", env=" + ctx.getEnvironment());
/*     */ 
/* 268 */     String jndiName = this.contextInfo.getJndiName();
/* 269 */     Name fullName = rootCtx.getNameParser("").parse(jndiName);
/*     */ 
/* 271 */     this.log.debug("fullName=" + fullName);
/*     */ 
/* 273 */     Name parentName = fullName;
/* 274 */     if (fullName.size() > 1)
/* 275 */       parentName = fullName.getPrefix(fullName.size() - 1);
/*     */     else {
/* 277 */       parentName = new CompositeName();
/*     */     }
/* 279 */     this.log.debug("parentName=" + parentName);
/*     */ 
/* 281 */     Context parentCtx = createContext(rootCtx, parentName);
/*     */ 
/* 283 */     this.log.debug("parentCtx=" + parentCtx);
/*     */ 
/* 285 */     Name atomName = fullName.getSuffix(fullName.size() - 1);
/* 286 */     String atom = atomName.get(0);
/* 287 */     boolean cacheContext = this.contextInfo.getCacheContext();
/*     */ 
/* 289 */     if (this.remoteAccess == true)
/*     */     {
/* 292 */       parentCtx.rebind(atom, this.contextInfo);
/*     */ 
/* 296 */       if (cacheContext == true)
/*     */       {
/* 301 */         ctx = CachedContext.createProxyContext(ctx);
/* 302 */         NonSerializableFactory.rebind(jndiName, ctx);
/*     */       }
/*     */     }
/* 305 */     else if (cacheContext == true)
/*     */     {
/* 312 */       Context proxyCtx = CachedContext.createProxyContext(ctx);
/* 313 */       NonSerializableFactory.rebind(rootCtx, jndiName, proxyCtx);
/*     */     }
/*     */     else
/*     */     {
/* 321 */       parentCtx.rebind(atom, this.contextInfo);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void unbind(String jndiName)
/*     */   {
/*     */     try
/*     */     {
/* 329 */       Context rootCtx = new InitialContext();
/* 330 */       Context ctx = (Context)rootCtx.lookup(jndiName);
/* 331 */       if (ctx != null)
/* 332 */         ctx.close();
/* 333 */       rootCtx.unbind(jndiName);
/* 334 */       NonSerializableFactory.unbind(jndiName);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 338 */       this.log.error("unbind failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class CachedContext
/*     */     implements InvocationHandler
/*     */   {
/*     */     Context externalCtx;
/*     */ 
/*     */     CachedContext(Context externalCtx)
/*     */     {
/* 513 */       this.externalCtx = externalCtx;
/*     */     }
/*     */ 
/*     */     private static Class[] getAllUniqueInterfaces(Class c)
/*     */     {
/* 525 */       Set uniqueIfaces = new HashSet();
/* 526 */       while (c != null)
/*     */       {
/* 528 */         Class[] ifaces = c.getInterfaces();
/* 529 */         for (int n = 0; n < ifaces.length; n++)
/*     */         {
/* 531 */           uniqueIfaces.add(ifaces[n]);
/*     */         }
/* 533 */         c = c.getSuperclass();
/*     */       }
/* 535 */       return (Class[])(Class[])uniqueIfaces.toArray(new Class[uniqueIfaces.size()]);
/*     */     }
/*     */ 
/*     */     static Context createProxyContext(Context ctx)
/*     */     {
/* 540 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 544 */       Class[] interfaces = getAllUniqueInterfaces(ctx.getClass());
/* 545 */       InvocationHandler handler = new CachedContext(ctx);
/* 546 */       Context proxyCtx = (Context)Proxy.newProxyInstance(loader, interfaces, handler);
/* 547 */       return proxyCtx;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */     {
/* 552 */       Object value = null;
/* 553 */       if (!method.getName().equals("close"))
/*     */       {
/*     */         try
/*     */         {
/* 561 */           value = method.invoke(this.externalCtx, args);
/*     */         }
/*     */         catch (InvocationTargetException e)
/*     */         {
/* 565 */           throw e.getTargetException();
/*     */         }
/*     */       }
/* 568 */       return value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SerializableInitialContext extends RefAddr
/*     */     implements Referenceable, Serializable, ObjectFactory
/*     */   {
/*     */     private static final long serialVersionUID = -6512260531255770463L;
/*     */     private String jndiName;
/* 353 */     private Class contextClass = InitialContext.class;
/*     */     private Properties contextProps;
/* 355 */     private boolean cacheContext = true;
/*     */     private transient Context initialContext;
/*     */ 
/*     */     public SerializableInitialContext()
/*     */     {
/* 360 */       this("SerializableInitialContext");
/*     */     }
/*     */ 
/*     */     public SerializableInitialContext(String addrType)
/*     */     {
/* 365 */       super();
/*     */     }
/*     */ 
/*     */     public String getJndiName()
/*     */     {
/* 370 */       return this.jndiName;
/*     */     }
/*     */ 
/*     */     public void setJndiName(String jndiName)
/*     */     {
/* 375 */       this.jndiName = jndiName;
/*     */     }
/*     */ 
/*     */     public boolean getCacheContext()
/*     */     {
/* 380 */       return this.cacheContext;
/*     */     }
/*     */ 
/*     */     public void setCacheContext(boolean cacheContext)
/*     */     {
/* 385 */       this.cacheContext = cacheContext;
/*     */     }
/*     */ 
/*     */     public String getInitialContext()
/*     */     {
/* 390 */       return this.contextClass.getName();
/*     */     }
/*     */ 
/*     */     public void loadClass(String className) throws ClassNotFoundException
/*     */     {
/* 395 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 396 */       this.contextClass = loader.loadClass(className);
/*     */     }
/*     */ 
/*     */     public void setProperties(Properties props)
/*     */     {
/* 401 */       this.contextProps = props;
/*     */     }
/*     */ 
/*     */     public Properties getProperties()
/*     */     {
/* 406 */       return this.contextProps;
/*     */     }
/*     */ 
/*     */     public void loadProperties(String contextPropsURL) throws IOException
/*     */     {
/* 411 */       InputStream is = null;
/* 412 */       this.contextProps = new Properties();
/*     */       try
/*     */       {
/* 417 */         URL url = new URL(contextPropsURL);
/* 418 */         is = url.openStream();
/* 419 */         this.contextProps.load(is);
/* 420 */         return;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 424 */         is = null;
/*     */ 
/* 427 */         is = Thread.currentThread().getContextClassLoader().getResourceAsStream(contextPropsURL);
/* 428 */         if (is == null)
/*     */         {
/* 430 */           throw new IOException("Failed to locate context props as URL or resource:" + contextPropsURL);
/*     */         }
/* 432 */         this.contextProps.load(is);
/*     */       }
/*     */     }
/*     */ 
/*     */     Context newContext() throws Exception
/*     */     {
/* 438 */       this.initialContext = ((Context)NonSerializableFactory.lookup(this.jndiName));
/*     */ 
/* 440 */       if (this.initialContext == null)
/* 441 */         this.initialContext = newContext(this.contextClass, this.contextProps);
/* 442 */       return this.initialContext;
/*     */     }
/*     */ 
/*     */     static Context newContext(Class contextClass, Properties contextProps)
/*     */       throws Exception
/*     */     {
/* 448 */       Context ctx = null;
/*     */       try
/*     */       {
/* 451 */         ctx = newDefaultContext(contextClass, contextProps);
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 455 */         ctx = newLdapContext(contextClass, contextProps);
/*     */       }
/* 457 */       return ctx;
/*     */     }
/*     */ 
/*     */     private static Context newDefaultContext(Class contextClass, Properties contextProps)
/*     */       throws Exception
/*     */     {
/* 463 */       Context ctx = null;
/* 464 */       Class[] types = { Hashtable.class };
/* 465 */       Constructor ctor = contextClass.getConstructor(types);
/* 466 */       Object[] args = { contextProps };
/* 467 */       ctx = (Context)ctor.newInstance(args);
/* 468 */       return ctx;
/*     */     }
/*     */ 
/*     */     private static Context newLdapContext(Class contextClass, Properties contextProps)
/*     */       throws Exception
/*     */     {
/* 474 */       Context ctx = null;
/* 475 */       Class[] types = { Hashtable.class, [Ljavax.naming.ldap.Control.class };
/* 476 */       Constructor ctor = contextClass.getConstructor(types);
/* 477 */       Object[] args = { contextProps, null };
/* 478 */       ctx = (Context)ctor.newInstance(args);
/* 479 */       return ctx;
/*     */     }
/*     */ 
/*     */     public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */       throws Exception
/*     */     {
/* 485 */       Reference ref = (Reference)obj;
/* 486 */       SerializableInitialContext sic = (SerializableInitialContext)ref.get(0);
/* 487 */       return sic.newContext();
/*     */     }
/*     */ 
/*     */     public Reference getReference() throws NamingException
/*     */     {
/* 492 */       Reference ref = new Reference(Context.class.getName(), this, getClass().getName(), null);
/* 493 */       return ref;
/*     */     }
/*     */ 
/*     */     public Object getContent()
/*     */     {
/* 498 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.ExternalContext
 * JD-Core Version:    0.6.0
 */