/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jnp.interfaces.NamingContext;
/*     */ import org.jnp.server.NamingServer;
/*     */ 
/*     */ public class ENCFactory
/*     */   implements ObjectFactory
/*     */ {
/*  54 */   private static WeakHashMap classloaderKeyedEncs = new WeakHashMap();
/*     */   private static ClassLoader topLoader;
/*  56 */   private static ThreadLocalStack<Object> encIdStack = new ThreadLocalStack();
/*  57 */   private static ConcurrentHashMap<Object, Context> encById = new ConcurrentHashMap();
/*     */ 
/*     */   public static List<Object> getIdStack()
/*     */   {
/*  61 */     return encIdStack.getList();
/*     */   }
/*     */ 
/*     */   public static ConcurrentHashMap<Object, Context> getEncById()
/*     */   {
/*  66 */     return encById;
/*     */   }
/*     */ 
/*     */   public static void pushContextId(Object id)
/*     */   {
/*  71 */     encIdStack.push(id);
/*     */   }
/*     */ 
/*     */   public static Object popContextId()
/*     */   {
/*  76 */     return encIdStack.pop();
/*     */   }
/*     */ 
/*     */   public static Object getCurrentId()
/*     */   {
/*  81 */     return encIdStack.get();
/*     */   }
/*     */ 
/*     */   public static void setTopClassLoader(ClassLoader topLoader)
/*     */   {
/*  87 */     topLoader = topLoader;
/*     */   }
/*     */ 
/*     */   public static ClassLoader getTopClassLoader() {
/*  91 */     return topLoader;
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 107 */     Object currentId = encIdStack.get();
/* 108 */     if (currentId != null)
/*     */     {
/* 110 */       Context compCtx = (Context)encById.get(currentId);
/* 111 */       if (compCtx == null)
/*     */       {
/* 113 */         compCtx = createContext(environment);
/* 114 */         encById.put(currentId, compCtx);
/*     */       }
/* 116 */       return compCtx;
/*     */     }
/*     */ 
/* 119 */     ClassLoader ctxClassLoader = GetTCLAction.getContextClassLoader();
/* 120 */     synchronized (classloaderKeyedEncs)
/*     */     {
/* 122 */       Context compCtx = (Context)classloaderKeyedEncs.get(ctxClassLoader);
/*     */ 
/* 127 */       if (compCtx == null)
/*     */       {
/* 129 */         ClassLoader loader = ctxClassLoader;
/* 130 */         GetParentAction action = new GetParentAction(ctxClassLoader);
/* 131 */         while ((loader != null) && (loader != topLoader) && (compCtx == null))
/*     */         {
/* 133 */           compCtx = (Context)classloaderKeyedEncs.get(loader);
/* 134 */           loader = action.getParent();
/*     */         }
/*     */ 
/* 137 */         if (compCtx == null)
/*     */         {
/* 139 */           compCtx = createContext(environment);
/* 140 */           classloaderKeyedEncs.put(ctxClassLoader, compCtx);
/*     */         }
/*     */       }
/* 143 */       return compCtx;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Context createContext(Hashtable environment)
/*     */     throws NamingException
/*     */   {
/* 151 */     NamingServer srv = new NamingServer();
/* 152 */     Context compCtx = new NamingContext(environment, null, srv);
/* 153 */     return compCtx;
/*     */   }
/*     */ 
/*     */   private static class GetParentAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     ClassLoader loader;
/*     */ 
/*     */     GetParentAction(ClassLoader loader)
/*     */     {
/* 176 */       this.loader = loader;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 180 */       ClassLoader parent = null;
/* 181 */       if (this.loader != null)
/*     */       {
/* 183 */         parent = this.loader.getParent();
/* 184 */         this.loader = parent;
/*     */       }
/* 186 */       return parent;
/*     */     }
/*     */ 
/*     */     ClassLoader getParent() {
/* 190 */       ClassLoader parent = (ClassLoader)AccessController.doPrivileged(this);
/* 191 */       return parent;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetTCLAction
/*     */     implements PrivilegedAction
/*     */   {
/* 158 */     static PrivilegedAction ACTION = new GetTCLAction();
/*     */ 
/*     */     public Object run() {
/* 161 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 162 */       return loader;
/*     */     }
/*     */ 
/*     */     static ClassLoader getContextClassLoader() {
/* 166 */       ClassLoader loader = (ClassLoader)AccessController.doPrivileged(ACTION);
/* 167 */       return loader;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.ENCFactory
 * JD-Core Version:    0.6.0
 */