/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import org.jnp.interfaces.NamingContextFactory;
/*     */ 
/*     */ public class BridgeNamingContextFactory extends NamingContextFactory
/*     */ {
/*     */   public Context getInitialContext(Hashtable env)
/*     */     throws NamingException
/*     */   {
/*  55 */     Context primaryCtx = super.getInitialContext(env);
/*  56 */     Context bridgeCtx = primaryCtx;
/*  57 */     Object providerURL2 = env.get("org.jboss.naming.provider.url2");
/*  58 */     if (providerURL2 != null)
/*     */     {
/*  61 */       Hashtable env2 = (Hashtable)env.clone();
/*  62 */       env2.put("java.naming.provider.url", providerURL2);
/*  63 */       Context secondaryCtx = super.getInitialContext(env2);
/*  64 */       InvocationHandler h = new BridgeContext(primaryCtx, secondaryCtx);
/*  65 */       Class[] interfaces = { Context.class };
/*  66 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  67 */       bridgeCtx = (Context)Proxy.newProxyInstance(loader, interfaces, h);
/*     */     }
/*  69 */     return bridgeCtx;
/*     */   }
/*     */ 
/*     */   static class BridgeContext
/*     */     implements InvocationHandler
/*     */   {
/*     */     private Context primaryCtx;
/*     */     private Context secondaryCtx;
/*     */ 
/*     */     BridgeContext(Context primaryCtx, Context secondaryCtx)
/*     */     {
/*  83 */       this.primaryCtx = primaryCtx;
/*  84 */       this.secondaryCtx = secondaryCtx;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object proxy, Method method, Object[] args)
/*     */       throws Throwable
/*     */     {
/*  90 */       Object value = null;
/*     */       try
/*     */       {
/*  94 */         value = method.invoke(this.primaryCtx, args);
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/*  98 */         Throwable t = e.getTargetException();
/*     */ 
/* 100 */         if (((t instanceof NameNotFoundException)) && (method.getName().equals("lookup")))
/*     */         {
/*     */           try
/*     */           {
/* 104 */             value = method.invoke(this.secondaryCtx, args);
/*     */           }
/*     */           catch (InvocationTargetException e1)
/*     */           {
/* 108 */             throw e1.getTargetException();
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 113 */           throw t;
/*     */         }
/*     */       }
/* 116 */       return value;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.BridgeNamingContextFactory
 * JD-Core Version:    0.6.0
 */