/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.monitor.Monitor;
/*     */ import javax.management.monitor.MonitorNotification;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MonitorRunnable extends SchedulableRunnable
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(MonitorRunnable.class);
/*     */ 
/*  55 */   static RunnableScheduler scheduler = new RunnableScheduler();
/*     */   private Monitor monitor;
/*     */   private ObjectName monitorName;
/*     */   private MonitorCallback callback;
/*     */   private Map observedObjects;
/*     */   private MBeanServer server;
/*     */ 
/*     */   public MonitorRunnable(Monitor monitor, ObjectName monitorName, MonitorCallback callback, Map observedObjects, MBeanServer server)
/*     */   {
/*  78 */     this.monitor = monitor;
/*  79 */     this.monitorName = monitorName;
/*  80 */     this.callback = callback;
/*  81 */     this.observedObjects = observedObjects;
/*  82 */     this.server = server;
/*  83 */     setScheduler(scheduler);
/*     */   }
/*     */ 
/*     */   void runMonitor(ObservedObject object)
/*     */   {
/*     */     try
/*     */     {
/* 102 */       MBeanInfo mbeanInfo = null;
/*     */       try
/*     */       {
/* 105 */         mbeanInfo = this.server.getMBeanInfo(object.getObjectName());
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/* 109 */         sendObjectErrorNotification(object, "The observed object is not registered.");
/* 110 */         return;
/*     */       }
/*     */ 
/* 114 */       MBeanAttributeInfo[] mbeanAttributeInfo = mbeanInfo.getAttributes();
/* 115 */       MBeanAttributeInfo attributeInfo = null;
/* 116 */       for (int i = 0; i < mbeanAttributeInfo.length; i++)
/*     */       {
/* 118 */         if (!mbeanAttributeInfo[i].getName().equals(this.monitor.getObservedAttribute()))
/*     */           continue;
/* 120 */         attributeInfo = mbeanAttributeInfo[i];
/* 121 */         break;
/*     */       }
/*     */ 
/* 126 */       if (attributeInfo == null)
/*     */       {
/* 128 */         sendAttributeErrorNotification(object, "The observed attribute does not exist");
/*     */ 
/* 130 */         return;
/*     */       }
/*     */ 
/* 134 */       if (!attributeInfo.isReadable())
/*     */       {
/* 136 */         sendAttributeErrorNotification(object, "Attribute not readable.");
/* 137 */         return;
/*     */       }
/*     */ 
/* 141 */       Object value = null;
/*     */       try
/*     */       {
/* 144 */         value = this.server.getAttribute(object.getObjectName(), this.monitor.getObservedAttribute());
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/* 148 */         sendObjectErrorNotification(object, "The observed object is not registered.");
/* 149 */         return;
/*     */       }
/*     */ 
/* 153 */       if (value == null)
/*     */       {
/* 155 */         sendAttributeTypeErrorNotification(object, "Attribute is null");
/* 156 */         return;
/*     */       }
/*     */ 
/* 160 */       this.callback.monitorCallback(object, attributeInfo, value);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 165 */       log.debug("Error in monitor ", e);
/* 166 */       sendRuntimeErrorNotification(object, "General error: " + e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void doRun()
/*     */   {
/* 176 */     runMonitor();
/*     */ 
/* 179 */     setNextRun(System.currentTimeMillis() + this.monitor.getGranularityPeriod());
/*     */   }
/*     */ 
/*     */   void runMonitor()
/*     */   {
/* 188 */     boolean isActive = this.monitor.isActive();
/* 189 */     for (Iterator i = this.observedObjects.values().iterator(); (i.hasNext()) && (isActive); )
/* 190 */       runMonitor((ObservedObject)i.next());
/*     */   }
/*     */ 
/*     */   void sendNotification(ObservedObject object, String type, long timestamp, String message, String attribute, Object gauge, Object trigger)
/*     */   {
/* 207 */     MonitorNotification n = this.callback.createNotification(type, this.monitorName, timestamp, message, gauge, attribute, object.getObjectName(), trigger);
/*     */ 
/* 210 */     this.monitor.sendNotification(n);
/*     */   }
/*     */ 
/*     */   void sendRuntimeErrorNotification(ObservedObject object, String message)
/*     */   {
/* 221 */     if (object.notAlreadyNotified(8))
/* 222 */       sendNotification(object, "jmx.monitor.error.runtime", 0L, message, this.monitor.getObservedAttribute(), null, null);
/*     */   }
/*     */ 
/*     */   void sendObjectErrorNotification(ObservedObject object, String message)
/*     */   {
/* 234 */     if (object.notAlreadyNotified(1))
/* 235 */       sendNotification(object, "jmx.monitor.error.mbean", 0L, message, this.monitor.getObservedAttribute(), null, null);
/*     */   }
/*     */ 
/*     */   void sendAttributeErrorNotification(ObservedObject object, String message)
/*     */   {
/* 247 */     if (object.notAlreadyNotified(2))
/* 248 */       sendNotification(object, "jmx.monitor.error.attribute", 0L, message, this.monitor.getObservedAttribute(), null, null);
/*     */   }
/*     */ 
/*     */   void sendAttributeTypeErrorNotification(ObservedObject object, String message)
/*     */   {
/* 260 */     if (object.notAlreadyNotified(4))
/* 261 */       sendNotification(object, "jmx.monitor.error.type", 0L, message, this.monitor.getObservedAttribute(), null, null);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     scheduler.start();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MonitorRunnable
 * JD-Core Version:    0.6.0
 */