/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.HashMap;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerConnection;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class MBeanProxyExt
/*     */   implements InvocationHandler, MBeanProxyInstance, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -2942844863242742655L;
/*     */   public static MBeanServerConnection remote;
/*     */   private MBeanServerConnection server;
/*     */   private ObjectName name;
/*  78 */   private final transient HashMap attributeMap = new HashMap();
/*     */ 
/*  82 */   private transient boolean inited = false;
/*     */ 
/* 105 */   private static final Object[] EMPTY_ARGS = new Object[0];
/*     */ 
/*     */   public MBeanProxyExt()
/*     */   {
/*     */   }
/*     */ 
/*     */   MBeanProxyExt(ObjectName name, MBeanServer server, boolean lazyInit)
/*     */   {
/*  96 */     this.name = name;
/*  97 */     this.server = server;
/*  98 */     if (!lazyInit)
/*  99 */       init();
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 117 */     Class type = method.getDeclaringClass();
/* 118 */     if ((type == MBeanProxyInstance.class) || (type == Object.class))
/*     */     {
/* 120 */       return method.invoke(this, args);
/*     */     }
/*     */ 
/* 123 */     String methodName = method.getName();
/*     */ 
/* 126 */     if ((methodName.startsWith("get")) && (args == null))
/*     */     {
/* 128 */       if (!this.inited) {
/* 129 */         init();
/*     */       }
/* 131 */       String attrName = methodName.substring(3);
/* 132 */       MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 133 */       if (info != null)
/*     */       {
/* 135 */         String retType = method.getReturnType().getName();
/* 136 */         if (retType.equals(info.getType()))
/*     */         {
/*     */           try
/*     */           {
/* 140 */             return this.server.getAttribute(this.name, attrName);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 144 */             throw JMXExceptionDecoder.decode(e);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 151 */     else if ((methodName.startsWith("is")) && (args == null))
/*     */     {
/* 153 */       if (!this.inited) {
/* 154 */         init();
/*     */       }
/* 156 */       String attrName = methodName.substring(2);
/* 157 */       MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 158 */       if ((info != null) && (info.isIs()))
/*     */       {
/* 160 */         Class retType = method.getReturnType();
/* 161 */         if ((retType.equals(Boolean.class)) || (retType.equals(Boolean.TYPE)))
/*     */         {
/*     */           try
/*     */           {
/* 165 */             return this.server.getAttribute(this.name, attrName);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 169 */             throw JMXExceptionDecoder.decode(e);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 176 */     else if ((methodName.startsWith("set")) && (args != null) && (args.length == 1))
/*     */     {
/* 178 */       if (!this.inited) {
/* 179 */         init();
/*     */       }
/* 181 */       String attrName = methodName.substring(3);
/* 182 */       MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 183 */       if ((info != null) && (method.getReturnType() == Void.TYPE))
/*     */       {
/*     */         try
/*     */         {
/* 187 */           this.server.setAttribute(this.name, new Attribute(attrName, args[0]));
/* 188 */           return null;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 192 */           throw JMXExceptionDecoder.decode(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 200 */     Class[] types = method.getParameterTypes();
/* 201 */     String[] sig = new String[types.length];
/* 202 */     for (int i = 0; i < types.length; i++)
/*     */     {
/* 204 */       sig[i] = types[i].getName();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 210 */       return this.server.invoke(this.name, methodName, args == null ? EMPTY_ARGS : args, sig);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 214 */     throw JMXExceptionDecoder.decode(e);
/*     */   }
/*     */ 
/*     */   public final ObjectName getMBeanProxyObjectName()
/*     */   {
/* 225 */     return this.name;
/*     */   }
/*     */ 
/*     */   public final MBeanServer getMBeanProxyMBeanServer()
/*     */   {
/* 230 */     if (!(this.server instanceof MBeanServer))
/* 231 */       throw new IllegalStateException("This operation is not available for an MBeanServerConnection");
/* 232 */     return (MBeanServer)this.server;
/*     */   }
/*     */ 
/*     */   public final MBeanServerConnection getMBeanProxyMBeanServerConnection()
/*     */   {
/* 237 */     return this.server;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object that)
/*     */   {
/* 250 */     if (that == null) return false;
/* 251 */     if (that == this) return true;
/*     */ 
/* 255 */     if ((that instanceof MBeanProxyInstance))
/*     */     {
/* 257 */       MBeanProxyInstance proxy = (MBeanProxyInstance)that;
/*     */ 
/* 260 */       if ((this.name.equals(proxy.getMBeanProxyObjectName())) && (this.server.equals(proxy.getMBeanProxyMBeanServer())))
/*     */       {
/* 263 */         return true;
/*     */       }
/*     */     }
/* 266 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 275 */     return this.name.hashCode() * 31 + this.server.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 283 */     StringBuffer sbuf = new StringBuffer(128);
/*     */ 
/* 285 */     sbuf.append("MBeanProxyExt[").append(this.name.toString()).append(']');
/*     */ 
/* 287 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   public static Object create(Class intf, String name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 306 */     return create(intf, new ObjectName(name));
/*     */   }
/*     */ 
/*     */   public static Object create(Class intf, String name, MBeanServer server)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 324 */     return create(intf, new ObjectName(name), server);
/*     */   }
/*     */ 
/*     */   public static Object create(Class intf, ObjectName name)
/*     */   {
/* 335 */     return create(intf, name, MBeanServerLocator.locateJBoss());
/*     */   }
/*     */ 
/*     */   public static Object create(Class intf, ObjectName name, MBeanServer server)
/*     */   {
/* 349 */     return create(intf, name, server, false);
/*     */   }
/*     */ 
/*     */   public static Object create(Class intf, ObjectName name, MBeanServer server, boolean lazyInit)
/*     */   {
/* 365 */     PrivilegedAction action = new PrivilegedAction(intf)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 369 */         ClassLoader cl = new ClassLoader(this.val$intf.getClassLoader())
/*     */         {
/*     */           public Class loadClass(String className) throws ClassNotFoundException
/*     */           {
/*     */             try
/*     */             {
/* 375 */               return super.loadClass(className);
/*     */             }
/*     */             catch (ClassNotFoundException e)
/*     */             {
/* 380 */               if (className.equals(MBeanProxyInstance.class.getName()))
/*     */               {
/* 382 */                 return MBeanProxyInstance.class.getClassLoader().loadClass(className);
/*     */               }
/*     */             }
/* 385 */             throw e;
/*     */           }
/*     */         };
/* 389 */         return cl;
/*     */       }
/*     */     };
/* 392 */     ClassLoader cl = (ClassLoader)AccessController.doPrivileged(action);
/* 393 */     Class[] ifaces = { MBeanProxyInstance.class, intf };
/* 394 */     InvocationHandler handler = new MBeanProxyExt(name, server, lazyInit);
/* 395 */     return Proxy.newProxyInstance(cl, ifaces, handler);
/*     */   }
/*     */ 
/*     */   private synchronized void init()
/*     */   {
/* 404 */     this.inited = true;
/*     */     try
/*     */     {
/* 407 */       MBeanInfo info = this.server.getMBeanInfo(this.name);
/* 408 */       MBeanAttributeInfo[] attributes = info.getAttributes();
/*     */ 
/* 410 */       for (int i = 0; i < attributes.length; i++)
/* 411 */         this.attributeMap.put(attributes[i].getName(), attributes[i]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 415 */       throw new RuntimeException("Error creating MBeanProxy: " + this.name, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 421 */     this.name = ((ObjectName)in.readObject());
/* 422 */     this.server = ((MBeanServerConnection)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 428 */     out.writeObject(this.name);
/* 429 */     if (remote != null)
/* 430 */       out.writeObject(remote);
/*     */     else
/* 432 */       out.writeObject(this.server);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MBeanProxyExt
 * JD-Core Version:    0.6.0
 */