/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.HashMap;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.IntrospectionException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ 
/*     */ public class JMXInvocationHandler
/*     */   implements ProxyContext, InvocationHandler, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3714728148040623702L;
/*  67 */   protected MBeanServer server = null;
/*     */ 
/*  72 */   protected ObjectName objectName = null;
/*     */ 
/*  77 */   private ProxyExceptionHandler handler = new DefaultExceptionHandler();
/*     */ 
/*  82 */   private HashMap attributeMap = new HashMap();
/*     */ 
/*  88 */   private boolean delegateToStringToResource = false;
/*     */ 
/*  94 */   private boolean delegateEqualsToResource = false;
/*     */ 
/* 100 */   private boolean delegateHashCodeToResource = false;
/*     */ 
/*     */   public JMXInvocationHandler(MBeanServer server, ObjectName name)
/*     */     throws MBeanProxyCreationException
/*     */   {
/*     */     try
/*     */     {
/* 119 */       if (server == null) {
/* 120 */         throw new MBeanProxyCreationException("null agent reference");
/*     */       }
/* 122 */       this.server = server;
/* 123 */       this.objectName = name;
/*     */ 
/* 125 */       MBeanInfo info = server.getMBeanInfo(this.objectName);
/* 126 */       MBeanAttributeInfo[] attributes = info.getAttributes();
/* 127 */       MBeanOperationInfo[] operations = info.getOperations();
/*     */ 
/* 130 */       for (int i = 0; i < attributes.length; i++) {
/* 131 */         this.attributeMap.put(attributes[i].getName(), attributes[i]);
/*     */       }
/*     */ 
/* 136 */       for (int i = 0; i < operations.length; i++)
/*     */       {
/* 138 */         if ((operations[i].getName().equals("toString")) && (operations[i].getReturnType().equals("java.lang.String")) && (operations[i].getSignature().length == 0))
/*     */         {
/* 142 */           this.delegateToStringToResource = true;
/*     */         }
/* 145 */         else if ((operations[i].getName().equals("equals")) && (operations[i].getReturnType().equals(Boolean.TYPE.getName())) && (operations[i].getSignature().length == 1) && (operations[i].getSignature()[0].getType().equals("java.lang.Object")))
/*     */         {
/* 150 */           this.delegateEqualsToResource = true;
/*     */         }
/*     */         else {
/* 153 */           if ((!operations[i].getName().equals("hashCode")) || (!operations[i].getReturnType().equals(Integer.TYPE.getName())) || (operations[i].getSignature().length != 0))
/*     */           {
/*     */             continue;
/*     */           }
/* 157 */           this.delegateHashCodeToResource = true;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 163 */       throw new MBeanProxyCreationException("Object name " + name + " not found: " + e.toString());
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/* 167 */       throw new MBeanProxyCreationException(e.toString());
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/* 171 */       throw new MBeanProxyCreationException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Exception
/*     */   {
/* 181 */     Class declaringClass = method.getDeclaringClass();
/*     */ 
/* 187 */     if (declaringClass == Object.class) {
/* 188 */       return handleObjectMethods(method, args);
/*     */     }
/*     */ 
/* 192 */     if (declaringClass == Serializable.class) {
/* 193 */       return method.invoke(this, args);
/*     */     }
/*     */ 
/* 198 */     if (declaringClass == DynamicMBean.class) {
/* 199 */       return handleDynamicMBeanInvocation(method, args);
/*     */     }
/*     */     try
/*     */     {
/* 203 */       String methodName = method.getName();
/*     */ 
/* 212 */       if ((methodName.startsWith("get")) && (args == null))
/*     */       {
/* 214 */         String attrName = methodName.substring(3, methodName.length());
/*     */ 
/* 217 */         MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 218 */         if (info != null)
/*     */         {
/* 220 */           String retType = method.getReturnType().getName();
/*     */ 
/* 223 */           if (retType.equals(info.getType()))
/*     */           {
/* 225 */             return this.server.getAttribute(this.objectName, attrName);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 231 */       else if ((methodName.startsWith("is")) && (args == null))
/*     */       {
/* 233 */         String attrName = methodName.substring(2, methodName.length());
/*     */ 
/* 236 */         MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 237 */         if ((info != null) && (info.isIs()))
/*     */         {
/* 239 */           Class retType = method.getReturnType();
/*     */ 
/* 242 */           if ((retType.equals(Boolean.class)) || (retType.equals(Boolean.TYPE)))
/*     */           {
/* 244 */             return this.server.getAttribute(this.objectName, attrName);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 250 */       else if ((methodName.startsWith("set")) && (args != null) && (args.length == 1))
/*     */       {
/* 252 */         String attrName = methodName.substring(3, methodName.length());
/*     */ 
/* 255 */         MBeanAttributeInfo info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
/* 256 */         if ((info != null) && (method.getReturnType().equals(Void.TYPE)))
/*     */         {
/* 258 */           ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 260 */           Class signatureClass = null;
/* 261 */           String classType = info.getType();
/*     */ 
/* 263 */           if (isPrimitive(classType))
/* 264 */             signatureClass = getPrimitiveClass(classType);
/*     */           else {
/* 266 */             signatureClass = cl.loadClass(info.getType());
/*     */           }
/* 268 */           if (signatureClass.isAssignableFrom(args[0].getClass()))
/*     */           {
/* 270 */             this.server.setAttribute(this.objectName, new Attribute(attrName, args[0]));
/* 271 */             return null;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 276 */       String[] signature = null;
/*     */ 
/* 278 */       if (args != null)
/*     */       {
/* 280 */         signature = new String[args.length];
/* 281 */         Class[] sign = method.getParameterTypes();
/*     */ 
/* 283 */         for (int i = 0; i < sign.length; i++) {
/* 284 */           signature[i] = sign[i].getName();
/*     */         }
/*     */       }
/* 287 */       return this.server.invoke(this.objectName, methodName, args, signature);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 291 */       return getExceptionHandler().handleInstanceNotFound(this, e, method, args);
/*     */     }
/*     */     catch (AttributeNotFoundException e)
/*     */     {
/* 295 */       return getExceptionHandler().handleAttributeNotFound(this, e, method, args);
/*     */     }
/*     */     catch (InvalidAttributeValueException e)
/*     */     {
/* 299 */       return getExceptionHandler().handleInvalidAttributeValue(this, e, method, args);
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 303 */       return getExceptionHandler().handleMBeanException(this, e, method, args);
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/* 307 */       return getExceptionHandler().handleReflectionException(this, e, method, args);
/*     */     }
/*     */     catch (RuntimeOperationsException e)
/*     */     {
/* 311 */       return getExceptionHandler().handleRuntimeOperationsException(this, e, method, args);
/*     */     }
/*     */     catch (RuntimeMBeanException e)
/*     */     {
/* 315 */       return getExceptionHandler().handleRuntimeMBeanException(this, e, method, args);
/*     */     }
/*     */     catch (RuntimeErrorException e) {
/*     */     }
/* 319 */     return getExceptionHandler().handleRuntimeError(this, e, method, args);
/*     */   }
/*     */ 
/*     */   public ProxyExceptionHandler getExceptionHandler()
/*     */   {
/* 325 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public void setExceptionHandler(ProxyExceptionHandler handler)
/*     */   {
/* 338 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMBeanServer()
/*     */   {
/* 343 */     return this.server;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 348 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 356 */     return "MBeanProxy for " + this.objectName + " (Agent ID: " + AgentID.get(this.server) + ")";
/*     */   }
/*     */ 
/*     */   private Object handleObjectMethods(Method method, Object[] args)
/*     */     throws InstanceNotFoundException, ReflectionException, IntrospectionException, MBeanException
/*     */   {
/* 366 */     if (method.getName().equals("toString"))
/*     */     {
/* 368 */       if (this.delegateToStringToResource) {
/* 369 */         return this.server.invoke(this.objectName, "toString", null, null);
/*     */       }
/* 371 */       return toString();
/*     */     }
/*     */ 
/* 374 */     if (method.getName().equals("equals"))
/*     */     {
/* 376 */       if (this.delegateEqualsToResource)
/*     */       {
/* 378 */         return this.server.invoke(this.objectName, "equals", new Object[] { args[0] }, new String[] { "java.lang.Object" });
/*     */       }
/*     */ 
/* 383 */       if (Proxy.isProxyClass(args[0].getClass()))
/*     */       {
/* 385 */         Proxy prxy = (Proxy)args[0];
/* 386 */         return new Boolean(equals(Proxy.getInvocationHandler(prxy)));
/*     */       }
/*     */ 
/* 390 */       return new Boolean(equals(args[0]));
/*     */     }
/*     */ 
/* 394 */     if (method.getName().equals("hashCode"))
/*     */     {
/* 396 */       if (this.delegateHashCodeToResource) {
/* 397 */         return this.server.invoke(this.objectName, "hashCode", null, null);
/*     */       }
/* 399 */       return new Integer(hashCode());
/*     */     }
/*     */ 
/* 402 */     throw new Error("Unexpected method invocation!");
/*     */   }
/*     */ 
/*     */   private Object handleDynamicMBeanInvocation(Method method, Object[] args)
/*     */     throws InstanceNotFoundException, ReflectionException, IntrospectionException, MBeanException, AttributeNotFoundException, InvalidAttributeValueException
/*     */   {
/* 410 */     String methodName = method.getName();
/*     */ 
/* 412 */     if (methodName.equals("setAttribute"))
/*     */     {
/* 414 */       this.server.setAttribute(this.objectName, (Attribute)args[0]);
/* 415 */       return null;
/*     */     }
/* 417 */     if (methodName.equals("setAttributes"))
/* 418 */       return this.server.setAttributes(this.objectName, (AttributeList)args[0]);
/* 419 */     if (methodName.equals("getAttribute"))
/* 420 */       return this.server.getAttribute(this.objectName, (String)args[0]);
/* 421 */     if (methodName.equals("getAttributes"))
/* 422 */       return this.server.getAttributes(this.objectName, (String[])(String[])args[0]);
/* 423 */     if (methodName.equals("invoke"))
/* 424 */       return this.server.invoke(this.objectName, (String)args[0], (Object[])(Object[])args[1], (String[])(String[])args[2]);
/* 425 */     if (methodName.equals("getMBeanInfo")) {
/* 426 */       return this.server.getMBeanInfo(this.objectName);
/*     */     }
/* 428 */     throw new Error("Unexpected method invocation!");
/*     */   }
/*     */ 
/*     */   private boolean isPrimitive(String type)
/*     */   {
/* 433 */     if (type.equals(Integer.TYPE.getName())) return true;
/* 434 */     if (type.equals(Long.TYPE.getName())) return true;
/* 435 */     if (type.equals(Boolean.TYPE.getName())) return true;
/* 436 */     if (type.equals(Byte.TYPE.getName())) return true;
/* 437 */     if (type.equals(Character.TYPE.getName())) return true;
/* 438 */     if (type.equals(Short.TYPE.getName())) return true;
/* 439 */     if (type.equals(Float.TYPE.getName())) return true;
/* 440 */     if (type.equals(Double.TYPE.getName())) return true;
/* 441 */     return type.equals(Void.TYPE.getName());
/*     */   }
/*     */ 
/*     */   private Class getPrimitiveClass(String type)
/*     */   {
/* 448 */     if (type.equals(Integer.TYPE.getName())) return Integer.TYPE;
/* 449 */     if (type.equals(Long.TYPE.getName())) return Long.TYPE;
/* 450 */     if (type.equals(Boolean.TYPE.getName())) return Boolean.TYPE;
/* 451 */     if (type.equals(Byte.TYPE.getName())) return Byte.TYPE;
/* 452 */     if (type.equals(Character.TYPE.getName())) return Character.TYPE;
/* 453 */     if (type.equals(Short.TYPE.getName())) return Short.TYPE;
/* 454 */     if (type.equals(Float.TYPE.getName())) return Float.TYPE;
/* 455 */     if (type.equals(Double.TYPE.getName())) return Double.TYPE;
/* 456 */     if (type.equals(Void.TYPE.getName())) return Void.TYPE;
/*     */ 
/* 458 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.JMXInvocationHandler
 * JD-Core Version:    0.6.0
 */