/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ 
/*     */ public class Invocation extends InvocationContext
/*     */ {
/*     */   private Object[] args;
/*     */   private InvocationContext ctx;
/*  69 */   int ic_counter = 0;
/*     */ 
/*  99 */   Object retVal = null;
/*     */ 
/*     */   public Invocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Invocation(InvocationContext ic)
/*     */   {
/*  47 */     addContext(ic);
/*     */   }
/*     */ 
/*     */   public void addContext(InvocationContext ctx)
/*     */   {
/*  55 */     super.copy(ctx);
/*  56 */     this.ctx = ctx;
/*     */   }
/*     */ 
/*     */   public void setArgs(Object[] args)
/*     */   {
/*  61 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public Object[] getArgs()
/*     */   {
/*  66 */     return this.args;
/*     */   }
/*     */ 
/*     */   public AbstractInterceptor nextInterceptor()
/*     */   {
/*  73 */     if (this.interceptors == null) {
/*  74 */       return null;
/*     */     }
/*  76 */     if (this.ic_counter < this.interceptors.size()) {
/*  77 */       return (AbstractInterceptor)this.interceptors.get(this.ic_counter++);
/*     */     }
/*  79 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invoke()
/*     */     throws Throwable
/*     */   {
/*  85 */     AbstractInterceptor ic = nextInterceptor();
/*     */ 
/*  87 */     if (ic == null) {
/*  88 */       return dispatch();
/*     */     }
/*  90 */     return ic.invoke(this);
/*     */   }
/*     */ 
/*     */   public Object dispatch()
/*     */     throws Throwable
/*     */   {
/*  96 */     return this.dispatcher.invoke(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     StringBuffer buffer = new StringBuffer();
/* 106 */     buffer.append(getName());
/* 107 */     String[] sig = getSignature();
/* 108 */     if (sig != null)
/* 109 */       buffer.append(Arrays.asList(sig));
/* 110 */     buffer.append(' ').append(getType());
/* 111 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public Class getAttributeTypeClass() throws ClassNotFoundException
/*     */   {
/* 116 */     return this.ctx.getAttributeTypeClass();
/*     */   }
/*     */ 
/*     */   public Class getReturnTypeClass() throws ClassNotFoundException
/*     */   {
/* 121 */     return this.ctx.getReturnTypeClass();
/*     */   }
/*     */ 
/*     */   public Class[] getSignatureClasses() throws ClassNotFoundException
/*     */   {
/* 126 */     return this.ctx.getSignatureClasses();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.Invocation
 * JD-Core Version:    0.6.0
 */