/*      */ package org.jboss.mx.server;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.management.Attribute;
/*      */ import javax.management.AttributeList;
/*      */ import javax.management.AttributeNotFoundException;
/*      */ import javax.management.Descriptor;
/*      */ import javax.management.InvalidAttributeValueException;
/*      */ import javax.management.JMRuntimeException;
/*      */ import javax.management.ListenerNotFoundException;
/*      */ import javax.management.MBeanAttributeInfo;
/*      */ import javax.management.MBeanException;
/*      */ import javax.management.MBeanInfo;
/*      */ import javax.management.MBeanNotificationInfo;
/*      */ import javax.management.MBeanOperationInfo;
/*      */ import javax.management.MBeanParameterInfo;
/*      */ import javax.management.MBeanRegistration;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.NotificationBroadcaster;
/*      */ import javax.management.NotificationEmitter;
/*      */ import javax.management.NotificationFilter;
/*      */ import javax.management.NotificationListener;
/*      */ import javax.management.ObjectName;
/*      */ import javax.management.ReflectionException;
/*      */ import javax.management.RuntimeErrorException;
/*      */ import javax.management.RuntimeMBeanException;
/*      */ import javax.management.RuntimeOperationsException;
/*      */ import javax.management.modelmbean.ModelMBeanInfo;
/*      */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.mx.interceptor.AttributeDispatcher;
/*      */ import org.jboss.mx.interceptor.Interceptor;
/*      */ import org.jboss.mx.interceptor.ReflectedDispatcher;
/*      */ import org.jboss.mx.metadata.StandardMetaData;
/*      */ import org.jboss.mx.server.registry.MBeanEntry;
/*      */ import org.jboss.util.Strings;
/*      */ 
/*      */ public abstract class AbstractMBeanInvoker
/*      */   implements MBeanInvoker
/*      */ {
/*   83 */   static ThreadLocal preRegisterInfo = new ThreadLocal();
/*      */ 
/*   90 */   private Object resource = null;
/*      */ 
/*   94 */   protected MBeanEntry resourceEntry = null;
/*      */ 
/*   99 */   protected boolean dynamicResource = true;
/*      */ 
/*  104 */   protected MBeanInfo info = null;
/*      */ 
/*  106 */   protected Map attributeContextMap = new HashMap();
/*  107 */   protected Map operationContextMap = new HashMap();
/*  108 */   protected Map constructorContextMap = new HashMap();
/*      */ 
/*  110 */   protected InvocationContext getMBeanInfoCtx = null;
/*  111 */   protected InvocationContext preRegisterCtx = null;
/*  112 */   protected InvocationContext postRegisterCtx = null;
/*  113 */   protected InvocationContext preDeregisterCtx = null;
/*  114 */   protected InvocationContext postDeregisterCtx = null;
/*      */ 
/*  119 */   protected Logger log = Logger.getLogger(AbstractMBeanInvoker.class);
/*      */   private MBeanServer server;
/*      */ 
/*      */   public static void setMBeanEntry(MBeanEntry entry)
/*      */   {
/*  133 */     preRegisterInfo.set(entry);
/*      */   }
/*      */ 
/*      */   public static MBeanEntry getMBeanEntry()
/*      */   {
/*  142 */     return (MBeanEntry)preRegisterInfo.get();
/*      */   }
/*      */ 
/*      */   public AbstractMBeanInvoker()
/*      */   {
/*      */   }
/*      */ 
/*      */   public AbstractMBeanInvoker(Object resource)
/*      */   {
/*  158 */     this.resource = resource;
/*      */   }
/*      */ 
/*      */   public AbstractMBeanInvoker(MBeanEntry resourceEntry)
/*      */   {
/*  167 */     this.resourceEntry = resourceEntry;
/*  168 */     this.resource = resourceEntry.getResourceInstance();
/*      */   }
/*      */ 
/*      */   public Object invoke(String operationName, Object[] args, String[] signature)
/*      */     throws MBeanException, ReflectionException
/*      */   {
/*  192 */     if (operationName == null) {
/*  193 */       throw new ReflectionException(new IllegalArgumentException("Null operation name"));
/*      */     }
/*      */ 
/*  196 */     String opName = operationName;
/*  197 */     if (this.dynamicResource)
/*      */     {
/*  199 */       int dot = operationName.lastIndexOf('.');
/*  200 */       if (dot != -1)
/*      */       {
/*  202 */         if (dot < operationName.length() - 1) {
/*  203 */           opName = operationName.substring(dot + 1);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  208 */     OperationKey key = new OperationKey(opName, signature);
/*  209 */     InvocationContext ctx = (InvocationContext)this.operationContextMap.get(key);
/*      */ 
/*  212 */     if (ctx == null)
/*      */     {
/*  215 */       boolean operationExists = false;
/*  216 */       if (this.dynamicResource)
/*      */       {
/*  218 */         for (Iterator i = this.operationContextMap.keySet().iterator(); i.hasNext(); )
/*      */         {
/*  220 */           OperationKey thisKey = (OperationKey)i.next();
/*  221 */           if (opName.equals(thisKey.keys[0]))
/*      */           {
/*  223 */             operationExists = true;
/*  224 */             break;
/*      */           }
/*      */         }
/*  227 */         if (operationExists) {
/*  228 */           throw new ReflectionException(new NoSuchMethodException("Unable to find operation " + operationName + getSignatureString(signature)));
/*      */         }
/*      */       }
/*  231 */       throw new ReflectionException(new IllegalArgumentException("Unable to find operation " + operationName + getSignatureString(signature)));
/*      */     }
/*      */ 
/*  236 */     Invocation invocation = new Invocation();
/*      */ 
/*  239 */     invocation.addContext(ctx);
/*      */ 
/*  242 */     invocation.setType("invoke");
/*      */ 
/*  245 */     invocation.setName(operationName);
/*      */ 
/*  248 */     invocation.setArgs(args);
/*      */ 
/*  250 */     override(invocation);
/*      */ 
/*  252 */     ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
/*  253 */     ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
/*  254 */     boolean setCl = (ccl != mbeanTCL) && (mbeanTCL != null);
/*  255 */     if (setCl)
/*      */     {
/*  257 */       TCLAction.UTIL.setContextClassLoader(mbeanTCL);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  264 */       Object localObject1 = invocation.invoke();
/*      */       ModelMBeanInfoSupport minfo;
/*      */       return localObject1;
/*      */     }
/*      */     catch (MBeanException e)
/*      */     {
/*  268 */       throw e;
/*      */     }
/*      */     catch (ReflectionException e)
/*      */     {
/*  272 */       throw e;
/*      */     }
/*      */     catch (JMRuntimeException e)
/*      */     {
/*  276 */       throw e;
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  280 */       rethrowAsMBeanException(t);
/*  281 */       Descriptor descriptor = null;
/*      */       Descriptor descriptor;
/*      */       ModelMBeanInfoSupport minfo;
/*      */       return descriptor;
/*      */     }
/*      */     finally
/*      */     {
/*  287 */       Descriptor descriptor = invocation.getDescriptor();
/*  288 */       if (descriptor != null)
/*      */       {
/*  290 */         ctx.setDescriptor(descriptor);
/*  291 */         if ((this.dynamicResource) && ("operation".equals(descriptor.getFieldValue("descriptorType"))))
/*      */         {
/*  293 */           ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
/*  294 */           minfo.setDescriptor(descriptor, "operation");
/*      */         }
/*      */       }
/*  297 */       invocation.setArgs(null);
/*  298 */       invocation.setDescriptor(null);
/*  299 */       invocation.setDispatcher(null);
/*      */ 
/*  301 */       if (setCl)
/*      */       {
/*  303 */         TCLAction.UTIL.setContextClassLoader(ccl);
/*      */       }
/*      */     }
/*  305 */     throw localObject2;
/*      */   }
/*      */ 
/*      */   public Object getAttribute(String attribute)
/*      */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*      */   {
/*  326 */     if (attribute == null) {
/*  327 */       throw new RuntimeOperationsException(new IllegalArgumentException("Cannot get null attribute"));
/*      */     }
/*      */ 
/*  330 */     InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(attribute);
/*      */ 
/*  334 */     if (ctx == null) {
/*  335 */       throw new AttributeNotFoundException("not found: " + attribute);
/*      */     }
/*  337 */     if (!ctx.isReadable()) {
/*  338 */       throw new AttributeNotFoundException("Attribute '" + attribute + "' found, but it is not readable");
/*      */     }
/*      */ 
/*  341 */     Invocation invocation = new Invocation();
/*      */ 
/*  344 */     invocation.addContext(ctx);
/*      */ 
/*  347 */     invocation.setType("getAttribute");
/*  348 */     invocation.setArgs(null);
/*      */ 
/*  350 */     override(invocation);
/*      */ 
/*  352 */     ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
/*  353 */     ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
/*  354 */     boolean setCl = (ccl != mbeanTCL) && (mbeanTCL != null);
/*  355 */     if (setCl)
/*      */     {
/*  357 */       TCLAction.UTIL.setContextClassLoader(mbeanTCL);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  362 */       Object localObject1 = invocation.invoke();
/*      */       return localObject1;
/*      */     }
/*      */     catch (AttributeNotFoundException e)
/*      */     {
/*  366 */       throw e;
/*      */     }
/*      */     catch (MBeanException e)
/*      */     {
/*  370 */       throw e;
/*      */     }
/*      */     catch (ReflectionException e)
/*      */     {
/*  374 */       throw e;
/*      */     }
/*      */     catch (JMRuntimeException e)
/*      */     {
/*  378 */       throw e;
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  382 */       rethrowAsMBeanException(t);
/*  383 */       Descriptor attrDesc = null;
/*      */       Descriptor attrDesc;
/*      */       return attrDesc;
/*      */     }
/*      */     finally
/*      */     {
/*  389 */       Descriptor attrDesc = invocation.getDescriptor();
/*  390 */       ctx.setDescriptor(attrDesc);
/*  391 */       updateAttributeInfo(attrDesc);
/*      */ 
/*  393 */       if (setCl)
/*      */       {
/*  395 */         TCLAction.UTIL.setContextClassLoader(ccl);
/*      */       }
/*      */     }
/*  397 */     throw localObject2;
/*      */   }
/*      */ 
/*      */   public void setAttribute(Attribute attribute)
/*      */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*      */   {
/*  418 */     if (attribute == null) {
/*  419 */       throw new InvalidAttributeValueException("null attribute");
/*      */     }
/*      */ 
/*  422 */     String name = attribute.getName();
/*  423 */     InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
/*      */ 
/*  427 */     if (ctx == null)
/*  428 */       throw new AttributeNotFoundException("not found: " + name);
/*  429 */     if (!ctx.isWritable())
/*      */     {
/*  431 */       throw new AttributeNotFoundException("Attribute '" + name + "' is not writable");
/*      */     }
/*      */ 
/*  436 */     Invocation invocation = new Invocation();
/*      */ 
/*  439 */     invocation.addContext(ctx);
/*      */ 
/*  442 */     invocation.setType("setAttribute");
/*      */ 
/*  445 */     invocation.setArgs(new Object[] { attribute.getValue() });
/*      */ 
/*  447 */     override(invocation);
/*      */ 
/*  449 */     ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
/*  450 */     ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
/*  451 */     boolean setCl = (ccl != mbeanTCL) && (mbeanTCL != null);
/*  452 */     if (setCl)
/*      */     {
/*  454 */       TCLAction.UTIL.setContextClassLoader(mbeanTCL);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  461 */       invocation.invoke();
/*      */     }
/*      */     catch (AttributeNotFoundException e)
/*      */     {
/*      */       Descriptor attrDesc;
/*  465 */       throw e;
/*      */     }
/*      */     catch (InvalidAttributeValueException e)
/*      */     {
/*  469 */       throw e;
/*      */     }
/*      */     catch (MBeanException e)
/*      */     {
/*  473 */       throw e;
/*      */     }
/*      */     catch (ReflectionException e)
/*      */     {
/*  477 */       throw e;
/*      */     }
/*      */     catch (JMRuntimeException e)
/*      */     {
/*  481 */       throw e;
/*      */     }
/*      */     catch (Throwable attrDesc)
/*      */     {
/*  485 */       rethrowAsMBeanException(t);
/*      */     }
/*      */     finally
/*      */     {
/*      */       Descriptor attrDesc;
/*  495 */       Descriptor attrDesc = invocation.getDescriptor();
/*  496 */       ctx.setDescriptor(attrDesc);
/*  497 */       updateAttributeInfo(attrDesc);
/*      */ 
/*  499 */       if (setCl)
/*      */       {
/*  501 */         TCLAction.UTIL.setContextClassLoader(ccl);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public MBeanInfo getMBeanInfo()
/*      */   {
/*  509 */     Invocation invocation = new Invocation(this.getMBeanInfoCtx);
/*      */ 
/*  512 */     invocation.setType("getMBeanInfo");
/*      */ 
/*  514 */     if (this.resourceEntry == null)
/*  515 */       this.resourceEntry = getMBeanEntry();
/*  516 */     ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
/*  517 */     ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
/*  518 */     boolean setCl = (ccl != mbeanTCL) && (mbeanTCL != null);
/*  519 */     if (setCl)
/*      */     {
/*  521 */       TCLAction.UTIL.setContextClassLoader(mbeanTCL);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  526 */       MBeanInfo info = (MBeanInfo)invocation.invoke();
/*  527 */       localMBeanInfo1 = info;
/*      */       return localMBeanInfo1;
/*      */     }
/*      */     catch (JMRuntimeException e)
/*      */     {
/*  531 */       throw e;
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  535 */       rethrowAsRuntimeMBeanException(t);
/*  536 */       MBeanInfo localMBeanInfo1 = null;
/*      */       return localMBeanInfo1;
/*      */     }
/*      */     finally
/*      */     {
/*  540 */       if (setCl)
/*      */       {
/*  542 */         TCLAction.UTIL.setContextClassLoader(ccl); } 
/*  542 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   public AttributeList getAttributes(String[] attributes)
/*      */   {
/*  549 */     if (attributes == null) {
/*  550 */       throw new IllegalArgumentException("null array");
/*      */     }
/*  552 */     AttributeList list = new AttributeList();
/*      */ 
/*  554 */     for (int i = 0; i < attributes.length; i++)
/*      */     {
/*      */       try
/*      */       {
/*  558 */         list.add(new Attribute(attributes[i], getAttribute(attributes[i])));
/*      */       }
/*      */       catch (Throwable ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  566 */     return list;
/*      */   }
/*      */ 
/*      */   public AttributeList setAttributes(AttributeList attributes)
/*      */   {
/*  571 */     if (attributes == null) {
/*  572 */       throw new IllegalArgumentException("null list");
/*      */     }
/*  574 */     AttributeList results = new AttributeList();
/*  575 */     Iterator it = attributes.iterator();
/*      */ 
/*  577 */     while (it.hasNext())
/*      */     {
/*  579 */       Attribute attr = (Attribute)it.next();
/*      */       try
/*      */       {
/*  582 */         setAttribute(attr);
/*  583 */         results.add(attr);
/*      */       }
/*      */       catch (Throwable ignored)
/*      */       {
/*  588 */         if (this.log.isTraceEnabled()) {
/*  589 */           this.log.trace("Unhandled setAttribute() for attribute: " + attr.getName(), ignored);
/*      */         }
/*      */       }
/*      */     }
/*  593 */     return results;
/*      */   }
/*      */ 
/*      */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*      */     throws Exception
/*      */   {
/*  610 */     this.resourceEntry = ((MBeanEntry)preRegisterInfo.get());
/*  611 */     this.server = server;
/*      */ 
/*  613 */     ObjectName mbeanName = null;
/*  614 */     Descriptor mbeanDescriptor = null;
/*  615 */     if ((this.info instanceof ModelMBeanInfo))
/*      */     {
/*  617 */       ModelMBeanInfo minfo = (ModelMBeanInfo)this.info;
/*      */       try
/*      */       {
/*  620 */         mbeanDescriptor = minfo.getDescriptor("", "mbean");
/*      */ 
/*  622 */         String type = (String)mbeanDescriptor.getFieldValue("MBeanServerType");
/*      */ 
/*  624 */         if (type != null)
/*      */         {
/*  626 */           inject("MBeanServerType", type, MBeanServer.class, getServer());
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (MBeanException e)
/*      */       {
/*  632 */         this.log.warn("Failed to obtain descriptor: mbean", e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  637 */     ClassLoader mbeanTCL = this.resourceEntry.getClassLoader();
/*  638 */     ClassLoader ccl = TCLAction.UTIL.getContextClassLoader();
/*  639 */     boolean setCl = (ccl != mbeanTCL) && (mbeanTCL != null);
/*  640 */     if (setCl)
/*      */     {
/*  642 */       TCLAction.UTIL.setContextClassLoader(mbeanTCL);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  647 */       initAttributeContexts(this.info.getAttributes());
/*      */ 
/*  649 */       initOperationContexts(this.info.getOperations());
/*      */ 
/*  651 */       if (this.resource != null) {
/*  652 */         initDispatchers();
/*      */       }
/*  654 */       mbeanName = invokePreRegister(server, name);
/*  655 */       if (mbeanDescriptor != null)
/*      */       {
/*  657 */         Object value = mbeanDescriptor.getFieldValue("ObjectNameType");
/*      */ 
/*  659 */         String type = (String)value;
/*  660 */         if (type != null)
/*      */         {
/*  662 */           inject("ObjectNameType", type, ObjectName.class, mbeanName);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  669 */       if (setCl)
/*      */       {
/*  671 */         TCLAction.UTIL.setContextClassLoader(ccl);
/*      */       }
/*      */     }
/*  674 */     return mbeanName;
/*      */   }
/*      */ 
/*      */   public void postRegister(Boolean registrationSuccessful)
/*      */   {
/*  681 */     invokePostRegister(registrationSuccessful);
/*      */   }
/*      */ 
/*      */   public void preDeregister()
/*      */     throws Exception
/*      */   {
/*  688 */     invokePreDeregister();
/*      */   }
/*      */ 
/*      */   public void postDeregister()
/*      */   {
/*  695 */     invokePostDeregister();
/*  696 */     this.server = null;
/*      */   }
/*      */ 
/*      */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */   {
/*  705 */     addNotificationListenerToResource(listener, filter, handback);
/*      */   }
/*      */ 
/*      */   protected void addNotificationListenerToResource(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */   {
/*  710 */     if ((this.resource instanceof NotificationBroadcaster))
/*      */     {
/*  712 */       ((NotificationBroadcaster)this.resource).addNotificationListener(listener, filter, handback);
/*      */     }
/*      */     else
/*      */     {
/*  716 */       throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification broadcaster"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(NotificationListener listener)
/*      */     throws ListenerNotFoundException
/*      */   {
/*  726 */     removeNotificationListenerFromResource(listener);
/*      */   }
/*      */ 
/*      */   protected void removeNotificationListenerFromResource(NotificationListener listener)
/*      */     throws ListenerNotFoundException
/*      */   {
/*  732 */     if ((this.resource instanceof NotificationBroadcaster))
/*      */     {
/*  734 */       ((NotificationBroadcaster)this.resource).removeNotificationListener(listener);
/*      */     }
/*      */     else
/*      */     {
/*  738 */       throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification broadcaster"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws ListenerNotFoundException
/*      */   {
/*  750 */     removeNotificationListenerFromResource(listener, filter, handback);
/*      */   }
/*      */ 
/*      */   protected void removeNotificationListenerFromResource(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws ListenerNotFoundException
/*      */   {
/*  758 */     if ((this.resource instanceof NotificationEmitter))
/*      */     {
/*  760 */       ((NotificationEmitter)this.resource).removeNotificationListener(listener, filter, handback);
/*      */     }
/*  762 */     else if ((this.resource instanceof NotificationBroadcaster))
/*      */     {
/*  768 */       removeNotificationListener(listener);
/*      */     }
/*      */     else
/*      */     {
/*  772 */       throw new RuntimeMBeanException(new IllegalArgumentException("Target XXX is not a notification emitter"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public MBeanNotificationInfo[] getNotificationInfo()
/*      */   {
/*  781 */     return getNotificationInfoFromResource();
/*      */   }
/*      */ 
/*      */   protected MBeanNotificationInfo[] getNotificationInfoFromResource()
/*      */   {
/*  786 */     if ((this.resource instanceof NotificationBroadcaster))
/*      */     {
/*  788 */       return ((NotificationBroadcaster)this.resource).getNotificationInfo();
/*      */     }
/*      */ 
/*  791 */     return new MBeanNotificationInfo[0];
/*      */   }
/*      */ 
/*      */   public MBeanInfo getMetaData()
/*      */   {
/*  799 */     return this.info;
/*      */   }
/*      */ 
/*      */   public Object getResource()
/*      */   {
/*  804 */     return this.resource;
/*      */   }
/*      */ 
/*      */   public void setResource(Object resource)
/*      */   {
/*  817 */     this.resource = resource;
/*      */   }
/*      */ 
/*      */   public ObjectName getObjectName()
/*      */   {
/*  822 */     if (this.resourceEntry == null) {
/*  823 */       return null;
/*      */     }
/*  825 */     return this.resourceEntry.getObjectName();
/*      */   }
/*      */ 
/*      */   public void updateAttributeInfo(Descriptor attrDesc) throws MBeanException
/*      */   {
/*  830 */     ModelMBeanInfoSupport minfo = (ModelMBeanInfoSupport)this.info;
/*  831 */     minfo.setDescriptor(attrDesc, "attribute");
/*      */   }
/*      */ 
/*      */   public void addOperationInterceptor(Interceptor interceptor)
/*      */   {
/*      */     Iterator it;
/*  839 */     if ((this.operationContextMap != null) && (interceptor != null))
/*      */     {
/*  842 */       for (it = this.operationContextMap.entrySet().iterator(); it.hasNext(); )
/*      */       {
/*  844 */         Map.Entry entry = (Map.Entry)it.next();
/*      */ 
/*  846 */         InvocationContext ctx = (InvocationContext)entry.getValue();
/*  847 */         List list = ctx.getInterceptors();
/*      */ 
/*  852 */         List newList = new ArrayList();
/*  853 */         newList.add(interceptor);
/*      */ 
/*  855 */         if (list != null)
/*      */         {
/*  857 */           newList.addAll(list);
/*      */         }
/*      */ 
/*  860 */         ctx.setInterceptors(newList);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeOperationInterceptor(Interceptor interceptor)
/*      */   {
/*      */     Iterator it;
/*  870 */     if ((this.operationContextMap != null) && (interceptor != null))
/*      */     {
/*  873 */       for (it = this.operationContextMap.entrySet().iterator(); it.hasNext(); )
/*      */       {
/*  875 */         Map.Entry entry = (Map.Entry)it.next();
/*      */ 
/*  877 */         InvocationContext ctx = (InvocationContext)entry.getValue();
/*  878 */         List list = ctx.getInterceptors();
/*      */ 
/*  882 */         if (list != null)
/*      */         {
/*  884 */           List newList = new ArrayList(list);
/*      */ 
/*  888 */           newList.remove(interceptor);
/*      */ 
/*  890 */           ctx.setInterceptors(newList);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void suspend()
/*      */   {
/*      */   }
/*      */ 
/*      */   public void suspend(long wait)
/*      */     throws TimeoutException
/*      */   {
/*      */   }
/*      */ 
/*      */   public void suspend(boolean force)
/*      */   {
/*      */   }
/*      */ 
/*      */   public boolean isSuspended()
/*      */   {
/*  912 */     return false;
/*      */   }
/*      */ 
/*      */   public void setInvocationTimeout(long time)
/*      */   {
/*      */   }
/*      */ 
/*      */   public long getInvocationTimeout()
/*      */   {
/*  921 */     return 0L;
/*      */   }
/*      */ 
/*      */   public void resume()
/*      */   {
/*      */   }
/*      */ 
/*      */   public MBeanServer getServer()
/*      */   {
/*  930 */     return this.server;
/*      */   }
/*      */ 
/*      */   protected void inject(String type, String name, Class argType, Object value)
/*      */   {
/*      */     try
/*      */     {
/*  946 */       Class resClass = this.resource.getClass();
/*  947 */       Class[] sig = { argType };
/*  948 */       Method setter = resClass.getMethod(name, sig);
/*  949 */       Object[] args = { value };
/*  950 */       setter.invoke(this.resource, args);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  954 */       this.log.debug("Setter not found: " + name + "(" + argType + ")", e);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  958 */       this.log.warn("Failed to inject type: " + type + " using setter: " + name, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ObjectName invokePreRegister(MBeanServer server, ObjectName name)
/*      */     throws Exception
/*      */   {
/*  965 */     if ((this.resource instanceof MBeanRegistration)) {
/*  966 */       return ((MBeanRegistration)this.resource).preRegister(server, name);
/*      */     }
/*  968 */     return name;
/*      */   }
/*      */ 
/*      */   protected void invokePostRegister(Boolean b)
/*      */   {
/*  973 */     if ((this.resource instanceof MBeanRegistration))
/*  974 */       ((MBeanRegistration)this.resource).postRegister(b);
/*      */   }
/*      */ 
/*      */   protected void invokePreDeregister() throws Exception
/*      */   {
/*  979 */     if ((this.resource instanceof MBeanRegistration))
/*  980 */       ((MBeanRegistration)this.resource).preDeregister();
/*      */   }
/*      */ 
/*      */   protected void invokePostDeregister()
/*      */   {
/*  985 */     if ((this.resource instanceof MBeanRegistration))
/*  986 */       ((MBeanRegistration)this.resource).postDeregister();
/*      */   }
/*      */ 
/*      */   protected void initAttributeContexts(MBeanAttributeInfo[] attributes)
/*      */   {
/*  992 */     for (int i = 0; i < attributes.length; i++)
/*      */     {
/*  994 */       InvocationContext ctx = new InvocationContext();
/*      */ 
/*  997 */       ctx.setName(attributes[i].getName());
/*      */ 
/*  999 */       ctx.setAttributeType(attributes[i].getType());
/*      */ 
/* 1002 */       ctx.setInvoker(this);
/*      */ 
/* 1007 */       this.attributeContextMap.put(attributes[i].getName(), ctx);
/*      */     }
/* 1009 */     if (this.log.isTraceEnabled())
/* 1010 */       this.log.trace(getObjectName() + " configured attribute contexts: " + this.operationContextMap);
/*      */   }
/*      */ 
/*      */   protected void initOperationContexts(MBeanOperationInfo[] operations)
/*      */   {
/* 1016 */     for (int i = 0; i < operations.length; i++)
/*      */     {
/* 1018 */       InvocationContext ctx = new InvocationContext();
/*      */ 
/* 1021 */       String opName = operations[i].getName();
/* 1022 */       MBeanParameterInfo[] signature = operations[i].getSignature();
/* 1023 */       String returnType = operations[i].getReturnType();
/*      */ 
/* 1026 */       ctx.setName(opName);
/*      */ 
/* 1029 */       ctx.setSignature(signature);
/*      */ 
/* 1032 */       ctx.setReturnType(returnType);
/*      */ 
/* 1035 */       ctx.setInvoker(this);
/*      */ 
/* 1042 */       OperationKey opKey = new OperationKey(opName, signature);
/*      */ 
/* 1045 */       this.operationContextMap.put(opKey, ctx);
/*      */     }
/*      */ 
/* 1048 */     if (this.log.isTraceEnabled())
/* 1049 */       this.log.trace(getObjectName() + " configured operation contexts: " + this.operationContextMap);
/*      */   }
/*      */ 
/*      */   protected void initDispatchers()
/*      */   {
/* 1054 */     boolean trace = this.log.isTraceEnabled();
/*      */ 
/* 1057 */     Class clazz = null;
/* 1058 */     if (this.resource != null)
/*      */     {
/* 1060 */       clazz = this.resource.getClass();
/*      */ 
/* 1067 */       if (!Modifier.isPublic(clazz.getModifiers()))
/*      */       {
/* 1069 */         clazz = StandardMetaData.findStandardInterface(clazz);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1074 */     MethodMapper mmap = new MethodMapper(clazz);
/* 1075 */     if (trace) {
/* 1076 */       this.log.trace(getObjectName() + " " + clazz + " map=" + mmap);
/*      */     }
/* 1078 */     MBeanOperationInfo[] operations = this.info.getOperations();
/*      */ 
/* 1081 */     for (int i = 0; i < operations.length; i++)
/*      */     {
/* 1083 */       MBeanOperationInfo op = operations[i];
/* 1084 */       OperationKey opKey = new OperationKey(op.getName(), op.getSignature());
/* 1085 */       InvocationContext ctx = (InvocationContext)this.operationContextMap.get(opKey);
/*      */ 
/* 1087 */       Interceptor dispatcher = ctx.getDispatcher();
/*      */ 
/* 1090 */       if ((!(dispatcher instanceof InvocationContext.NullDispatcher)) && (!(dispatcher instanceof ReflectedDispatcher)))
/*      */         continue;
/* 1092 */       Object target = null;
/* 1093 */       dispatcher = null;
/* 1094 */       Method m = mmap.lookupOperation(op);
/* 1095 */       if (m == null)
/*      */       {
/* 1098 */         m = MethodMapper.lookupOperation(op, this);
/* 1099 */         if (m != null)
/*      */         {
/* 1102 */           target = this;
/* 1103 */           dispatcher = new ReflectedDispatcher(m, this.dynamicResource);
/*      */         }
/*      */         else
/*      */         {
/* 1109 */           dispatcher = new ReflectedDispatcher(this.dynamicResource);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1115 */         target = this.resource;
/* 1116 */         dispatcher = new ReflectedDispatcher(m, this.dynamicResource);
/*      */       }
/* 1118 */       if (trace) {
/* 1119 */         this.log.trace(getObjectName() + " will dispatch op=" + opKey + " to " + Strings.defaultToString(target) + " method= " + m);
/*      */       }
/*      */ 
/* 1122 */       ctx.setTarget(target);
/* 1123 */       ctx.setDispatcher(dispatcher);
/*      */     }
/*      */ 
/* 1128 */     MBeanAttributeInfo[] attributes = this.info.getAttributes();
/* 1129 */     for (int i = 0; i < attributes.length; i++)
/*      */     {
/* 1131 */       MBeanAttributeInfo attribute = attributes[i];
/* 1132 */       String name = attribute.getName();
/* 1133 */       InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
/*      */ 
/* 1135 */       Method getter = mmap.lookupGetter(attribute);
/* 1136 */       Method setter = mmap.lookupSetter(attribute);
/* 1137 */       ctx.setDispatcher(new AttributeDispatcher(getter, setter, this.dynamicResource));
/* 1138 */       ctx.setTarget(this.resource);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void override(Invocation invocation)
/*      */     throws MBeanException
/*      */   {
/*      */   }
/*      */ 
/*      */   protected String getSignatureString(String[] signature)
/*      */   {
/* 1153 */     if (signature == null)
/* 1154 */       return "()";
/* 1155 */     if (signature.length == 0) {
/* 1156 */       return "()";
/*      */     }
/* 1158 */     StringBuffer sbuf = new StringBuffer(512);
/*      */ 
/* 1160 */     sbuf.append("(");
/* 1161 */     for (int i = 0; i < signature.length - 1; i++)
/*      */     {
/* 1163 */       sbuf.append(signature[i]);
/* 1164 */       sbuf.append(",");
/*      */     }
/* 1166 */     sbuf.append(signature[(signature.length - 1)]);
/* 1167 */     sbuf.append(")");
/*      */ 
/* 1169 */     return sbuf.toString();
/*      */   }
/*      */ 
/*      */   private void rethrowAsMBeanException(Throwable t)
/*      */     throws MBeanException
/*      */   {
/* 1280 */     if ((t instanceof RuntimeException))
/* 1281 */       throw new RuntimeMBeanException((RuntimeException)t);
/* 1282 */     if ((t instanceof Error)) {
/* 1283 */       throw new RuntimeErrorException((Error)t);
/*      */     }
/* 1285 */     throw new MBeanException((Exception)t);
/*      */   }
/*      */ 
/*      */   private void rethrowAsRuntimeMBeanException(Throwable t)
/*      */   {
/* 1290 */     if ((t instanceof RuntimeException))
/* 1291 */       throw new RuntimeMBeanException((RuntimeException)t);
/* 1292 */     if ((t instanceof Error)) {
/* 1293 */       throw new RuntimeErrorException((Error)t);
/*      */     }
/* 1295 */     throw new RuntimeMBeanException(new RuntimeException("Unhandled exception", t));
/*      */   }
/*      */ 
/*      */   protected final class OperationKey
/*      */   {
/* 1176 */     String[] keys = null;
/* 1177 */     int hash = 0;
/*      */ 
/*      */     public OperationKey(String name, String type)
/*      */     {
/* 1181 */       if (type != null)
/*      */       {
/* 1183 */         this.keys = new String[2];
/*      */ 
/* 1185 */         this.keys[0] = name;
/* 1186 */         this.keys[1] = type;
/*      */ 
/* 1188 */         this.hash = name.hashCode();
/*      */       }
/*      */       else
/*      */       {
/* 1193 */         this.keys = new String[] { name };
/* 1194 */         this.hash = name.hashCode();
/*      */       }
/*      */     }
/*      */ 
/*      */     public OperationKey(String name, String[] signature)
/*      */     {
/* 1200 */       if (signature != null)
/*      */       {
/* 1202 */         this.keys = new String[signature.length + 1];
/*      */ 
/* 1204 */         this.keys[0] = name;
/*      */ 
/* 1206 */         System.arraycopy(signature, 0, this.keys, 1, signature.length);
/*      */ 
/* 1208 */         this.hash = name.hashCode();
/*      */       }
/*      */       else
/*      */       {
/* 1213 */         this.keys = new String[] { name };
/* 1214 */         this.hash = name.hashCode();
/*      */       }
/*      */     }
/*      */ 
/*      */     public OperationKey(String name, MBeanParameterInfo[] signature)
/*      */     {
/* 1220 */       if (signature == null) {
/* 1221 */         signature = new MBeanParameterInfo[0];
/*      */       }
/* 1223 */       this.keys = new String[signature.length + 1];
/*      */ 
/* 1225 */       this.keys[0] = name;
/*      */ 
/* 1227 */       for (int i = 0; i < signature.length; i++)
/*      */       {
/* 1229 */         this.keys[(i + 1)] = signature[i].getType();
/*      */       }
/*      */ 
/* 1232 */       this.hash = name.hashCode();
/*      */     }
/*      */ 
/*      */     public OperationKey(MBeanOperationInfo info)
/*      */     {
/* 1237 */       this(info.getName(), info.getSignature());
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/* 1242 */       return this.hash;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object o)
/*      */     {
/* 1247 */       OperationKey target = (OperationKey)o;
/*      */ 
/* 1249 */       if (target.keys.length != this.keys.length) {
/* 1250 */         return false;
/*      */       }
/* 1252 */       for (int i = 0; i < this.keys.length; i++)
/*      */       {
/* 1254 */         if (!this.keys[i].equals(target.keys[i])) {
/* 1255 */           return false;
/*      */         }
/*      */       }
/* 1258 */       return true;
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/* 1263 */       StringBuffer buffer = new StringBuffer(50);
/* 1264 */       buffer.append(this.keys[0]).append("(");
/*      */ 
/* 1266 */       for (int i = 1; i < this.keys.length - 1; i++)
/*      */       {
/* 1268 */         buffer.append(this.keys[i]).append(',');
/*      */       }
/*      */ 
/* 1271 */       if (this.keys.length > 1)
/* 1272 */         buffer.append(this.keys[(this.keys.length - 1)]);
/* 1273 */       buffer.append(")");
/* 1274 */       return buffer.toString();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.AbstractMBeanInvoker
 * JD-Core Version:    0.6.0
 */