/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.management.JMException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class MBeanServerListenerRegistry
/*     */ {
/*  58 */   private HashMap registries = new HashMap();
/*     */ 
/*     */   public void add(ObjectName name, NotificationBroadcaster broadcaster, NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*  84 */     if (name == null)
/*  85 */       throw new IllegalArgumentException("Null name");
/*  86 */     if (listener == null) {
/*  87 */       throw new IllegalArgumentException("Null listener");
/*     */     }
/*  89 */     ListenerRegistry registry = null;
/*  90 */     synchronized (this.registries)
/*     */     {
/*  92 */       registry = (ListenerRegistry)this.registries.get(name);
/*  93 */       if (registry == null)
/*  94 */         registry = new ListenerRegistry(new MBeanServerListenerRegistrationFactory(name, broadcaster));
/*  95 */       this.registries.put(name, registry);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 100 */       registry.add(listener, filter, handback);
/*     */     }
/*     */     catch (JMException e)
/*     */     {
/* 105 */       throw new RuntimeException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(ObjectName name)
/*     */   {
/* 117 */     if (name == null) {
/* 118 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 120 */     ListenerRegistry registry = null;
/* 121 */     synchronized (this.registries)
/*     */     {
/* 123 */       registry = (ListenerRegistry)this.registries.remove(name);
/* 124 */       if (registry == null) {
/* 125 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 129 */     for (ListenerRegistry.ListenerRegistrationIterator iterator = registry.iterator(); iterator.hasNext(); )
/*     */     {
/* 131 */       ListenerRegistration registration = iterator.nextRegistration();
/* 132 */       registration.removed();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(ObjectName name, NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 147 */     if (name == null) {
/* 148 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 150 */     synchronized (this.registries)
/*     */     {
/* 152 */       ListenerRegistry registry = (ListenerRegistry)this.registries.get(name);
/* 153 */       if (registry == null) {
/* 154 */         throw new ListenerNotFoundException("Listener not found " + listener + " for object name " + name);
/*     */       }
/* 156 */       registry.remove(listener);
/* 157 */       if (registry.isEmpty())
/* 158 */         this.registries.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 175 */     if (name == null) {
/* 176 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 178 */     synchronized (this.registries)
/*     */     {
/* 180 */       ListenerRegistry registry = (ListenerRegistry)this.registries.get(name);
/* 181 */       if (registry == null) {
/* 182 */         throw new ListenerNotFoundException("Listener not found listener=" + listener + " filter=" + filter + " handback=" + handback + " for object name " + name);
/*     */       }
/*     */ 
/* 186 */       registry.remove(listener, filter, handback);
/* 187 */       if (registry.isEmpty())
/* 188 */         this.registries.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeAll()
/*     */   {
/* 197 */     synchronized (this.registries)
/*     */     {
/* 199 */       Iterator it = this.registries.keySet().iterator();
/*     */ 
/* 201 */       while (it.hasNext())
/*     */       {
/* 203 */         ListenerRegistry registry = (ListenerRegistry)this.registries.get(it.next());
/* 204 */         registry.removeAll();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.MBeanServerListenerRegistry
 * JD-Core Version:    0.6.0
 */