/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ 
/*     */ public class DefaultListenerRegistration
/*     */   implements ListenerRegistration
/*     */ {
/*     */   private NotificationListener listener;
/*     */   private NotificationFilter filter;
/*     */   private Object handback;
/*     */ 
/*     */   public DefaultListenerRegistration(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*  69 */     this.listener = listener;
/*  70 */     this.filter = filter;
/*  71 */     this.handback = handback;
/*     */   }
/*     */ 
/*     */   public NotificationListener getListener()
/*     */   {
/*  80 */     return this.listener;
/*     */   }
/*     */ 
/*     */   public NotificationFilter getFilter()
/*     */   {
/*  85 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public Object getHandback()
/*     */   {
/*  90 */     return this.handback;
/*     */   }
/*     */ 
/*     */   public NotificationListener getRegisteredListener()
/*     */   {
/*  95 */     return this.listener;
/*     */   }
/*     */ 
/*     */   public NotificationFilter getRegisteredFilter()
/*     */   {
/* 100 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public void removed()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 109 */     if ((obj == null) || (!(obj instanceof ListenerRegistration)))
/* 110 */       return false;
/* 111 */     ListenerRegistration other = (ListenerRegistration)obj;
/*     */ 
/* 113 */     if (!getRegisteredListener().equals(other.getRegisteredListener())) {
/* 114 */       return false;
/*     */     }
/* 116 */     NotificationFilter myFilter = getRegisteredFilter();
/* 117 */     NotificationFilter otherFilter = other.getRegisteredFilter();
/* 118 */     if ((myFilter != null) && (!myFilter.equals(otherFilter)))
/* 119 */       return false;
/* 120 */     if ((myFilter == null) && (otherFilter != null)) {
/* 121 */       return false;
/*     */     }
/* 123 */     Object myHandback = getHandback();
/* 124 */     Object otherHandback = other.getHandback();
/* 125 */     if ((myHandback != null) && (!myHandback.equals(otherHandback))) {
/* 126 */       return false;
/*     */     }
/* 128 */     return (myHandback != null) || (otherHandback == null);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 135 */     int result = this.listener.hashCode();
/* 136 */     if (this.filter != null)
/* 137 */       result += this.filter.hashCode();
/* 138 */     if (this.handback != null)
/* 139 */       result += this.handback.hashCode();
/* 140 */     return result;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 145 */     StringBuffer buffer = new StringBuffer(50);
/* 146 */     buffer.append(getClass()).append(":");
/* 147 */     buffer.append(" listener=").append(getRegisteredListener());
/* 148 */     buffer.append(" filter=").append(getRegisteredFilter());
/* 149 */     buffer.append(" handback=").append(getHandback());
/* 150 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.DefaultListenerRegistration
 * JD-Core Version:    0.6.0
 */