/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationListener;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class AsynchNotificationBroadcasterSupport extends JBossNotificationBroadcasterSupport
/*     */ {
/*  43 */   private static Logger log = Logger.getLogger(AsynchNotifier.class);
/*     */ 
/*  45 */   private static ThreadPool defaultPool = new BasicThreadPool("AsynchNotificationBroadcasterSupport");
/*     */   private static long defaultNotificationTimeout;
/*     */   private long notificationTimeout;
/*     */   private ThreadPool pool;
/*     */ 
/*     */   public static synchronized void setDefaultThreadPool(ThreadPool tp)
/*     */   {
/*  55 */     defaultPool = tp;
/*     */   }
/*     */ 
/*     */   public static long getDefaultNotificationTimeout()
/*     */   {
/*  60 */     return defaultNotificationTimeout;
/*     */   }
/*     */ 
/*     */   public static void setDefaultNotificationTimeout(long defaultNotificationTimeout) {
/*  64 */     defaultNotificationTimeout = defaultNotificationTimeout;
/*     */   }
/*     */ 
/*     */   public AsynchNotificationBroadcasterSupport()
/*     */   {
/*  75 */     this(defaultNotificationTimeout, defaultPool);
/*     */   }
/*     */ 
/*     */   public AsynchNotificationBroadcasterSupport(long notificationTimeout)
/*     */   {
/*  85 */     this(notificationTimeout, defaultPool);
/*     */   }
/*     */ 
/*     */   public AsynchNotificationBroadcasterSupport(long notificationTimeout, ThreadPool pool)
/*     */   {
/*  96 */     this.notificationTimeout = notificationTimeout;
/*  97 */     this.pool = pool;
/*     */   }
/*     */ 
/*     */   public long getNotificationTimeout()
/*     */   {
/* 104 */     return this.notificationTimeout;
/*     */   }
/*     */ 
/*     */   public void setNotificationTimeout(long notificationTimeout) {
/* 108 */     this.notificationTimeout = notificationTimeout;
/*     */   }
/*     */ 
/*     */   public ThreadPool getThreadPool()
/*     */   {
/* 113 */     return this.pool;
/*     */   }
/*     */ 
/*     */   public void setThreadPool(ThreadPool pool) {
/* 117 */     this.pool = pool;
/*     */   }
/*     */ 
/*     */   public void handleNotification(NotificationListener listener, Notification notification, Object handback)
/*     */   {
/* 133 */     AsynchNotifier notifier = new AsynchNotifier(listener, notification, handback);
/* 134 */     this.pool.run(notifier, 0L, this.notificationTimeout);
/*     */   }
/*     */ 
/*     */   protected void stopThreadPool(boolean immeadiate)
/*     */   {
/* 143 */     if (this.pool != defaultPool)
/*     */     {
/* 145 */       this.pool.stop(immeadiate);
/*     */     }
/*     */   }
/*     */ 
/*     */   public class AsynchNotifier
/*     */     implements Runnable
/*     */   {
/*     */     NotificationListener listener;
/*     */     Notification notification;
/*     */     Object handback;
/*     */ 
/*     */     public AsynchNotifier(NotificationListener listener, Notification notification, Object handback)
/*     */     {
/* 161 */       this.listener = listener;
/* 162 */       this.notification = notification;
/* 163 */       this.handback = handback;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 170 */         this.listener.handleNotification(this.notification, this.handback);
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 174 */         AsynchNotificationBroadcasterSupport.log.error("Error processing notification=" + this.notification + " listener=" + this.listener + " handback=" + this.handback, throwable);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.AsynchNotificationBroadcasterSupport
 * JD-Core Version:    0.6.0
 */