/*      */ package org.jboss.mx.mxbean;
/*      */ 
/*      */ import java.lang.reflect.Array;
/*      */ import java.lang.reflect.GenericArrayType;
/*      */ import java.lang.reflect.InvocationHandler;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.ParameterizedType;
/*      */ import java.lang.reflect.Proxy;
/*      */ import java.lang.reflect.Type;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import java.util.WeakHashMap;
/*      */ import javax.management.DynamicMBean;
/*      */ import javax.management.ObjectName;
/*      */ import javax.management.openmbean.ArrayType;
/*      */ import javax.management.openmbean.CompositeData;
/*      */ import javax.management.openmbean.CompositeDataSupport;
/*      */ import javax.management.openmbean.CompositeType;
/*      */ import javax.management.openmbean.OpenType;
/*      */ import javax.management.openmbean.SimpleType;
/*      */ import javax.management.openmbean.TabularData;
/*      */ import javax.management.openmbean.TabularDataSupport;
/*      */ import javax.management.openmbean.TabularType;
/*      */ import org.jboss.util.collection.WeakValueHashMap;
/*      */ 
/*      */ public class MXBeanUtils
/*      */ {
/*   67 */   private static final Map<Method, String> compositeDataKeyCache = Collections.synchronizedMap(new WeakHashMap());
/*      */ 
/*   70 */   private static final Map<Class, Map<String, Method>> compositeDataMethodCache = Collections.synchronizedMap(new WeakHashMap());
/*      */   public static final String MAP_KEY = "key";
/*      */   public static final String MAP_VALUE = "value";
/*   79 */   public static final String[] MAP_INDEX_NAMES = { "key" };
/*      */ 
/*   82 */   public static final String[] MAP_ITEM_NAMES = { "key", "value" };
/*      */ 
/*      */   public static OpenType getOpenType(Type type)
/*      */   {
/*   92 */     if (type == null) {
/*   93 */       throw new IllegalArgumentException("Null type");
/*      */     }
/*   95 */     OpenType result = checkType(type);
/*   96 */     if (result != null)
/*   97 */       return result;
/*   98 */     Class clazz = (Class)type;
/*   99 */     return CompositeTypeMetaDataFactory.getCompositeType(clazz);
/*      */   }
/*      */ 
/*      */   public static SimpleType getSimpleType(Class type)
/*      */     throws Exception
/*      */   {
/*  111 */     SimpleType simpleType = checkSimpleType(type);
/*  112 */     if (simpleType == null)
/*  113 */       throw new IllegalArgumentException("Not a SimpleType: " + type.getName());
/*  114 */     return simpleType;
/*      */   }
/*      */ 
/*      */   public static OpenType checkType(Type type)
/*      */   {
/*  125 */     OpenType result = checkSimpleType(type);
/*  126 */     if (result != null)
/*  127 */       return result;
/*  128 */     result = checkEnum(type);
/*  129 */     if (result != null)
/*  130 */       return result;
/*  131 */     result = checkArray(type);
/*  132 */     if (result != null)
/*  133 */       return result;
/*  134 */     result = checkCollection(type);
/*  135 */     if (result != null)
/*  136 */       return result;
/*  137 */     return checkMap(type);
/*      */   }
/*      */ 
/*      */   public static <T> T createCompositeDataProxy(Class<T> intf, CompositeData compositeData)
/*      */   {
/*  150 */     if (intf == null)
/*  151 */       throw new IllegalArgumentException("Null interface");
/*  152 */     InvocationHandler handler = new CompositeDataInvocationHandler(compositeData);
/*  153 */     Object object = Proxy.newProxyInstance(intf.getClassLoader(), new Class[] { intf }, handler);
/*  154 */     return intf.cast(object);
/*      */   }
/*      */ 
/*      */   public static Object construct(Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  168 */     OpenType openType = getOpenType(type);
/*  169 */     return construct(openType, value, context);
/*      */   }
/*      */ 
/*      */   public static Object construct(OpenType openType, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  183 */     if ((openType instanceof SimpleType))
/*  184 */       return constructSimpleData(value);
/*  185 */     if (openType.isArray())
/*  186 */       return constructArrayData(openType, value, context);
/*  187 */     if ((openType instanceof TabularType))
/*  188 */       return constructTabularData(openType, value, context);
/*  189 */     return constructCompositeData(openType, value, context);
/*      */   }
/*      */ 
/*      */   public static Object reconstruct(Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  203 */     OpenType openType = getOpenType(type);
/*  204 */     return reconstruct(openType, type, value, context);
/*      */   }
/*      */ 
/*      */   public static Object reconstruct(OpenType openType, Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  219 */     if ((openType instanceof SimpleType))
/*  220 */       return reconstructSimpleData(type, value, context);
/*  221 */     if (openType.isArray())
/*  222 */       return reconstructArrayData(openType, type, value, context);
/*  223 */     if ((openType instanceof TabularType))
/*  224 */       return reconstructTabularData(openType, type, value, context);
/*  225 */     return reconstructCompositeData(openType, type, value, context);
/*      */   }
/*      */ 
/*      */   public static SimpleType checkSimpleType(Type type)
/*      */   {
/*  236 */     if (BigDecimal.class.equals(type))
/*  237 */       return SimpleType.BIGDECIMAL;
/*  238 */     if (BigInteger.class.equals(type))
/*  239 */       return SimpleType.BIGINTEGER;
/*  240 */     if (Boolean.class.equals(type))
/*  241 */       return SimpleType.BOOLEAN;
/*  242 */     if (Boolean.TYPE.equals(type))
/*  243 */       return SimpleType.BOOLEAN;
/*  244 */     if (Byte.class.equals(type))
/*  245 */       return SimpleType.BYTE;
/*  246 */     if (Byte.TYPE.equals(type))
/*  247 */       return SimpleType.BYTE;
/*  248 */     if (Character.class.equals(type))
/*  249 */       return SimpleType.CHARACTER;
/*  250 */     if (Character.TYPE.equals(type))
/*  251 */       return SimpleType.CHARACTER;
/*  252 */     if (Date.class.equals(type))
/*  253 */       return SimpleType.DATE;
/*  254 */     if (Double.class.equals(type))
/*  255 */       return SimpleType.DOUBLE;
/*  256 */     if (Double.TYPE.equals(type))
/*  257 */       return SimpleType.DOUBLE;
/*  258 */     if (Float.class.equals(type))
/*  259 */       return SimpleType.FLOAT;
/*  260 */     if (Float.TYPE.equals(type))
/*  261 */       return SimpleType.FLOAT;
/*  262 */     if (Integer.class.equals(type))
/*  263 */       return SimpleType.INTEGER;
/*  264 */     if (Integer.TYPE.equals(type))
/*  265 */       return SimpleType.INTEGER;
/*  266 */     if (Long.class.equals(type))
/*  267 */       return SimpleType.LONG;
/*  268 */     if (Long.TYPE.equals(type))
/*  269 */       return SimpleType.LONG;
/*  270 */     if (ObjectName.class.equals(type))
/*  271 */       return SimpleType.OBJECTNAME;
/*  272 */     if (Short.class.equals(type))
/*  273 */       return SimpleType.SHORT;
/*  274 */     if (Short.TYPE.equals(type))
/*  275 */       return SimpleType.SHORT;
/*  276 */     if (String.class.equals(type))
/*  277 */       return SimpleType.STRING;
/*  278 */     if (Void.class.equals(type))
/*  279 */       return SimpleType.VOID;
/*  280 */     return null;
/*      */   }
/*      */ 
/*      */   public static SimpleType checkEnum(Type type)
/*      */   {
/*  291 */     if (!(type instanceof Class))
/*  292 */       return null;
/*  293 */     Class clazz = (Class)type;
/*  294 */     if ((clazz.isEnum()) || (Enum.class.equals(clazz)))
/*  295 */       return SimpleType.STRING;
/*  296 */     return null;
/*      */   }
/*      */ 
/*      */   public static Object constructSimpleData(Object value)
/*      */   {
/*  307 */     if ((value != null) && ((value instanceof Enum)))
/*      */     {
/*  309 */       Enum enumeration = (Enum)value;
/*  310 */       return enumeration.name();
/*      */     }
/*  312 */     return value;
/*      */   }
/*      */ 
/*      */   private static Object reconstructSimpleData(Type type, Object value, Object context)
/*      */   {
/*  326 */     if ((type instanceof Class))
/*      */     {
/*  328 */       if (value != null)
/*      */       {
/*  330 */         Class clazz = (Class)type;
/*  331 */         if ((clazz.isEnum()) || (Enum.class.equals(clazz)))
/*      */         {
/*  333 */           String string = (String)value;
/*  334 */           return Enum.valueOf(clazz, string);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  339 */         Class clazz = (Class)type;
/*  340 */         if (clazz.isPrimitive())
/*  341 */           throw new IllegalArgumentException("Attempt to use null as a primitive for: " + context);
/*  342 */         return null;
/*      */       }
/*      */     }
/*  345 */     return value;
/*      */   }
/*      */ 
/*      */   public static ArrayType checkArray(Type type)
/*      */   {
/*  356 */     if ((type instanceof Class))
/*      */     {
/*  358 */       Class clazz = (Class)type;
/*  359 */       if (!clazz.isArray())
/*  360 */         return null;
/*  361 */       int dimension = 1;
/*  362 */       Class componentType = clazz.getComponentType();
/*  363 */       while (componentType.isArray())
/*      */       {
/*  365 */         dimension++;
/*  366 */         componentType = componentType.getComponentType();
/*      */       }
/*  368 */       OpenType componentOpenType = getOpenType(componentType);
/*      */       try
/*      */       {
/*  371 */         return new ArrayType(dimension, componentOpenType);
/*      */       }
/*      */       catch (RuntimeException e)
/*      */       {
/*  375 */         throw e;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  379 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*  382 */     if ((type instanceof GenericArrayType))
/*      */     {
/*  384 */       GenericArrayType arrayType = (GenericArrayType)type;
/*  385 */       int dimension = 1;
/*  386 */       Type componentType = arrayType.getGenericComponentType();
/*  387 */       while ((componentType instanceof GenericArrayType))
/*      */       {
/*  389 */         dimension++;
/*  390 */         arrayType = (GenericArrayType)componentType;
/*  391 */         componentType = arrayType.getGenericComponentType();
/*      */       }
/*  393 */       OpenType componentOpenType = getOpenType(componentType);
/*      */       try
/*      */       {
/*  396 */         return new ArrayType(dimension, componentOpenType);
/*      */       }
/*      */       catch (RuntimeException e)
/*      */       {
/*  400 */         throw e;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  404 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*  407 */     return null;
/*      */   }
/*      */ 
/*      */   public static ArrayType checkCollection(Type type)
/*      */   {
/*  418 */     if (!(type instanceof ParameterizedType))
/*      */     {
/*  420 */       if ((type instanceof Class)) {
/*  421 */         return checkCollectionClass((Class)type);
/*      */       }
/*  423 */       return null;
/*      */     }
/*  425 */     ParameterizedType parameterizedType = (ParameterizedType)type;
/*  426 */     Type rawType = parameterizedType.getRawType();
/*  427 */     if (!(rawType instanceof Class))
/*  428 */       return null;
/*  429 */     Class rawClass = (Class)rawType;
/*  430 */     if (!Collection.class.isAssignableFrom(rawClass))
/*  431 */       return null;
/*  432 */     Type componentType = parameterizedType.getActualTypeArguments()[0];
/*  433 */     OpenType componentOpenType = getOpenType(componentType);
/*      */     try
/*      */     {
/*  436 */       return new ArrayType(1, componentOpenType);
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  440 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/*  444 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public static ArrayType checkCollectionClass(Class clazz)
/*      */   {
/*  456 */     if (!Collection.class.isAssignableFrom(clazz))
/*  457 */       return null;
/*  458 */     OpenType componentOpenType = getOpenType(Object.class);
/*      */     try
/*      */     {
/*  461 */       return new ArrayType(1, componentOpenType);
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  465 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/*  469 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public static Object constructArrayData(OpenType openType, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  484 */     if (value == null) {
/*  485 */       return null;
/*      */     }
/*  487 */     ArrayType arrayType = (ArrayType)openType;
/*  488 */     OpenType elementType = arrayType.getElementOpenType();
/*  489 */     int dimension = arrayType.getDimension();
/*      */ 
/*  491 */     Class clazz = value.getClass();
/*  492 */     if (clazz.isArray())
/*      */     {
/*  494 */       Object[] oldArray = (Object[])(Object[])value;
/*  495 */       Class componentType = Class.forName(arrayType.getClassName());
/*  496 */       return constructArray(elementType, componentType.getComponentType(), dimension, oldArray, context);
/*      */     }
/*  498 */     if ((value instanceof Collection))
/*      */     {
/*  500 */       Collection c = (Collection)value;
/*  501 */       Object[] oldArray = c.toArray();
/*  502 */       Class componentType = Class.forName(arrayType.getClassName());
/*  503 */       return constructArray(elementType, componentType.getComponentType(), dimension, oldArray, context);
/*      */     }
/*  505 */     throw new UnsupportedOperationException("Cannot construct array for: " + value);
/*      */   }
/*      */ 
/*      */   private static Object[] constructArray(OpenType elementType, Class<?> componentType, int dimension, Object[] oldArray, Object context)
/*      */     throws Exception
/*      */   {
/*  521 */     if (oldArray == null) {
/*  522 */       return null;
/*      */     }
/*  524 */     Object[] newArray = (Object[])(Object[])Array.newInstance(componentType, oldArray.length);
/*  525 */     if (dimension > 1)
/*      */     {
/*  527 */       for (int i = 0; i < oldArray.length; i++)
/*      */       {
/*  529 */         Object[] nestedOld = (Object[])(Object[])oldArray[i];
/*  530 */         newArray[i] = constructArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld, context);
/*      */       }
/*      */ 
/*      */     }
/*  535 */     else if (Object.class.equals(componentType))
/*      */     {
/*  537 */       for (int i = 0; i < oldArray.length; i++) {
/*  538 */         newArray[i] = oldArray[i];
/*      */       }
/*      */     }
/*      */     else {
/*  542 */       for (int i = 0; i < oldArray.length; i++) {
/*  543 */         newArray[i] = construct(elementType, oldArray[i], context);
/*      */       }
/*      */     }
/*      */ 
/*  547 */     return newArray;
/*      */   }
/*      */ 
/*      */   public static Object reconstructArrayData(OpenType openType, Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  562 */     if (value == null) {
/*  563 */       return null;
/*      */     }
/*  565 */     ArrayType arrayType = (ArrayType)getOpenType(type);
/*  566 */     OpenType elementType = arrayType.getElementOpenType();
/*  567 */     int dimension = arrayType.getDimension();
/*  568 */     Object[] oldArray = (Object[])(Object[])value;
/*  569 */     if ((type instanceof Class))
/*      */     {
/*  571 */       Class clazz = (Class)type;
/*  572 */       if (clazz.isArray()) {
/*  573 */         return reconstructArray(elementType, clazz.getComponentType(), dimension, oldArray, context);
/*      */       }
/*      */ 
/*      */     }
/*  580 */     else if ((type instanceof ParameterizedType))
/*      */     {
/*  582 */       ParameterizedType parameterizedType = (ParameterizedType)type;
/*  583 */       Type rawType = parameterizedType.getRawType();
/*  584 */       if ((rawType instanceof Class))
/*      */       {
/*  586 */         Class raw = (Class)rawType;
/*  587 */         if (Set.class.isAssignableFrom(raw))
/*  588 */           return createSet(oldArray);
/*  589 */         if (Collection.class.isAssignableFrom(raw))
/*  590 */           return createCollection(oldArray);
/*      */       }
/*      */     }
/*  593 */     throw new UnsupportedOperationException("Cannot convert array type: " + type);
/*      */   }
/*      */ 
/*      */   private static Object[] reconstructArray(OpenType elementType, Class componentType, int dimension, Object[] oldArray, Object context)
/*      */     throws Exception
/*      */   {
/*  609 */     if (oldArray == null) {
/*  610 */       return null;
/*      */     }
/*  612 */     Object[] newArray = (Object[])(Object[])Array.newInstance(componentType, oldArray.length);
/*  613 */     if (dimension > 1)
/*      */     {
/*  615 */       for (int i = 0; i < oldArray.length; i++)
/*      */       {
/*  617 */         Object[] nestedOld = (Object[])(Object[])oldArray[i];
/*  618 */         newArray[i] = reconstructArray(elementType, componentType.getComponentType(), dimension - 1, nestedOld, context);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  623 */       for (int i = 0; i < oldArray.length; i++) {
/*  624 */         newArray[i] = reconstruct(elementType, componentType, oldArray[i], context);
/*      */       }
/*      */     }
/*  627 */     return newArray;
/*      */   }
/*      */ 
/*      */   private static Collection createCollection(Object[] array)
/*      */   {
/*  638 */     return Arrays.asList(array);
/*      */   }
/*      */ 
/*      */   private static Set createSet(Object[] array)
/*      */   {
/*  650 */     HashSet result = new HashSet(array.length);
/*  651 */     for (int i = 0; i < array.length; i++)
/*  652 */       result.add(array[i]);
/*  653 */     return result;
/*      */   }
/*      */ 
/*      */   public static TabularType checkMap(Type type)
/*      */   {
/*  664 */     if (!(type instanceof ParameterizedType))
/*      */     {
/*  666 */       if ((type instanceof Class)) {
/*  667 */         return checkMapClass((Class)type);
/*      */       }
/*  669 */       return null;
/*      */     }
/*  671 */     ParameterizedType parameterizedType = (ParameterizedType)type;
/*  672 */     Type rawType = parameterizedType.getRawType();
/*  673 */     if (!(rawType instanceof Class))
/*  674 */       return null;
/*  675 */     Class rawClass = (Class)rawType;
/*  676 */     if (!Map.class.isAssignableFrom(rawClass))
/*  677 */       return null;
/*  678 */     Type[] args = parameterizedType.getActualTypeArguments();
/*  679 */     Type keyType = args[0];
/*  680 */     Type valueType = args[1];
/*  681 */     return createMapType(keyType, valueType);
/*      */   }
/*      */ 
/*      */   public static TabularType checkMapClass(Class clazz)
/*      */   {
/*  692 */     if (!Map.class.isAssignableFrom(clazz))
/*  693 */       return null;
/*  694 */     return createMapType(Object.class, Object.class);
/*      */   }
/*      */ 
/*      */   public static TabularType createMapType(Type keyType, Type valueType)
/*      */   {
/*  706 */     String name = Map.class.getName();
/*  707 */     OpenType[] itemTypes = { getOpenType(keyType), getOpenType(valueType) };
/*      */     try
/*      */     {
/*  710 */       CompositeType entryType = createMapEntryType(itemTypes);
/*  711 */       return new TabularType(name, name, entryType, MAP_INDEX_NAMES);
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  715 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/*  719 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   private static CompositeType createMapEntryType(OpenType[] itemTypes)
/*      */   {
/*  731 */     String entryName = Map.Entry.class.getName();
/*      */     try
/*      */     {
/*  734 */       return new CompositeType(entryName, entryName, MAP_ITEM_NAMES, MAP_ITEM_NAMES, itemTypes);
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  738 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/*  742 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public static Object constructTabularData(OpenType openType, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  758 */     if (value == null) {
/*  759 */       return null;
/*      */     }
/*  761 */     TabularType tabularType = (TabularType)openType;
/*      */ 
/*  763 */     if ((value instanceof Map))
/*      */     {
/*  765 */       TabularDataSupport table = new TabularDataSupport(tabularType);
/*  766 */       CompositeType entryType = tabularType.getRowType();
/*  767 */       OpenType keyType = entryType.getType("key");
/*  768 */       OpenType valueType = entryType.getType("value");
/*      */ 
/*  770 */       Map m = (Map)value;
/*  771 */       for (Iterator i = m.entrySet().iterator(); i.hasNext(); )
/*      */       {
/*  773 */         Map.Entry entry = (Map.Entry)i.next();
/*  774 */         Object key = construct(keyType, entry.getKey(), context);
/*  775 */         Object val = construct(valueType, entry.getValue(), context);
/*  776 */         CompositeDataSupport data = new CompositeDataSupport(entryType, MAP_ITEM_NAMES, new Object[] { key, val });
/*  777 */         table.put(data);
/*      */       }
/*  779 */       return table;
/*      */     }
/*  781 */     throw new UnsupportedOperationException("Cannot construct map for: " + value);
/*      */   }
/*      */ 
/*      */   public static Object reconstructTabularData(OpenType openType, Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  796 */     if (value == null) {
/*  797 */       return null;
/*      */     }
/*  799 */     TabularType tabularType = (TabularType)getOpenType(type);
/*  800 */     if (!(type instanceof Class))
/*      */     {
/*  807 */       if ((type instanceof ParameterizedType))
/*      */       {
/*  809 */         ParameterizedType parameterizedType = (ParameterizedType)type;
/*  810 */         Type rawType = parameterizedType.getRawType();
/*  811 */         if ((rawType instanceof Class))
/*      */         {
/*  813 */           Class raw = (Class)rawType;
/*  814 */           if (Map.class.isAssignableFrom(raw))
/*      */           {
/*  816 */             Type keyType = parameterizedType.getActualTypeArguments()[0];
/*  817 */             Type valueType = parameterizedType.getActualTypeArguments()[1];
/*  818 */             return createMap(tabularType, keyType, valueType, value, context);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  822 */     throw new UnsupportedOperationException("Cannot convert map type: " + type);
/*      */   }
/*      */ 
/*      */   private static Map createMap(TabularType openType, Type keyType, Type valueType, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  839 */     if (value == null) {
/*  840 */       return null;
/*      */     }
/*  842 */     Map result = new HashMap();
/*      */ 
/*  844 */     TabularData table = (TabularData)value;
/*  845 */     Collection values = table.values();
/*  846 */     for (Iterator i$ = values.iterator(); i$.hasNext(); ) { Object v = i$.next();
/*      */ 
/*  848 */       CompositeData entry = (CompositeData)CompositeData.class.cast(v);
/*  849 */       Object key = reconstruct(keyType, entry.get("key"), context);
/*  850 */       Object val = reconstruct(valueType, entry.get("value"), context);
/*  851 */       result.put(key, val);
/*      */     }
/*      */ 
/*  854 */     return result;
/*      */   }
/*      */ 
/*      */   public static Object constructCompositeData(OpenType openType, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  869 */     if (value == null) {
/*  870 */       return null;
/*      */     }
/*  872 */     Class clazz = value.getClass();
/*      */ 
/*  874 */     CompositeType compositeType = (CompositeType)openType;
/*  875 */     Set nameSet = compositeType.keySet();
/*  876 */     String[] names = (String[])nameSet.toArray(new String[nameSet.size()]);
/*      */ 
/*  878 */     Object[] values = new Object[names.length];
/*      */ 
/*  880 */     for (int i = 0; i < names.length; i++)
/*      */     {
/*  882 */       String name = names[i];
/*  883 */       OpenType itemType = compositeType.getType(name);
/*  884 */       Method method = getCompositeDataMethod(clazz, name, itemType == SimpleType.BOOLEAN);
/*  885 */       Object itemValue = method.invoke(value, null);
/*  886 */       values[i] = construct(itemType, itemValue, context);
/*      */     }
/*  888 */     return new CompositeDataSupport(compositeType, names, values);
/*      */   }
/*      */ 
/*      */   public static Object reconstructCompositeData(OpenType openType, Type type, Object value, Object context)
/*      */     throws Exception
/*      */   {
/*  903 */     if (value == null) {
/*  904 */       return null;
/*      */     }
/*  906 */     CompositeData compositeData = (CompositeData)value;
/*  907 */     CompositeDataInvocationHandler handler = new CompositeDataInvocationHandler(compositeData);
/*  908 */     Class clazz = (Class)type;
/*  909 */     Class[] interfaces = null;
/*  910 */     if (clazz.isInterface())
/*  911 */       interfaces = new Class[] { clazz };
/*      */     else
/*  913 */       interfaces = clazz.getInterfaces();
/*  914 */     return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler);
/*      */   }
/*      */ 
/*      */   public static String getCompositeDataKey(Method method)
/*      */   {
/*  925 */     String key = (String)compositeDataKeyCache.get(method);
/*  926 */     if (key != null) {
/*  927 */       return key;
/*      */     }
/*  929 */     StringBuilder fieldName = null;
/*      */ 
/*  931 */     Class returnType = method.getReturnType();
/*  932 */     Class[] paramTypes = method.getParameterTypes();
/*  933 */     if ((!Void.TYPE.equals(returnType)) && (paramTypes.length == 0))
/*      */     {
/*  935 */       String name = method.getName();
/*  936 */       if ((name.startsWith("is")) && (name.length() > 2))
/*      */       {
/*  938 */         if (Boolean.TYPE.equals(returnType))
/*      */         {
/*  940 */           fieldName = new StringBuilder();
/*  941 */           fieldName.append(Character.toLowerCase(name.charAt(2)));
/*  942 */           if (name.length() > 3)
/*  943 */             fieldName.append(name.substring(3));
/*      */         }
/*      */       }
/*  946 */       else if ((name.startsWith("get")) && (name.length() > 3))
/*      */       {
/*  948 */         fieldName = new StringBuilder();
/*  949 */         fieldName.append(Character.toLowerCase(name.charAt(3)));
/*  950 */         if (name.length() > 4) {
/*  951 */           fieldName.append(name.substring(4));
/*      */         }
/*      */       }
/*      */     }
/*  955 */     if (fieldName == null) {
/*  956 */       return null;
/*      */     }
/*  958 */     String result = fieldName.toString();
/*  959 */     compositeDataKeyCache.put(method, result);
/*  960 */     return result;
/*      */   }
/*      */ 
/*      */   public static Method getCompositeDataMethod(Class clazz, String key, boolean isBoolean)
/*      */     throws Exception
/*      */   {
/*  975 */     Map cache = (Map)compositeDataMethodCache.get(clazz);
/*  976 */     if (cache != null)
/*      */     {
/*  978 */       Method method = (Method)cache.get(key);
/*  979 */       if (method != null) {
/*  980 */         return method;
/*      */       }
/*      */     }
/*  983 */     StringBuilder name = new StringBuilder();
/*  984 */     name.append(Character.toUpperCase(key.charAt(0)));
/*  985 */     if (key.length() > 1)
/*  986 */       name.append(key.substring(1));
/*  987 */     Method method = null;
/*      */     try
/*      */     {
/*  990 */       method = clazz.getMethod("get" + name, null);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  994 */       if (isBoolean)
/*      */       {
/*      */         try
/*      */         {
/*  998 */           method = clazz.getMethod("is" + name, null);
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/* 1002 */           throw e;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1007 */         throw e;
/*      */       }
/*      */     }
/*      */ 
/* 1011 */     if (cache == null)
/*      */     {
/* 1013 */       cache = new WeakValueHashMap();
/* 1014 */       compositeDataMethodCache.put(clazz, cache);
/*      */     }
/* 1016 */     cache.put(key, method);
/* 1017 */     return method;
/*      */   }
/*      */ 
/*      */   public static DynamicMBean createMXBean(Object resource, Class<?> mxbeanInterface)
/*      */   {
/*      */     try
/*      */     {
/* 1031 */       return new MXBeanDelegate(resource, mxbeanInterface);
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/* 1035 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1039 */     throw new RuntimeException("Error creating MXBean", e);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.MXBeanUtils
 * JD-Core Version:    0.6.0
 */