/*     */ package org.jboss.mx.mxbean;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.lang.reflect.Type;
/*     */ import javax.management.openmbean.CompositeData;
/*     */ import javax.management.openmbean.InvalidKeyException;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class CompositeDataInvocationHandler
/*     */   implements InvocationHandler
/*     */ {
/*     */   private CompositeData compositeData;
/*     */ 
/*     */   public CompositeDataInvocationHandler(CompositeData compositeData)
/*     */   {
/*  52 */     if (compositeData == null)
/*  53 */       throw new IllegalArgumentException("Null compositeData");
/*  54 */     this.compositeData = compositeData;
/*     */   }
/*     */ 
/*     */   public CompositeData getCompositeData()
/*     */   {
/*  64 */     return this.compositeData;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */   {
/*  69 */     if (Object.class.equals(method.getDeclaringClass())) {
/*  70 */       return handleObjectInvocation(method.getName(), args);
/*     */     }
/*  72 */     Object value = getValue(method);
/*     */ 
/*  74 */     Type returnType = method.getGenericReturnType();
/*  75 */     return MXBeanUtils.reconstruct(returnType, value, method);
/*     */   }
/*     */ 
/*     */   private Object getValue(Method method)
/*     */   {
/*  80 */     String key = MXBeanUtils.getCompositeDataKey(method);
/*  81 */     if (key == null)
/*  82 */       throw new IllegalArgumentException("Unsupported method '" + method + "'; it must be a property getter.");
/*     */     try
/*     */     {
/*  85 */       return this.compositeData.get(key);
/*     */     }
/*     */     catch (InvalidKeyException e) {
/*     */     }
/*  89 */     throw new IllegalArgumentException("Unsupported method '" + method + "'; it must be a property getter for one of the item names of the composite data: " + this.compositeData, e);
/*     */   }
/*     */ 
/*     */   private Object handleObjectInvocation(String name, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  95 */     if ("equals".equals(name))
/*     */     {
/*  97 */       Object object = args[0];
/*  98 */       if ((object == null) || (!(object instanceof Proxy)))
/*  99 */         return Boolean.valueOf(false);
/* 100 */       InvocationHandler handler = Proxy.getInvocationHandler(object);
/* 101 */       if (handler == this)
/* 102 */         return Boolean.valueOf(true);
/* 103 */       if ((handler == null) || (!(handler instanceof CompositeDataInvocationHandler))) {
/* 104 */         return Boolean.valueOf(false);
/*     */       }
/* 106 */       CompositeDataInvocationHandler other = (CompositeDataInvocationHandler)handler;
/* 107 */       return Boolean.valueOf(getCompositeData().equals(other.getCompositeData()));
/*     */     }
/* 109 */     if ("hashCode".equals(name))
/* 110 */       return Integer.valueOf(getCompositeData().hashCode());
/* 111 */     if ("toString".equals(name))
/* 112 */       return getCompositeData().toString();
/* 113 */     throw new UnreachableStatementException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.CompositeDataInvocationHandler
 * JD-Core Version:    0.6.0
 */