/*     */ package org.jboss.mx.modelmbean;
/*     */ 
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.management.ServiceNotFoundException;
/*     */ import javax.management.modelmbean.RequiredModelMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.RawDynamicInvoker;
/*     */ 
/*     */ public class RequiredModelMBeanInvoker extends RawDynamicInvoker
/*     */ {
/*     */   RequiredModelMBean mbean;
/*     */ 
/*     */   public RequiredModelMBeanInvoker(DynamicMBean resource)
/*     */   {
/*  50 */     super(resource);
/*  51 */     this.mbean = ((RequiredModelMBean)resource);
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/*  58 */       return super.getAttribute(name);
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/*  63 */       Exception ex = e.getTargetException();
/*  64 */       if ((!(ex instanceof ClassNotFoundException)) && (!(ex instanceof NoSuchMethodException)))
/*     */       {
/*  67 */         this.log.debug("Rewrapping reflection exception: ", e);
/*  68 */         throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
/*     */       }
/*     */     }
/*  71 */     throw e;
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/*  79 */     if (attribute == null)
/*  80 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute"));
/*     */     try
/*     */     {
/*  83 */       super.setAttribute(attribute);
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/*  88 */       Exception ex = e.getTargetException();
/*  89 */       if ((!(ex instanceof ClassNotFoundException)) && (!(ex instanceof NoSuchMethodException)))
/*     */       {
/*  92 */         this.log.debug("Rewrapping reflection exception: ", e);
/*  93 */         throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
/*     */       }
/*     */ 
/*  96 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/* 102 */     if (attributes == null)
/* 103 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
/* 104 */     return super.getAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 109 */     if (attributes == null)
/* 110 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
/* 111 */     return super.setAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public Object invoke(String name, Object[] args, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 119 */     if (name == null)
/* 120 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null operation"));
/*     */     Object value;
/*     */     Object value;
/* 121 */     if (name.equals("getNotificationInfo")) {
/* 122 */       value = this.mbean.getNotificationInfo();
/*     */     }
/*     */     else {
/*     */       try
/*     */       {
/* 127 */         value = super.invoke(name, args, signature);
/*     */       }
/*     */       catch (RuntimeMBeanException e)
/*     */       {
/* 133 */         throw new MBeanException(e.getTargetException(), e.getMessage());
/*     */       }
/*     */       catch (ReflectionException e)
/*     */       {
/* 138 */         Exception ex = e.getTargetException();
/* 139 */         if ((!(ex instanceof ClassNotFoundException)) && (!(ex instanceof NoSuchMethodException)))
/*     */         {
/* 142 */           this.log.debug("Rewrapping reflection exception: ", e);
/* 143 */           throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
/*     */         }
/*     */ 
/* 146 */         throw e;
/*     */       }
/*     */     }
/* 149 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.modelmbean.RequiredModelMBeanInvoker
 * JD-Core Version:    0.6.0
 */