/*      */ package org.jboss.mx.loading;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*      */ import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
/*      */ import java.io.IOException;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.net.URLClassLoader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Comparator;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import java.util.TreeSet;
/*      */ import java.util.Vector;
/*      */ import javax.management.ListenerNotFoundException;
/*      */ import javax.management.MBeanNotificationInfo;
/*      */ import javax.management.MBeanRegistration;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.Notification;
/*      */ import javax.management.NotificationBroadcaster;
/*      */ import javax.management.NotificationFilter;
/*      */ import javax.management.NotificationListener;
/*      */ import javax.management.ObjectName;
/*      */ import org.jboss.classloading.spi.ClassLoadingDomain;
/*      */ import org.jboss.classloading.spi.DomainClassLoader;
/*      */ import org.jboss.classloading.spi.Translator;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*      */ import org.jboss.util.Classes;
/*      */ 
/*      */ public class UnifiedLoaderRepositoryDCL extends LoaderRepositoryDomain
/*      */   implements MBeanRegistration, NotificationBroadcaster, UnifiedLoaderRepositoryDCLMBean
/*      */ {
/*   78 */   private static final Logger log = Logger.getLogger(UnifiedLoaderRepository3.class);
/*      */   private static int addedCount;
/*      */   private CopyOnWriteArraySet classLoaders;
/*      */   private HashSet dynamicClassLoaders;
/*      */   private HashMap nonUCLClassLoader;
/*      */   private HashSet classLoaderURLs;
/*      */   private ConcurrentReaderHashMap classes;
/*      */   private HashMap loaderToClassesMap;
/*      */   private HashMap loaderToResourcesMap;
/*      */   private HashMap globalResources;
/*      */   private ConcurrentReaderHashMap packagesMap;
/*      */   private HashMap<DomainClassLoader, List<String>> loaderToPackagesMap;
/*      */   private long sequenceNumber;
/*      */   private final JBossNotificationBroadcasterSupport broadcaster;
/*      */   private MBeanNotificationInfo[] info;
/*      */ 
/*      */   public UnifiedLoaderRepositoryDCL()
/*      */   {
/*   88 */     this.classLoaders = new CopyOnWriteArraySet();
/*      */ 
/*   93 */     this.dynamicClassLoaders = new HashSet();
/*      */ 
/*   99 */     this.nonUCLClassLoader = new HashMap();
/*      */ 
/*  106 */     this.classLoaderURLs = new HashSet();
/*      */ 
/*  111 */     this.classes = new ConcurrentReaderHashMap();
/*      */ 
/*  117 */     this.loaderToClassesMap = new HashMap();
/*      */ 
/*  123 */     this.loaderToResourcesMap = new HashMap();
/*      */ 
/*  129 */     this.globalResources = new HashMap();
/*      */ 
/*  135 */     this.packagesMap = new ConcurrentReaderHashMap();
/*      */ 
/*  141 */     this.loaderToPackagesMap = new HashMap();
/*      */ 
/*  146 */     this.sequenceNumber = 0L;
/*      */ 
/*  151 */     this.broadcaster = new JBossNotificationBroadcasterSupport();
/*      */   }
/*      */ 
/*      */   public DomainClassLoader newClassLoader(URL url, boolean addToRepository)
/*      */     throws Exception
/*      */   {
/*  164 */     URL[] cp = { url };
/*  165 */     DomainClassLoaderUCLImpl ucl = new DomainClassLoaderUCLImpl(cp, this);
/*  166 */     if (addToRepository)
/*  167 */       registerClassLoader(ucl);
/*  168 */     return ucl;
/*      */   }
/*      */ 
/*      */   public DomainClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository)
/*      */     throws Exception
/*      */   {
/*  174 */     URL[] cp = { url };
/*  175 */     DomainClassLoaderUCLImpl ucl = new DomainClassLoaderUCLImpl(cp, this);
/*  176 */     if (addToRepository)
/*  177 */       registerClassLoader(ucl);
/*  178 */     return ucl;
/*      */   }
/*      */ 
/*      */   public ClassLoadingDomain getParent()
/*      */   {
/*  183 */     return null;
/*      */   }
/*      */ 
/*      */   public int getCacheSize()
/*      */   {
/*  188 */     return this.classes.size();
/*      */   }
/*      */ 
/*      */   public int getClassLoadersSize()
/*      */   {
/*  193 */     return this.classLoaders.size();
/*      */   }
/*      */ 
/*      */   public void flush()
/*      */   {
/*  198 */     synchronized (this.classes)
/*      */     {
/*  200 */       this.classes.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Class getCachedClass(String classname)
/*      */   {
/*  206 */     return (Class)this.classes.get(classname);
/*      */   }
/*      */ 
/*      */   public Class loadClass(String name, boolean resolve, DomainClassLoader cl)
/*      */     throws ClassNotFoundException
/*      */   {
/*  214 */     return loadClassFromClassLoader(name, resolve, cl);
/*      */   }
/*      */ 
/*      */   public Set getPackageClassLoaders(String className)
/*      */   {
/*  222 */     String pkgName = ClassLoaderUtils.getPackageName(className);
/*  223 */     Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  224 */     if (this.dynamicClassLoaders.size() > 0)
/*      */     {
/*  226 */       if (pkgSet == null)
/*  227 */         pkgSet = ClassLoaderUtils.newPackageSet();
/*  228 */       pkgSet.addAll(this.dynamicClassLoaders);
/*      */     }
/*  230 */     return pkgSet;
/*      */   }
/*      */ 
/*      */   private String getResourcePackageName(String rsrcName)
/*      */   {
/*  235 */     int index = rsrcName.lastIndexOf('/');
/*  236 */     String pkgName = rsrcName;
/*  237 */     if (index > 0)
/*  238 */       pkgName = rsrcName.substring(0, index);
/*  239 */     return pkgName.replace('/', '.');
/*      */   }
/*      */ 
/*      */   public Class loadClassFromCache(String name)
/*      */   {
/*  248 */     Class cls = null;
/*  249 */     synchronized (this.classes)
/*      */     {
/*  251 */       cls = (Class)this.classes.get(name);
/*      */     }
/*  253 */     return cls;
/*      */   }
/*      */ 
/*      */   public void cacheLoadedClass(String name, Class cls, DomainClassLoader cl)
/*      */   {
/*  263 */     synchronized (this.classes)
/*      */     {
/*  266 */       Object prevClass = this.classes.put(name, cls);
/*  267 */       if (log.isTraceEnabled())
/*      */       {
/*  269 */         log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", ucl: " + cl + ", prevClass: " + prevClass);
/*      */       }
/*      */ 
/*  275 */       HashSet loadedClasses = (HashSet)this.loaderToClassesMap.get(cl);
/*  276 */       if (loadedClasses == null)
/*      */       {
/*  278 */         loadedClasses = new HashSet();
/*  279 */         this.loaderToClassesMap.put(cl, loadedClasses);
/*      */       }
/*  281 */       loadedClasses.add(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   Class loadClassFromClassLoader(String name, boolean resolve, DomainClassLoader cl)
/*      */   {
/*      */     try
/*      */     {
/*  289 */       Class cls = cl.loadClassLocally(name, resolve);
/*  290 */       cacheLoadedClass(name, cls, cl);
/*  291 */       return cls;
/*      */     }
/*      */     catch (ClassNotFoundException x)
/*      */     {
/*      */     }
/*      */ 
/*  297 */     return null;
/*      */   }
/*      */ 
/*      */   public URL getResource(String name, DomainClassLoader cl)
/*      */   {
/*  307 */     URL resource = getResourceFromCache(name, cl);
/*      */ 
/*  310 */     if (resource != null) {
/*  311 */       return resource;
/*      */     }
/*      */ 
/*  314 */     resource = getResourceFromClassLoader(name, cl);
/*      */ 
/*  317 */     if (resource != null) {
/*  318 */       return resource;
/*      */     }
/*      */ 
/*  321 */     resource = getResourceFromGlobalCache(name);
/*      */ 
/*  324 */     if (resource != null) {
/*  325 */       return resource;
/*      */     }
/*      */ 
/*  328 */     resource = getResourceFromRepository(name, cl);
/*      */ 
/*  331 */     if (resource != null) {
/*  332 */       return resource;
/*      */     }
/*      */ 
/*  335 */     return null;
/*      */   }
/*      */ 
/*      */   public void getResources(String name, DomainClassLoader cl, List urls)
/*      */   {
/*  348 */     Iterator iter = this.classLoaders.iterator();
/*  349 */     while (iter.hasNext() == true)
/*      */     {
/*  351 */       DomainClassLoader nextCL = (DomainClassLoader)iter.next();
/*  352 */       if ((nextCL instanceof DomainClassLoader))
/*      */       {
/*  354 */         DomainClassLoader ucl = nextCL;
/*      */         try
/*      */         {
/*  357 */           Enumeration resURLs = ucl.findResourcesLocally(name);
/*  358 */           while (resURLs.hasMoreElements())
/*      */           {
/*  360 */             Object res = resURLs.nextElement();
/*  361 */             urls.add(res);
/*      */           }
/*      */         }
/*      */         catch (IOException ignore)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Enumeration<URL> findResources(String name) {
/*  372 */     Vector resources = new Vector();
/*  373 */     getResources(name, null, resources);
/*  374 */     return resources.elements();
/*      */   }
/*      */ 
/*      */   private URL getResourceFromCache(String name, DomainClassLoader cl)
/*      */   {
/*  387 */     URL resource = null;
/*  388 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  390 */       if (this.loaderToResourcesMap.containsKey(cl))
/*      */       {
/*  392 */         HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
/*  393 */         resource = (URL)resources.get(name);
/*      */       }
/*      */     }
/*  396 */     return resource;
/*      */   }
/*      */ 
/*      */   private URL getResourceFromClassLoader(String name, DomainClassLoader cl)
/*      */   {
/*  401 */     URL resource = null;
/*  402 */     if ((cl instanceof DomainClassLoader))
/*      */     {
/*  404 */       DomainClassLoader ucl = cl;
/*  405 */       resource = ucl.loadResourceLocally(name);
/*  406 */       cacheLoadedResource(name, resource, cl);
/*      */     }
/*  408 */     return resource;
/*      */   }
/*      */ 
/*      */   protected URL getResourceFromGlobalCache(String name)
/*      */   {
/*  418 */     ResourceInfo ri = null;
/*  419 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  421 */       ri = (ResourceInfo)this.globalResources.get(name);
/*      */     }
/*  423 */     URL resource = null;
/*  424 */     if (ri != null)
/*  425 */       resource = ri.url;
/*  426 */     return resource;
/*      */   }
/*      */ 
/*      */   protected URL getResourceFromRepository(String name, DomainClassLoader cl)
/*      */   {
/*  432 */     String pkgName = getResourcePackageName(name);
/*  433 */     Iterator i = null;
/*  434 */     Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  435 */     if (pkgSet != null)
/*      */     {
/*  437 */       i = pkgSet.iterator();
/*      */     }
/*  439 */     if (i == null)
/*      */     {
/*  442 */       i = this.classLoaders.iterator();
/*      */     }
/*      */ 
/*  445 */     URL url = null;
/*  446 */     while (i.hasNext() == true)
/*      */     {
/*  448 */       DomainClassLoader classloader = (DomainClassLoader)i.next();
/*  449 */       if (classloader.equals(cl))
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/*  454 */       if ((classloader instanceof DomainClassLoader))
/*      */       {
/*  456 */         url = classloader.loadResourceLocally(name);
/*  457 */         if (url != null)
/*      */         {
/*  459 */           cacheLoadedResource(name, url, classloader);
/*  460 */           cacheGlobalResource(name, url, classloader);
/*  461 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  469 */     return url;
/*      */   }
/*      */ 
/*      */   private void cacheLoadedResource(String name, URL url, DomainClassLoader cl)
/*      */   {
/*  481 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  483 */       HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
/*  484 */       if (resources == null)
/*      */       {
/*  486 */         resources = new HashMap();
/*  487 */         this.loaderToResourcesMap.put(cl, resources);
/*      */       }
/*  489 */       resources.put(name, url);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void cacheGlobalResource(String name, URL url, DomainClassLoader cl)
/*      */   {
/*  500 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  502 */       this.globalResources.put(name, new ResourceInfo(url, cl));
/*      */     }
/*      */   }
/*      */ 
/*      */   public URL[] getURLs()
/*      */   {
/*  512 */     HashSet classpath = new HashSet();
/*  513 */     Set tmp = this.classLoaders;
/*  514 */     for (Iterator iter = tmp.iterator(); iter.hasNext(); )
/*      */     {
/*  516 */       Object obj = iter.next();
/*  517 */       if ((obj instanceof DomainClassLoader))
/*      */       {
/*  519 */         DomainClassLoader cl = (DomainClassLoader)obj;
/*  520 */         URL[] urls = cl.getClasspath();
/*  521 */         int length = urls != null ? urls.length : 0;
/*  522 */         for (int u = 0; u < length; u++)
/*      */         {
/*  524 */           URL path = urls[u];
/*  525 */           classpath.add(path);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  530 */     URL[] cp = new URL[classpath.size()];
/*  531 */     classpath.toArray(cp);
/*  532 */     return cp;
/*      */   }
/*      */ 
/*      */   public String displayClassInfo(String className)
/*      */   {
/*  544 */     String classRsrcName = className.replace('.', '/') + ".class";
/*      */ 
/*  546 */     int count = 0;
/*  547 */     Class loadedClass = loadClassFromCache(className);
/*  548 */     StringBuffer results = new StringBuffer(className + " Information\n");
/*  549 */     if (loadedClass != null)
/*      */     {
/*  551 */       results.append("Repository cache version:");
/*  552 */       Classes.displayClassInfo(loadedClass, results);
/*      */     }
/*      */     else
/*      */     {
/*  556 */       results.append("Not loaded in repository cache\n");
/*      */     }
/*  558 */     Set tmp = this.classLoaders;
/*  559 */     for (Iterator iter = tmp.iterator(); iter.hasNext(); )
/*      */     {
/*  561 */       URLClassLoader cl = (URLClassLoader)iter.next();
/*  562 */       URL classURL = cl.findResource(classRsrcName);
/*  563 */       if (classURL != null)
/*      */       {
/*  565 */         results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
/*  566 */         count++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  571 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*  572 */     URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
/*  573 */     for (int s = 0; s < stack.length; s++)
/*      */     {
/*  575 */       URLClassLoader cl = stack[s];
/*  576 */       URL classURL = cl.findResource(classRsrcName);
/*  577 */       if (classURL == null)
/*      */         continue;
/*  579 */       results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
/*  580 */       count++;
/*      */     }
/*      */ 
/*  584 */     return results.toString();
/*      */   }
/*      */ 
/*      */   public Class loadClass(String className)
/*      */     throws ClassNotFoundException
/*      */   {
/*  597 */     ClassLoader scl = Thread.currentThread().getContextClassLoader();
/*  598 */     DomainClassLoader ucl = null;
/*  599 */     if (this.classLoaders.size() > 0)
/*  600 */       ucl = (DomainClassLoader)this.classLoaders.iterator().next();
/*      */     try
/*      */     {
/*  603 */       if (ucl != null) {
/*  604 */         return loadClass(className, false, ucl);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException ignore)
/*      */     {
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  614 */       return scl.loadClass(className);
/*      */     }
/*      */     catch (ClassNotFoundException clazz)
/*      */     {
/*  622 */       Class clazz = getNativeClassForName(className);
/*  623 */       if (clazz != null) return clazz;
/*      */     }
/*  625 */     throw new ClassNotFoundException(className);
/*      */   }
/*      */ 
/*      */   public Class loadClassWithout(DomainClassLoader loader, String className)
/*      */     throws ClassNotFoundException
/*      */   {
/*  640 */     throw new ClassNotFoundException("NYI");
/*      */   }
/*      */ 
/*      */   public DomainClassLoader getWrappingClassLoader(DomainClassLoader cl)
/*      */   {
/*  651 */     synchronized (this.classLoaders)
/*      */     {
/*  653 */       return (DomainClassLoader)this.nonUCLClassLoader.get(cl);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addClassLoader(DomainClassLoader loader)
/*      */   {
/*  662 */     addDomainClassLoader((DomainClassLoaderUCLImpl)loader);
/*      */   }
/*      */ 
/*      */   public boolean addClassLoaderURL(DomainClassLoader cl, URL url)
/*      */   {
/*  667 */     DomainClassLoader ucl = cl;
/*  668 */     boolean added = false;
/*  669 */     synchronized (this.classLoaders)
/*      */     {
/*  672 */       String query = url.getQuery();
/*  673 */       if (query != null)
/*      */       {
/*  675 */         String ext = url.toExternalForm();
/*  676 */         String ext2 = ext.substring(0, ext.length() - query.length() - 1);
/*      */         try
/*      */         {
/*  679 */           url = new URL(ext2);
/*      */         }
/*      */         catch (MalformedURLException e)
/*      */         {
/*  683 */           log.warn("Failed to strip query from: " + url, e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  688 */       if (!this.classLoaderURLs.contains(url))
/*      */       {
/*  690 */         updatePackageMap(ucl);
/*  691 */         this.classLoaderURLs.add(url);
/*  692 */         added = true;
/*      */ 
/*  694 */         if ((query != null) && (query.indexOf("dynamic=true") >= 0))
/*  695 */           this.dynamicClassLoaders.add(ucl);
/*      */       }
/*      */     }
/*  698 */     return added;
/*      */   }
/*      */ 
/*      */   private void addDomainClassLoader(DomainClassLoaderUCLImpl cl)
/*      */   {
/*  707 */     cl.setDomain(this);
/*  708 */     boolean added = false;
/*  709 */     synchronized (this.classLoaders)
/*      */     {
/*  711 */       boolean exists = false;
/*  712 */       URL[] cp = cl.getClasspath();
/*  713 */       this.classLoaderURLs.addAll(Arrays.asList(cp));
/*  714 */       added = this.classLoaders.add(cl);
/*  715 */       if (added)
/*      */       {
/*  717 */         log.debug("Adding " + cl);
/*  718 */         addedCount += 1;
/*  719 */         cl.setAddedOrder(addedCount);
/*  720 */         updatePackageMap(cl);
/*      */       }
/*      */       else
/*      */       {
/*  724 */         log.debug("Skipping duplicate " + cl);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private synchronized void updatePackageMap(DomainClassLoader cl)
/*      */   {
/*  734 */     boolean trace = log.isTraceEnabled();
/*      */     try
/*      */     {
/*  737 */       PackageMapper listener = new PackageMapper(cl);
/*  738 */       URL[] cp = cl.getClasspath();
/*  739 */       for (URL url : cp)
/*      */       {
/*  741 */         ClassLoaderUtils.updatePackageMap(url, listener);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  746 */       if (log.isTraceEnabled())
/*  747 */         log.trace("Failed to update pkgs for cl=" + cl, e);
/*      */       else
/*  749 */         log.debug("Failed to update pkgs for cl=" + cl, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeClassLoader(DomainClassLoader loader)
/*      */   {
/*  758 */     ArrayList removeNotifications = new ArrayList();
/*  759 */     DomainClassLoader cl = loader;
/*      */     Iterator i;
/*  760 */     synchronized (this.classLoaders)
/*      */     {
/*  762 */       if (!(loader instanceof DomainClassLoader))
/*      */       {
/*  764 */         cl = (DomainClassLoader)this.nonUCLClassLoader.remove(loader);
/*      */       }
/*  766 */       if ((cl instanceof DomainClassLoader))
/*      */       {
/*  768 */         DomainClassLoader ucl = cl;
/*  769 */         if (getTranslator() != null)
/*  770 */           getTranslator().unregisterClassLoader(ucl);
/*  771 */         URL[] urls = ucl.getClasspath();
/*  772 */         for (int u = 0; u < urls.length; u++)
/*  773 */           this.classLoaderURLs.remove(urls[u]);
/*      */       }
/*  775 */       boolean dynamic = this.dynamicClassLoaders.remove(cl);
/*  776 */       boolean removed = this.classLoaders.remove(cl);
/*  777 */       log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
/*      */ 
/*  780 */       HashSet loadedClasses = null;
/*  781 */       boolean hasLoadedClasses = false;
/*      */       Iterator i;
/*  782 */       synchronized (this.classes)
/*      */       {
/*  784 */         hasLoadedClasses = this.loaderToClassesMap.containsKey(cl);
/*  785 */         if (hasLoadedClasses) {
/*  786 */           loadedClasses = (HashSet)this.loaderToClassesMap.remove(cl);
/*      */         }
/*  788 */         if (loadedClasses != null)
/*      */         {
/*  791 */           for (Iterator iter = loadedClasses.iterator(); iter.hasNext(); )
/*      */           {
/*  793 */             String className = (String)iter.next();
/*  794 */             Notification n = new Notification("jboss.mx.class.removed", this, getNextSequenceNumber(), className);
/*      */ 
/*  796 */             removeNotifications.add(n);
/*      */           }
/*      */ 
/*  800 */           for (i = loadedClasses.iterator(); i.hasNext(); )
/*      */           {
/*  802 */             String cls = (String)i.next();
/*  803 */             this.classes.remove(cls);
/*      */           }
/*      */         }
/*      */       }
/*      */       Iterator i;
/*  809 */       synchronized (this.loaderToResourcesMap)
/*      */       {
/*  811 */         if (this.loaderToResourcesMap.containsKey(cl))
/*      */         {
/*  813 */           HashMap resources = (HashMap)this.loaderToResourcesMap.remove(cl);
/*      */ 
/*  816 */           if (resources != null)
/*      */           {
/*  818 */             for (i = resources.keySet().iterator(); i.hasNext(); )
/*      */             {
/*  820 */               String name = (String)i.next();
/*  821 */               ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
/*  822 */               if ((ri != null) && (ri.cl == cl)) {
/*  823 */                 this.globalResources.remove(name);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  830 */       if (!dynamic)
/*      */       {
/*  832 */         List pkgNames = (List)this.loaderToPackagesMap.remove(cl);
/*  833 */         if (pkgNames != null)
/*      */         {
/*  835 */           for (String pkgName : pkgNames)
/*      */           {
/*  837 */             Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  838 */             if (pkgSet != null)
/*      */             {
/*  840 */               pkgSet.remove(cl);
/*  841 */               if (pkgSet.isEmpty()) {
/*  842 */                 this.packagesMap.remove(pkgName);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  850 */         this.loaderToPackagesMap.remove(cl);
/*  851 */         for (i = this.packagesMap.entrySet().iterator(); i.hasNext(); )
/*      */         {
/*  853 */           Map.Entry entry = (Map.Entry)i.next();
/*  854 */           Set pkgSet = (Set)entry.getValue();
/*  855 */           pkgSet.remove(cl);
/*  856 */           if (pkgSet.isEmpty()) {
/*  857 */             i.remove();
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  863 */     for (int n = 0; n < removeNotifications.size(); n++)
/*      */     {
/*  865 */       Notification msg = (Notification)removeNotifications.get(n);
/*  866 */       this.broadcaster.sendNotification(msg);
/*      */     }
/*      */ 
/*  869 */     Notification msg = new Notification("jboss.mx.classloader.removed", this, getNextSequenceNumber());
/*  870 */     msg.setUserData(cl);
/*  871 */     this.broadcaster.sendNotification(msg);
/*      */   }
/*      */ 
/*      */   public LoaderRepositoryDomain registerClassLoader(DomainClassLoader ucl)
/*      */   {
/*  885 */     addClassLoader(ucl);
/*  886 */     Notification msg = new Notification("jboss.mx.classloader.added", this, getNextSequenceNumber());
/*  887 */     msg.setUserData(ucl);
/*  888 */     this.broadcaster.sendNotification(msg);
/*      */ 
/*  890 */     return this;
/*      */   }
/*      */ 
/*      */   public LoaderRepositoryDomain getInstance()
/*      */   {
/*  898 */     return this;
/*      */   }
/*      */ 
/*      */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws IllegalArgumentException
/*      */   {
/*  914 */     this.broadcaster.addNotificationListener(listener, filter, handback);
/*      */   }
/*      */ 
/*      */   public MBeanNotificationInfo[] getNotificationInfo()
/*      */   {
/*  923 */     if (this.info == null)
/*      */     {
/*  925 */       this.info = new MBeanNotificationInfo[] { new MBeanNotificationInfo(new String[] { "CLASSLOADER_ADDED" }, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[] { "CLASS_REMOVED" }, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader") };
/*      */     }
/*      */ 
/*  935 */     return this.info;
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(NotificationListener listener)
/*      */     throws ListenerNotFoundException
/*      */   {
/*  946 */     this.broadcaster.removeNotificationListener(listener);
/*      */   }
/*      */ 
/*      */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*      */     throws Exception
/*      */   {
/*  953 */     return name;
/*      */   }
/*      */ 
/*      */   public void postRegister(Boolean registrationDone)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void preDeregister()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void postDeregister()
/*      */   {
/*  967 */     log.debug("postDeregister, clearing all references");
/*  968 */     this.classLoaders.clear();
/*  969 */     this.dynamicClassLoaders.clear();
/*  970 */     this.nonUCLClassLoader.clear();
/*  971 */     this.classLoaderURLs.clear();
/*  972 */     this.classes.clear();
/*  973 */     this.loaderToClassesMap.clear();
/*  974 */     this.loaderToResourcesMap.clear();
/*  975 */     this.globalResources.clear();
/*  976 */     this.packagesMap.clear();
/*  977 */     this.loaderToPackagesMap.clear();
/*      */   }
/*      */ 
/*      */   String[] getPackageNames(DomainClassLoaderUCLImpl loader)
/*      */   {
/*  987 */     List pkgNames = (List)this.loaderToPackagesMap.get(loader);
/*  988 */     String[] tmp = new String[0];
/*  989 */     if (pkgNames != null)
/*      */     {
/*  991 */       tmp = new String[pkgNames.size()];
/*  992 */       pkgNames.toArray(tmp);
/*      */     }
/*  994 */     return tmp;
/*      */   }
/*      */ 
/*      */   private synchronized long getNextSequenceNumber()
/*      */   {
/*  999 */     return this.sequenceNumber++;
/*      */   }
/*      */ 
/*      */   class PackageMapper
/*      */     implements ClassLoaderUtils.PkgNameListener
/*      */   {
/*      */     private DomainClassLoader loader;
/*      */ 
/*      */     PackageMapper(DomainClassLoader loader)
/*      */     {
/* 1054 */       this.loader = loader;
/*      */     }
/*      */ 
/*      */     public void addPackage(String pkgName)
/*      */     {
/* 1059 */       if ((pkgName.startsWith("META-INF")) || (pkgName.startsWith("WEB-INF"))) {
/* 1060 */         return;
/*      */       }
/* 1062 */       Set pkgSet = (Set)UnifiedLoaderRepositoryDCL.this.packagesMap.get(pkgName);
/* 1063 */       if (pkgSet == null)
/*      */       {
/* 1065 */         pkgSet = new TreeSet(new UnifiedLoaderRepositoryDCL.DomainClassLoaderUCLImplComparator(null));
/* 1066 */         UnifiedLoaderRepositoryDCL.this.packagesMap.put(pkgName, pkgSet);
/*      */       }
/* 1068 */       if (!pkgSet.contains(this.loader))
/*      */       {
/* 1070 */         pkgSet.add(this.loader);
/* 1071 */         List loaderPkgNames = (List)UnifiedLoaderRepositoryDCL.this.loaderToPackagesMap.get(this.loader);
/* 1072 */         if (loaderPkgNames == null)
/*      */         {
/* 1074 */           loaderPkgNames = new ArrayList();
/* 1075 */           UnifiedLoaderRepositoryDCL.this.loaderToPackagesMap.put(this.loader, loaderPkgNames);
/*      */         }
/* 1077 */         loaderPkgNames.add(pkgName);
/*      */ 
/* 1080 */         if (pkgSet.size() > 1)
/*      */         {
/* 1082 */           UnifiedLoaderRepositoryDCL.log.debug("Multiple class loaders found for pkg: " + pkgName);
/*      */         }
/* 1084 */         if (UnifiedLoaderRepositoryDCL.log.isTraceEnabled())
/* 1085 */           UnifiedLoaderRepositoryDCL.log.trace("Indexed pkg: " + pkgName + ", UCL: " + this.loader);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class DomainClassLoaderUCLImplComparator
/*      */     implements Comparator
/*      */   {
/*      */     public int compare(Object o1, Object o2)
/*      */     {
/* 1014 */       if ((o1 instanceof LoadMgr3.PkgClassLoader))
/*      */       {
/* 1016 */         LoadMgr3.PkgClassLoader pkg1 = (LoadMgr3.PkgClassLoader)o1;
/* 1017 */         LoadMgr3.PkgClassLoader pkg2 = (LoadMgr3.PkgClassLoader)o2;
/* 1018 */         RepositoryClassLoader rcl1 = pkg1.ucl;
/* 1019 */         RepositoryClassLoader rcl2 = pkg2.ucl;
/*      */ 
/* 1021 */         int test = pkg1.order - pkg2.order;
/* 1022 */         if (test != 0) {
/* 1023 */           return test;
/*      */         }
/* 1025 */         return rcl1.getAddedOrder() - rcl2.getAddedOrder();
/*      */       }
/*      */ 
/* 1029 */       DomainClassLoaderUCLImpl rcl1 = (DomainClassLoaderUCLImpl)o1;
/* 1030 */       DomainClassLoaderUCLImpl rcl2 = (DomainClassLoaderUCLImpl)o2;
/* 1031 */       return rcl1.getAddedOrder() - rcl2.getAddedOrder();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.UnifiedLoaderRepositoryDCL
 * JD-Core Version:    0.6.0
 */