/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ 
/*     */ public class HeirarchicalLoaderRepository3 extends UnifiedLoaderRepository3
/*     */ {
/*  50 */   private static ObjectName DEFAULT_LOADER_OBJECT_NAME = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
/*     */   private UnifiedLoaderRepository3 parentRepository;
/*     */   private boolean java2ParentDelegation;
/*     */   private LoadMgr3.PkgClassLoader packageClassLoader;
/*     */ 
/*     */   public HeirarchicalLoaderRepository3(UnifiedLoaderRepository3 parent)
/*     */     throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 135 */     this.parentRepository = parent;
/* 136 */     init();
/*     */   }
/*     */ 
/*     */   public HeirarchicalLoaderRepository3(MBeanServer server)
/*     */     throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 150 */     this(server, DEFAULT_LOADER_OBJECT_NAME);
/*     */   }
/*     */ 
/*     */   public HeirarchicalLoaderRepository3(MBeanServer server, ObjectName parentName)
/*     */     throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 165 */     this.parentRepository = ((UnifiedLoaderRepository3)server.getAttribute(parentName, "Instance"));
/*     */ 
/* 167 */     init();
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 176 */     ClassLoader loader = RepositoryClassLoader.class.getClassLoader();
/* 177 */     RepositoryClassLoader ucl = null;
/* 178 */     if ((loader instanceof RepositoryClassLoader))
/* 179 */       ucl = (RepositoryClassLoader)loader;
/*     */     else
/* 181 */       ucl = new UnifiedClassLoader3(null, null, this);
/* 182 */     this.packageClassLoader = new LoadMgr3.PkgClassLoader(ucl, 3);
/*     */   }
/*     */ 
/*     */   public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository)
/*     */     throws Exception
/*     */   {
/* 190 */     UnifiedClassLoader3 ucl = null;
/* 191 */     if (!this.java2ParentDelegation)
/* 192 */       ucl = new UnifiedClassLoader3(url, null, new NoParentClassLoader(), this);
/*     */     else {
/* 194 */       ucl = new UnifiedClassLoader3(url, null, this);
/*     */     }
/* 196 */     if (addToRepository)
/*     */     {
/* 198 */       addClassLoader(ucl);
/*     */     }
/* 200 */     return ucl;
/*     */   }
/*     */ 
/*     */   public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception
/*     */   {
/* 205 */     UnifiedClassLoader3 ucl = null;
/* 206 */     if (!this.java2ParentDelegation)
/* 207 */       ucl = new UnifiedClassLoader3(url, origURL, new NoParentClassLoader(), this);
/*     */     else {
/* 209 */       ucl = new UnifiedClassLoader3(url, origURL, this);
/*     */     }
/* 211 */     if (addToRepository)
/*     */     {
/* 213 */       addClassLoader(ucl);
/*     */     }
/* 215 */     return ucl;
/*     */   }
/*     */ 
/*     */   public boolean getUseParentFirst()
/*     */   {
/* 227 */     return this.java2ParentDelegation;
/*     */   }
/*     */ 
/*     */   public void setUseParentFirst(boolean flag)
/*     */   {
/* 238 */     this.java2ParentDelegation = flag;
/*     */   }
/*     */ 
/*     */   public Class loadClass(String name, boolean resolve, ClassLoader scl)
/*     */     throws ClassNotFoundException
/*     */   {
/* 252 */     Class foundClass = null;
/*     */ 
/* 254 */     if (this.java2ParentDelegation == true)
/*     */     {
/*     */       try
/*     */       {
/* 259 */         foundClass = this.parentRepository.loadClass(name, resolve, scl);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 264 */         if (foundClass == null) {
/* 265 */           foundClass = super.loadClass(name, resolve, scl);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 273 */         foundClass = super.loadClass(name, resolve, scl);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 278 */         if (foundClass == null) {
/* 279 */           foundClass = this.parentRepository.loadClass(name, resolve, scl);
/*     */         }
/*     */       }
/*     */     }
/* 283 */     if (foundClass != null) {
/* 284 */       return foundClass;
/*     */     }
/*     */ 
/* 289 */     throw new ClassNotFoundException(name);
/*     */   }
/*     */ 
/*     */   public Class getCachedClass(String classname)
/*     */   {
/* 303 */     Class clazz = null;
/* 304 */     if (this.java2ParentDelegation == true)
/*     */     {
/* 307 */       clazz = this.parentRepository.getCachedClass(classname);
/*     */ 
/* 309 */       if (clazz == null) {
/* 310 */         clazz = super.getCachedClass(classname);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 315 */       clazz = super.getCachedClass(classname);
/*     */     }
/* 317 */     return clazz;
/*     */   }
/*     */ 
/*     */   public URL getResource(String name, ClassLoader scl)
/*     */   {
/* 329 */     URL resource = null;
/*     */ 
/* 331 */     if (this.java2ParentDelegation == true)
/*     */     {
/* 337 */       resource = getParentResource(name, scl);
/*     */ 
/* 339 */       if (resource == null) {
/* 340 */         resource = super.getResource(name, scl);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 345 */       resource = super.getResource(name, scl);
/*     */ 
/* 347 */       if (resource == null)
/*     */       {
/* 353 */         resource = getParentResource(name, scl);
/*     */       }
/*     */     }
/*     */ 
/* 357 */     return resource;
/*     */   }
/*     */ 
/*     */   public void getResources(String name, ClassLoader cl, List urls)
/*     */   {
/* 370 */     if (this.java2ParentDelegation == true)
/*     */     {
/* 373 */       this.parentRepository.getResources(name, cl, urls);
/*     */ 
/* 375 */       super.getResources(name, cl, urls);
/*     */     }
/*     */     else
/*     */     {
/* 380 */       super.getResources(name, cl, urls);
/*     */ 
/* 382 */       this.parentRepository.getResources(name, cl, urls);
/*     */     }
/*     */   }
/*     */ 
/*     */   public URL[] getURLs()
/*     */   {
/* 391 */     URL[] ourURLs = super.getURLs();
/* 392 */     URL[] parentURLs = this.parentRepository.getURLs();
/* 393 */     int size = ourURLs.length + parentURLs.length;
/* 394 */     URL[] urls = new URL[size];
/* 395 */     System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
/* 396 */     System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
/* 397 */     return urls;
/*     */   }
/*     */ 
/*     */   public Class loadClassFromCache(String name)
/*     */   {
/* 406 */     Class foundClass = null;
/*     */ 
/* 408 */     if (this.java2ParentDelegation == true)
/*     */     {
/* 411 */       foundClass = this.parentRepository.loadClassFromCache(name);
/*     */ 
/* 413 */       if (foundClass == null) {
/* 414 */         foundClass = super.loadClassFromCache(name);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 419 */       foundClass = super.loadClassFromCache(name);
/*     */     }
/*     */ 
/* 424 */     return foundClass;
/*     */   }
/*     */ 
/*     */   public Set getPackageClassLoaders(String name)
/*     */   {
/* 434 */     Set pkgSet = super.getPackageClassLoaders(name);
/* 435 */     Set parentPkgSet = this.parentRepository.getPackageClassLoaders(name);
/* 436 */     GetClassLoadersAction action = new GetClassLoadersAction(name, pkgSet, parentPkgSet);
/*     */ 
/* 438 */     Set theSet = (Set)AccessController.doPrivileged(action);
/* 439 */     return theSet;
/*     */   }
/*     */ 
/*     */   public int compare(LoaderRepository lr)
/*     */   {
/* 445 */     if (lr == this)
/* 446 */       return 0;
/* 447 */     return reverseCompare(lr);
/*     */   }
/*     */ 
/*     */   protected int reverseCompare(LoaderRepository lr)
/*     */   {
/* 453 */     if (lr != this.parentRepository) {
/* 454 */       return 0;
/*     */     }
/*     */ 
/* 457 */     if (this.java2ParentDelegation) {
/* 458 */       return 1;
/*     */     }
/* 460 */     return -1;
/*     */   }
/*     */ 
/*     */   private URL getParentResource(String name, ClassLoader scl)
/*     */   {
/* 474 */     URL resource = this.parentRepository.getResourceFromGlobalCache(name);
/*     */ 
/* 477 */     if (resource != null) {
/* 478 */       return resource;
/*     */     }
/*     */ 
/* 481 */     resource = this.parentRepository.getResourceFromRepository(name, scl);
/*     */ 
/* 483 */     return resource;
/*     */   }
/*     */   private class GetClassLoadersAction implements PrivilegedAction {
/*     */     private String name;
/*     */     Set pkgSet;
/*     */     Set parentPkgSet;
/*     */ 
/*     */     GetClassLoadersAction(String name, Set pkgSet, Set parentPkgSet) {
/* 494 */       this.name = name;
/* 495 */       this.pkgSet = pkgSet;
/* 496 */       this.parentPkgSet = parentPkgSet;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 502 */       Set theSet = ClassLoaderUtils.newPackageSet();
/* 503 */       if (this.pkgSet != null)
/*     */       {
/* 505 */         Iterator iter = this.pkgSet.iterator();
/* 506 */         while (iter.hasNext())
/*     */         {
/* 508 */           RepositoryClassLoader ucl = (RepositoryClassLoader)iter.next();
/* 509 */           LoadMgr3.PkgClassLoader pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 0);
/* 510 */           theSet.add(pkgUcl);
/*     */         }
/*     */       }
/*     */ 
/* 514 */       if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation)
/*     */       {
/* 516 */         Class cacheClass = HeirarchicalLoaderRepository3.this.parentRepository.loadClassFromCache(this.name);
/* 517 */         if (cacheClass != null)
/*     */         {
/* 519 */           RepositoryClassLoader ucl = new HeirarchicalLoaderRepository3.CacheClassLoader(cacheClass, HeirarchicalLoaderRepository3.this);
/* 520 */           LoadMgr3.PkgClassLoader pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 1);
/* 521 */           theSet.add(pkgUcl);
/*     */         }
/*     */       }
/*     */ 
/* 525 */       if (this.parentPkgSet != null)
/*     */       {
/* 527 */         Iterator iter = this.parentPkgSet.iterator();
/* 528 */         while (iter.hasNext())
/*     */         {
/* 530 */           RepositoryClassLoader ucl = (RepositoryClassLoader)iter.next();
/* 531 */           LoadMgr3.PkgClassLoader pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 2);
/* 532 */           theSet.add(pkgUcl);
/*     */         }
/*     */       }
/*     */ 
/* 536 */       if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation)
/*     */       {
/* 538 */         theSet.add(HeirarchicalLoaderRepository3.this.packageClassLoader);
/*     */       }
/*     */ 
/* 541 */       return theSet;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class CacheClassLoader extends UnifiedClassLoader3
/*     */   {
/*     */     Class cacheClass;
/*     */ 
/*     */     CacheClassLoader(Class cacheClass, LoaderRepository rep)
/*     */     {
/*  99 */       super(null, new HeirarchicalLoaderRepository3.NoParentClassLoader(), rep);
/* 100 */       this.cacheClass = cacheClass;
/*     */     }
/*     */ 
/*     */     protected Class findClass(String name) throws ClassNotFoundException
/*     */     {
/* 105 */       Class c = this.cacheClass;
/* 106 */       if (!name.equals(this.cacheClass.getName()))
/* 107 */         c = null;
/* 108 */       return c;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class NoParentClassLoader extends ClassLoader
/*     */   {
/*     */     NoParentClassLoader()
/*     */     {
/*  59 */       super();
/*     */     }
/*     */ 
/*     */     public URL getResource(String name)
/*     */     {
/*  69 */       return null;
/*     */     }
/*     */ 
/*     */     protected synchronized Class loadClass(String name, boolean resolve)
/*     */       throws ClassNotFoundException
/*     */     {
/*  81 */       throw new ClassNotFoundException("NoParentClassLoader has no classes");
/*     */     }
/*     */ 
/*     */     protected Class findClass(String name)
/*     */       throws ClassNotFoundException
/*     */     {
/*  91 */       throw new ClassNotFoundException("NoParentClassLoader has no classes");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.HeirarchicalLoaderRepository3
 * JD-Core Version:    0.6.0
 */