/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
/*     */ import java.net.URL;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Policy;
/*     */ import java.util.Enumeration;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DomainClassLoaderUCLImpl extends LegacyDomainClassLoader
/*     */   implements UnifiedClassLoaderMBean
/*     */ {
/*  32 */   private static final Logger log = Logger.getLogger(DomainClassLoaderUCLImpl.class);
/*     */ 
/*     */   public DomainClassLoaderUCLImpl(URL[] cp, LoaderRepositoryDomain repository)
/*     */   {
/*  45 */     super(cp, null);
/*     */ 
/*  48 */     repository.addClassLoader(this);
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */     throws MalformedObjectNameException
/*     */   {
/*  59 */     String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
/*  60 */     return new ObjectName(name);
/*     */   }
/*     */ 
/*     */   public String[] getPackageNames()
/*     */   {
/*  68 */     UnifiedLoaderRepositoryDCL ulr = (UnifiedLoaderRepositoryDCL)this.domain;
/*  69 */     return ulr.getPackageNames(this);
/*     */   }
/*     */ 
/*     */   public void unregister()
/*     */   {
/*  74 */     super.unregister();
/*     */   }
/*     */ 
/*     */   public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt)
/*     */     throws ClassNotFoundException
/*     */   {
/*  80 */     this.loadClassDepth += 1;
/*  81 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  83 */     if (trace)
/*  84 */       log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
/*  85 */     if (this.domain == null)
/*     */     {
/*     */       try
/*     */       {
/*  90 */         return super.loadClass(name, resolve);
/*     */       }
/*     */       catch (ClassNotFoundException msg)
/*     */       {
/*  95 */         String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
/*  96 */         throw new ClassNotFoundException(msg, this.unregisterTrace);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 104 */     boolean acquired = attempt(1L);
/* 105 */     while (!acquired)
/*     */     {
/*     */       try
/*     */       {
/* 113 */         if (trace)
/* 114 */           log.trace("Waiting for loadClass lock");
/* 115 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/* 120 */       acquired = attempt(1L);
/*     */     }
/*     */ 
/* 123 */     ClassLoadingTaskDCL task = null;
/*     */     try
/*     */     {
/* 126 */       Thread t = Thread.currentThread();
/*     */ 
/* 128 */       if (this.loadLock.holds() == 1L) {
/* 129 */         LoadMgrDCL.registerLoaderThread(this, t);
/*     */       }
/*     */ 
/* 132 */       task = new ClassLoadingTaskDCL(name, this, t, stopAt);
/*     */ 
/* 136 */       UnifiedLoaderRepositoryDCL repository = (UnifiedLoaderRepositoryDCL)this.domain;
/* 137 */       if (!LoadMgrDCL.beginLoadTask(task, repository)) {
/*     */         while (true) {
/* 139 */           if (task.threadTaskCount != 0)
/*     */           {
/*     */             try
/*     */             {
/* 143 */               LoadMgrDCL.nextTask(t, task, repository);
/*     */             }
/*     */             catch (InterruptedException e)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 156 */       if (this.loadLock.holds() == 1L) {
/* 157 */         LoadMgrDCL.endLoadTask(task);
/*     */       }
/* 159 */       release();
/* 160 */       notifyAll();
/* 161 */       this.loadClassDepth -= 1;
/*     */     }
/*     */ 
/* 164 */     if (task.loadedClass == null)
/*     */     {
/* 166 */       if ((task.loadException instanceof ClassNotFoundException))
/* 167 */         throw ((ClassNotFoundException)task.loadException);
/* 168 */       if ((task.loadException instanceof NoClassDefFoundError))
/* 169 */         throw ((NoClassDefFoundError)task.loadException);
/* 170 */       if (task.loadException != null)
/*     */       {
/* 172 */         if (log.isTraceEnabled())
/* 173 */           log.trace("Unexpected error during load of:" + name, task.loadException);
/* 174 */         String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
/*     */ 
/* 176 */         ClassNotFoundException cnfe = new ClassNotFoundException(msg, task.loadException);
/* 177 */         throw cnfe;
/*     */       }
/*     */ 
/* 181 */       throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
/*     */     }
/*     */ 
/* 184 */     return task.loadedClass;
/*     */   }
/*     */ 
/*     */   protected PermissionCollection getPermissions(CodeSource cs)
/*     */   {
/* 205 */     CodeSource permCS = cs;
/* 206 */     Policy policy = Policy.getPolicy();
/* 207 */     PermissionCollection perms = super.getPermissions(permCS);
/* 208 */     PermissionCollection perms2 = super.getPermissions(cs);
/* 209 */     PermissionCollection perms3 = policy.getPermissions(permCS);
/* 210 */     Enumeration iter = perms2.elements();
/* 211 */     while (iter.hasMoreElements())
/* 212 */       perms.add((Permission)iter.nextElement());
/* 213 */     iter = perms3.elements();
/* 214 */     while (iter.hasMoreElements())
/* 215 */       perms.add((Permission)iter.nextElement());
/* 216 */     if (log.isTraceEnabled())
/* 217 */       log.trace("getPermissions, cp: " + getURLs() + " -> " + perms);
/* 218 */     return perms;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.DomainClassLoaderUCLImpl
 * JD-Core Version:    0.6.0
 */