/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoadingTask
/*     */ {
/*  37 */   protected static Logger log = Logger.getLogger(ClassLoadingTask.class);
/*  38 */   protected static Comparator taskComparator = new ThreadTaskComparator();
/*     */   public static final int FOUND_CLASS_LOADER = 1;
/*     */   public static final int NEXT_EVENT = 2;
/*     */   public static final int WAIT_ON_EVENT = 3;
/*     */   public static final int FINISHED = 4;
/*     */   protected String classname;
/*     */   protected Thread requestingThread;
/*     */   protected RepositoryClassLoader requestingClassLoader;
/*     */   protected Class loadedClass;
/*  49 */   protected int loadOrder = 2147483647;
/*  50 */   protected int stopOrder = 2147483647;
/*     */   protected Throwable loadException;
/*     */   protected int threadTaskCount;
/*     */   protected int state;
/*     */   protected boolean trace;
/*     */   protected int numCCE;
/*     */ 
/*     */   protected ClassLoadingTask(String classname, RepositoryClassLoader requestingClassLoader, Thread requestingThread)
/*     */   {
/* 149 */     this(classname, requestingClassLoader, requestingThread, 2147483647);
/*     */   }
/*     */ 
/*     */   protected ClassLoadingTask(String classname, RepositoryClassLoader requestingClassLoader, Thread requestingThread, int stopAt)
/*     */   {
/* 155 */     this.requestingThread = requestingThread;
/* 156 */     this.requestingClassLoader = requestingClassLoader;
/* 157 */     this.classname = classname;
/* 158 */     this.stopOrder = stopAt;
/* 159 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   synchronized int incNumCCE()
/*     */   {
/* 164 */     int cce = this.numCCE++;
/* 165 */     return cce;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 170 */     StringBuffer buffer = new StringBuffer(super.toString());
/* 171 */     buffer.append('{');
/* 172 */     buffer.append("classname: " + this.classname);
/* 173 */     buffer.append(", requestingThread: " + this.requestingThread);
/* 174 */     buffer.append(", requestingClassLoader: " + this.requestingClassLoader);
/* 175 */     buffer.append(", loadedClass: " + this.loadedClass);
/* 176 */     ClassToStringAction.toString(this.loadedClass, buffer);
/* 177 */     buffer.append(", loadOrder: " + this.loadOrder);
/* 178 */     buffer.append(", loadException: " + this.loadException);
/* 179 */     buffer.append(", threadTaskCount: " + this.threadTaskCount);
/* 180 */     buffer.append(", state: " + this.state);
/* 181 */     buffer.append(", #CCE: " + this.numCCE);
/* 182 */     buffer.append('}');
/* 183 */     if ((this.trace) && (this.loadException != null))
/*     */     {
/* 185 */       StringWriter sw = new StringWriter();
/* 186 */       PrintWriter pw = new PrintWriter(sw);
/* 187 */       this.loadException.printStackTrace(pw);
/* 188 */       buffer.append("loadException details:\n");
/* 189 */       buffer.append(sw.toString());
/*     */     }
/* 191 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   ThreadTask newThreadTask(RepositoryClassLoader ucl, Thread t, int order, boolean reschedule, boolean releaseInNextTask)
/*     */   {
/* 198 */     if (!reschedule)
/* 199 */       this.threadTaskCount += 1;
/* 200 */     return new ThreadTask(ucl, t, order, releaseInNextTask);
/*     */   }
/*     */ 
/*     */   synchronized void setLoadError(Throwable t)
/*     */   {
/* 205 */     this.threadTaskCount -= 1;
/* 206 */     if (this.trace)
/* 207 */       log.trace("setLoadedError, error=" + t);
/* 208 */     this.loadException = t;
/*     */   }
/*     */ 
/*     */   private synchronized void setLoadedClass(Class theClass, int order)
/*     */   {
/* 218 */     this.threadTaskCount -= 1;
/* 219 */     if (this.trace) {
/* 220 */       log.trace("setLoadedClass, theClass=" + theClass + ", order=" + order);
/*     */     }
/*     */ 
/* 223 */     if ((this.loadedClass != null) && (order == this.loadOrder) && (theClass != null))
/*     */     {
/* 225 */       StringBuffer tmp = new StringBuffer("Duplicate class found: " + this.classname);
/* 226 */       tmp.append('\n');
/* 227 */       ProtectionDomain pd = this.loadedClass.getProtectionDomain();
/* 228 */       CodeSource cs = pd != null ? pd.getCodeSource() : null;
/* 229 */       tmp.append("Current CS: " + cs);
/* 230 */       tmp.append('\n');
/* 231 */       pd = theClass.getProtectionDomain();
/* 232 */       cs = pd != null ? pd.getCodeSource() : null;
/* 233 */       tmp.append("Duplicate CS: " + cs);
/* 234 */       log.warn(tmp.toString());
/*     */     }
/*     */ 
/* 238 */     if (theClass != null)
/*     */     {
/* 240 */       if ((this.loadedClass == null) || (order <= this.loadOrder))
/*     */       {
/* 242 */         this.loadedClass = theClass;
/* 243 */         this.loadOrder = order;
/*     */       }
/*     */       else
/*     */       {
/* 247 */         ProtectionDomain pd = this.loadedClass.getProtectionDomain();
/* 248 */         CodeSource cs = pd != null ? pd.getCodeSource() : null;
/* 249 */         ProtectionDomain pd2 = theClass.getProtectionDomain();
/* 250 */         CodeSource cs2 = pd != null ? pd2.getCodeSource() : null;
/* 251 */         log.debug("Ignoring source of: " + this.classname + " from CodeSource: " + cs2 + ", due to order(" + order + ">=" + this.loadOrder + "), " + "accepted CodeSource: " + cs);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class ThreadTask
/*     */   {
/*     */     RepositoryClassLoader ucl;
/*     */     Thread t;
/*     */     int order;
/*     */     boolean releaseInNextTask;
/*     */ 
/*     */     ThreadTask(RepositoryClassLoader ucl, Thread t, int order, boolean releaseInNextTask)
/*     */     {
/*  97 */       this.ucl = ucl;
/*  98 */       this.t = t;
/*  99 */       this.order = order;
/* 100 */       this.releaseInNextTask = releaseInNextTask;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 105 */       return "{t=" + this.t + ", ucl=" + this.ucl + ", name=" + ClassLoadingTask.this.classname + ", requestingThread=" + ClassLoadingTask.this.requestingThread + ", order=" + this.order + ", releaseInNextTask=" + this.releaseInNextTask + "}";
/*     */     }
/*     */ 
/*     */     String getClassname()
/*     */     {
/* 113 */       return ClassLoadingTask.this.classname;
/*     */     }
/*     */ 
/*     */     Class getLoadedClass() {
/* 117 */       return ClassLoadingTask.this.loadedClass;
/*     */     }
/*     */ 
/*     */     ClassLoadingTask getLoadTask() {
/* 121 */       return ClassLoadingTask.this;
/*     */     }
/*     */ 
/*     */     void run() throws ClassNotFoundException
/*     */     {
/* 126 */       Class theClass = null;
/*     */       try
/*     */       {
/* 129 */         if (ClassLoadingTask.this.loadedClass == null)
/*     */         {
/* 131 */           theClass = this.ucl.loadClassLocally(ClassLoadingTask.this.classname, false);
/* 132 */           ClassLoadingTask.this.setLoadedClass(theClass, this.order);
/*     */         }
/* 134 */         else if (ClassLoadingTask.this.trace)
/*     */         {
/* 136 */           ClassLoadingTask.log.trace("Already found class(" + ClassLoadingTask.this.loadedClass + "), skipping loadClassLocally");
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ThreadTaskComparator
/*     */     implements Comparator
/*     */   {
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/*  68 */       ClassLoadingTask.ThreadTask t1 = (ClassLoadingTask.ThreadTask)o1;
/*  69 */       ClassLoadingTask.ThreadTask t2 = (ClassLoadingTask.ThreadTask)o2;
/*  70 */       int compare = t1.order - t2.order;
/*  71 */       if (compare == 0)
/*     */       {
/*  73 */         compare = t1.ucl.getAddedOrder() - t2.ucl.getAddedOrder();
/*     */       }
/*  75 */       return compare;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.ClassLoadingTask
 * JD-Core Version:    0.6.0
 */