/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class BasicLoaderRepository extends LoaderRepository
/*     */ {
/*     */   public Class loadClass(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/*  59 */     return loadClassWithout(null, className);
/*     */   }
/*     */ 
/*     */   public Class loadClassWithout(ClassLoader skipLoader, String className)
/*     */     throws ClassNotFoundException
/*     */   {
/*  74 */     ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/*  75 */     if (ctxLoader != skipLoader)
/*     */     {
/*     */       try
/*     */       {
/*  79 */         return ctxLoader.loadClass(className);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  87 */     Iterator it = loaders.iterator();
/*  88 */     while (it.hasNext())
/*     */     {
/*  90 */       ClassLoader cl = (ClassLoader)it.next();
/*  91 */       if (cl != skipLoader)
/*     */       {
/*     */         try
/*     */         {
/*  95 */           return cl.loadClass(className);
/*     */         }
/*     */         catch (ClassNotFoundException ignored)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 105 */     Class clazz = getNativeClassForName(className);
/* 106 */     if (clazz != null) return clazz;
/*     */ 
/* 108 */     throw new ClassNotFoundException(className);
/*     */   }
/*     */ 
/*     */   public Class loadClassBefore(ClassLoader stop, String className)
/*     */     throws ClassNotFoundException
/*     */   {
/* 126 */     Iterator it = loaders.iterator();
/* 127 */     while (it.hasNext())
/*     */     {
/* 129 */       ClassLoader cl = (ClassLoader)it.next();
/* 130 */       if (cl == stop) {
/*     */         break;
/*     */       }
/*     */       try
/*     */       {
/* 135 */         return cl.loadClass(className);
/*     */       }
/*     */       catch (ClassNotFoundException ignored)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 144 */     Class clazz = getNativeClassForName(className);
/* 145 */     if (clazz != null) return clazz;
/*     */ 
/* 147 */     throw new ClassNotFoundException(className);
/*     */   }
/*     */ 
/*     */   public void addClassLoader(ClassLoader cl)
/*     */   {
/* 152 */     loaders.add(cl);
/*     */   }
/*     */ 
/*     */   public boolean addClassLoaderURL(ClassLoader cl, URL url)
/*     */   {
/* 158 */     return false;
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoader cl)
/*     */   {
/* 163 */     loaders.remove(cl);
/*     */   }
/*     */ 
/*     */   public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository)
/*     */     throws Exception
/*     */   {
/* 169 */     UnifiedClassLoader ucl = new UnifiedClassLoader(url);
/* 170 */     if (addToRepository)
/* 171 */       addClassLoader(ucl);
/* 172 */     return ucl;
/*     */   }
/*     */ 
/*     */   public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception
/*     */   {
/* 177 */     UnifiedClassLoader ucl = new UnifiedClassLoader(url, origURL);
/* 178 */     if (addToRepository)
/* 179 */       addClassLoader(ucl);
/* 180 */     return ucl;
/*     */   }
/*     */ 
/*     */   public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException
/*     */   {
/* 185 */     throw new ClassNotFoundException("loadClass(String,boolean,ClassLoader) not supported");
/*     */   }
/*     */ 
/*     */   public URL getResource(String name, ClassLoader cl) {
/* 189 */     URL res = null;
/* 190 */     if ((cl instanceof UnifiedClassLoader))
/*     */     {
/* 192 */       UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
/* 193 */       res = ucl.getResourceLocally(name);
/*     */     }
/*     */     else
/*     */     {
/* 197 */       res = cl.getResource(name);
/*     */     }
/* 199 */     return res;
/*     */   }
/*     */ 
/*     */   public void getResources(String name, ClassLoader cl, List urls) {
/* 203 */     Enumeration resURLs = null;
/*     */     try
/*     */     {
/* 206 */       if ((cl instanceof UnifiedClassLoader))
/*     */       {
/* 208 */         UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
/* 209 */         resURLs = ucl.findResourcesLocally(name);
/*     */       }
/*     */       else
/*     */       {
/* 213 */         resURLs = cl.getResources(name);
/*     */       }
/* 215 */       while (resURLs.hasMoreElements())
/* 216 */         urls.add(resURLs.nextElement());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.BasicLoaderRepository
 * JD-Core Version:    0.6.0
 */