/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.PersistentMBean;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanConstants;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ import org.jboss.mx.service.ServiceConstants;
/*     */ 
/*     */ public class PersistenceInterceptor extends AbstractInterceptor
/*     */   implements ModelMBeanConstants, ServiceConstants
/*     */ {
/*  55 */   private HashMap attrPersistencePolicies = new HashMap();
/*     */ 
/*  57 */   private HashMap timerTaskMap = new HashMap();
/*     */   private String mbeanPersistencePolicy;
/*     */   private PersistentMBean callback;
/*     */ 
/*     */   public PersistenceInterceptor()
/*     */   {
/*  65 */     super("Default Persistence Interceptor");
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  71 */     if (this.callback == null)
/*     */     {
/*  73 */       lazyInit(invocation);
/*     */     }
/*     */ 
/*  76 */     Object returnValue = invocation.nextInterceptor().invoke(invocation);
/*  77 */     String type = invocation.getType();
/*  78 */     if (type != "setAttribute") {
/*  79 */       return returnValue;
/*     */     }
/*  81 */     String attrName = invocation.getName();
/*  82 */     String policy = (String)this.attrPersistencePolicies.get(attrName);
/*  83 */     if (policy == null) {
/*  84 */       policy = this.mbeanPersistencePolicy;
/*     */     }
/*  86 */     if (policy.equalsIgnoreCase("OnUpdate") == true)
/*     */     {
/*  88 */       MBeanInvoker invoker = invocation.getInvoker();
/*  89 */       Descriptor attrDesc = invocation.getDescriptor();
/*  90 */       invoker.updateAttributeInfo(attrDesc);
/*  91 */       this.callback.store();
/*     */     }
/*  93 */     else if (policy.equalsIgnoreCase("NoMoreOftenThan") == true)
/*     */     {
/*  95 */       PersistenceTimerTask task = (PersistenceTimerTask)this.timerTaskMap.get(attrName);
/*  96 */       if (task != null)
/*  97 */         task.setHasUpdated(true);
/*     */     }
/*  99 */     return returnValue;
/*     */   }
/*     */ 
/*     */   private synchronized void lazyInit(Invocation invocation)
/*     */     throws MBeanException
/*     */   {
/* 109 */     MBeanInvoker invoker = invocation.getInvoker();
/* 110 */     this.callback = ((PersistentMBean)invocation.getInvoker());
/* 111 */     ModelMBeanInfo info = (ModelMBeanInfo)invoker.getMetaData();
/* 112 */     Descriptor mbeanDesc = info.getMBeanDescriptor();
/*     */ 
/* 114 */     String policy = (String)mbeanDesc.getFieldValue("persistPolicy");
/* 115 */     String persistPeriod = (String)mbeanDesc.getFieldValue("persistPeriod");
/*     */ 
/* 117 */     this.mbeanPersistencePolicy = "Never";
/* 118 */     if (policy != null)
/*     */     {
/* 120 */       this.mbeanPersistencePolicy = policy;
/* 121 */       if ((this.mbeanPersistencePolicy.equalsIgnoreCase("OnTimer")) || (this.mbeanPersistencePolicy.equalsIgnoreCase("NoMoreOftenThan")))
/*     */       {
/* 124 */         boolean isNoMoreOftenThan = this.mbeanPersistencePolicy.equalsIgnoreCase("NoMoreOftenThan");
/* 125 */         schedulePersistenceNotifications(Long.parseLong(persistPeriod), "mbean", isNoMoreOftenThan);
/*     */       }
/*     */     }
/*     */ 
/* 129 */     Descriptor[] attrDescs = info.getDescriptors("attribute");
/* 130 */     for (int i = 0; i < attrDescs.length; i++)
/*     */     {
/* 132 */       policy = (String)attrDescs[i].getFieldValue("persistPolicy");
/* 133 */       persistPeriod = (String)attrDescs[i].getFieldValue("persistPeriod");
/*     */ 
/* 135 */       if (policy == null)
/*     */         continue;
/* 137 */       String name = (String)attrDescs[i].getFieldValue("name");
/* 138 */       this.attrPersistencePolicies.put(name, policy);
/*     */ 
/* 140 */       if ((!policy.equalsIgnoreCase("OnTimer")) && (!policy.equalsIgnoreCase("NoMoreOftenThan"))) {
/*     */         continue;
/*     */       }
/* 143 */       boolean isNoMoreOftenThan = policy.equalsIgnoreCase("NoMoreOftenThan");
/* 144 */       schedulePersistenceNotifications(Long.parseLong(persistPeriod), name, isNoMoreOftenThan);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void schedulePersistenceNotifications(long persistPeriod, String name, boolean isNoMoreOftenThan)
/*     */   {
/* 154 */     PersistenceTimerTask task = new PersistenceTimerTask(name, isNoMoreOftenThan);
/* 155 */     Timer timer = new Timer(true);
/* 156 */     timer.scheduleAtFixedRate(task, 0L, persistPeriod);
/* 157 */     this.timerTaskMap.put(name, task);
/*     */   }
/*     */   private class PersistenceTimerTask extends TimerTask {
/*     */     boolean noMoreOftenThan;
/*     */     boolean hasUpdated;
/*     */     String name;
/*     */ 
/*     */     PersistenceTimerTask(String name, boolean noMoreOftenThan) {
/* 168 */       this.name = name;
/* 169 */       this.noMoreOftenThan = noMoreOftenThan;
/*     */     }
/*     */ 
/*     */     synchronized void setHasUpdated(boolean flag) {
/* 173 */       this.hasUpdated = flag;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 182 */         boolean doStore = ((this.noMoreOftenThan == true) && (this.hasUpdated == true)) || (!this.noMoreOftenThan);
/*     */ 
/* 184 */         if (doStore == true)
/*     */         {
/* 186 */           PersistenceInterceptor.this.callback.store();
/* 187 */           setHasUpdated(false);
/*     */         }
/*     */       }
/*     */       catch (MBeanException e)
/*     */       {
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.PersistenceInterceptor
 * JD-Core Version:    0.6.0
 */