/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanConstants;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ 
/*     */ public class ModelMBeanOperationInterceptor extends AbstractInterceptor
/*     */   implements ModelMBeanConstants
/*     */ {
/*     */   private boolean trace;
/*     */ 
/*     */   public ModelMBeanOperationInterceptor()
/*     */   {
/*  54 */     super("ModelMBean Operation Interceptor");
/*  55 */     this.trace = this.log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  64 */     Descriptor d = invocation.getDescriptor();
/*  65 */     Class clazz = invocation.getReturnTypeClass();
/*     */ 
/*  67 */     String name = null;
/*  68 */     ObjectName objectName = null;
/*  69 */     if (this.trace)
/*     */     {
/*  71 */       if (d != null)
/*  72 */         name = (String)d.getFieldValue("name");
/*  73 */       objectName = invocation.getInvoker().getObjectName();
/*     */     }
/*     */ 
/*  76 */     if (this.trace)
/*     */     {
/*  78 */       Object args = invocation.getArgs();
/*  79 */       if (args != null)
/*  80 */         args = Arrays.asList((Object[])(Object[])args);
/*  81 */       this.log.trace("Invoking objectName=" + objectName + " oper=" + name + " args=" + args + " desc=" + d);
/*     */     }
/*     */ 
/*  84 */     long limit = -1L;
/*     */ 
/*  86 */     if ((d != null) && (clazz != null))
/*     */     {
/*  88 */       String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
/*  89 */       if (timeLimit != null) {
/*  90 */         limit = Long.parseLong(timeLimit);
/*     */       }
/*     */ 
/*  93 */       if (limit == 0L)
/*     */       {
/*  95 */         String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
/*  96 */         if (timeStamp != null)
/*     */         {
/*  98 */           Object value = d.getFieldValue("value");
/*  99 */           if (this.trace)
/* 100 */             this.log.trace("Always cache objectName=" + objectName + " oper=" + name + " value=" + value);
/* 101 */           checkAssignable("Cached value in descriptor ", clazz, value);
/* 102 */           return value;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 107 */       if (limit != -1L)
/*     */       {
/* 109 */         String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
/* 110 */         long lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
/*     */ 
/* 113 */         long now = System.currentTimeMillis();
/* 114 */         long expires = lastUpdate * 1000L + limit * 1000L;
/* 115 */         if (now < expires)
/*     */         {
/* 117 */           Object value = d.getFieldValue("value");
/* 118 */           if (this.trace)
/* 119 */             this.log.trace("Using cache objectName=" + objectName + " oper=" + name + " value=" + value + " now=" + now + " expires=" + expires);
/* 120 */           checkAssignable("Cached value in descriptor ", clazz, value);
/* 121 */           return value;
/*     */         }
/*     */ 
/* 125 */         if (this.trace)
/* 126 */           this.log.trace("Cache expired objectName=" + objectName + " oper=" + name + " now=" + now + " expires=" + expires);
/* 127 */         d.removeField("value");
/*     */       }
/*     */       else
/*     */       {
/* 133 */         if (this.trace)
/* 134 */           this.log.trace("Removing any cached value objectName=" + objectName + " oper=" + name + " descriptor=" + d);
/* 135 */         d.removeField("value");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 140 */     Object value = invocation.invoke();
/* 141 */     if (this.trace) {
/* 142 */       this.log.trace("Got result objectName=" + objectName + " oper=" + name + " value=" + value);
/*     */     }
/*     */ 
/* 145 */     if ((d != null) && (limit != -1L))
/*     */     {
/* 147 */       String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
/* 148 */       if (this.trace)
/* 149 */         this.log.trace("Cache result objectName=" + objectName + " oper=" + name + " value=" + value + " timestamp=" + timestamp);
/* 150 */       d.setField("value", value);
/* 151 */       d.setField("lastUpdatedTimeStamp", timestamp);
/*     */     }
/* 153 */     return value;
/*     */   }
/*     */ 
/*     */   protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException
/*     */   {
/* 158 */     if ((value != null) && (!clazz.isAssignableFrom(value.getClass())))
/* 159 */       throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.ModelMBeanOperationInterceptor
 * JD-Core Version:    0.6.0
 */