/*     */ package org.jboss.mq.server.jmx;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.jms.server.destination.TopicService;
/*     */ import org.jboss.managed.api.ManagedOperation.Impact;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementOperation;
/*     */ import org.jboss.managed.api.annotation.ManagementProperties;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Topic"), properties=ManagementProperties.EXPLICIT)
/*     */ public class Topic
/*     */   implements MBeanRegistration, TopicMBean
/*     */ {
/*     */   private TopicService delegate;
/*     */ 
/*     */   public Topic()
/*     */   {
/*  54 */     this.delegate = new TopicService();
/*     */   }
/*     */ 
/*     */   public Topic(boolean createProgramatically) {
/*  58 */     this.delegate = new TopicService(createProgramatically);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  67 */     this.delegate.create();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void destroy()
/*     */   {
/*  76 */     this.delegate.destroy();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The write-cache size, can only be set when queue is stopped")
/*     */   public int getDownCacheSize()
/*     */   {
/*  85 */     return this.delegate.getDownCacheSize();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The in-memory message limit, can only be set when queue is stopped")
/*     */   public int getFullSize()
/*     */   {
/*  94 */     return this.delegate.getFullSize();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public String getJNDIName()
/*     */   {
/* 103 */     return this.delegate.getJNDIName();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listNonDurableMessages(String subscriptionId) throws Exception {
/* 109 */     return this.delegate.listNonDurableMessages(subscriptionId);
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public String getName()
/*     */   {
/* 118 */     return this.delegate.getName();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="he paging size, can only be set when queue is stopped")
/*     */   public int getPageSize()
/*     */   {
/* 127 */     return this.delegate.getPageSize();
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 135 */     return this.delegate.getServer();
/*     */   }
/*     */ 
/*     */   public ObjectName getServerPeer()
/*     */   {
/* 143 */     return this.delegate.getServerPeer();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*     */   public boolean isCreatedProgrammatically()
/*     */   {
/* 152 */     return this.delegate.isCreatedProgrammatically();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listMessagesDurableSub(String arg0, String arg1, String arg2)
/*     */     throws Exception
/*     */   {
/* 161 */     return this.delegate.listDurableMessages(arg0, arg1);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listMessagesNonDurableSub(long arg0, String arg1)
/*     */     throws Exception
/*     */   {
/* 170 */     return this.delegate.listNonDurableMessages(arg1);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List subscriptions on text", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public String listSubscriptionsAsText()
/*     */     throws Exception
/*     */   {
/* 179 */     return this.delegate.listAllSubscriptionsAsHTML();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List subscriptions on text", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public String listSubscriptionsAsText(boolean arg0)
/*     */     throws Exception
/*     */   {
/* 188 */     return this.delegate.listAllSubscriptionsAsHTML();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Remove all the messages on the queue DB", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void removeAllMessages()
/*     */     throws Exception
/*     */   {
/* 197 */     this.delegate.removeAllMessages();
/*     */   }
/*     */ 
/*     */   public void setDownCacheSize(int arg0)
/*     */   {
/* 205 */     this.delegate.setDownCacheSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setFullSize(int arg0)
/*     */   {
/* 213 */     this.delegate.setFullSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setJNDIName(String arg0)
/*     */     throws Exception
/*     */   {
/* 221 */     this.delegate.setJNDIName(arg0);
/*     */   }
/*     */ 
/*     */   public void setPageSize(int arg0)
/*     */   {
/* 229 */     this.delegate.setPageSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(Element arg0)
/*     */     throws Exception
/*     */   {
/* 237 */     this.delegate.setSecurityConfig(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityConf(Element arg0)
/*     */     throws Exception
/*     */   {
/* 244 */     this.delegate.setSecurityConfig(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityManager(ObjectName arg0)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setServerPeer(ObjectName arg0)
/*     */   {
/* 260 */     this.delegate.setServerPeer(arg0);
/*     */   }
/*     */ 
/*     */   public void setDestinationManager(ObjectName arg0)
/*     */     throws Exception
/*     */   {
/* 267 */     ObjectName peer = new ObjectName("jboss.messaging:service=ServerPeer");
/* 268 */     this.delegate.setServerPeer(peer);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 277 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void stop()
/*     */   {
/* 286 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   public int subscriptionCount()
/*     */     throws Exception
/*     */   {
/* 294 */     return this.delegate.getAllSubscriptionsCount();
/*     */   }
/*     */ 
/*     */   public int subscriptionCount(boolean arg0)
/*     */     throws Exception
/*     */   {
/* 302 */     return arg0 ? this.delegate.getDurableSubscriptionsCount() : this.delegate.getNonDurableSubscriptionsCount();
/*     */   }
/*     */ 
/*     */   public ObjectName getExpiryDestination()
/*     */   {
/* 307 */     return null;
/*     */   }
/*     */ 
/*     */   public void setExpiryDestination(ObjectName destination) {
/* 311 */     System.err.println("There is no ExpiryDestination currently");
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 316 */     return this.delegate.toString();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 321 */     this.delegate.postDeregister();
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone) {
/* 325 */     this.delegate.postRegister(registrationDone);
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception {
/* 329 */     this.delegate.preDeregister();
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception
/*     */   {
/* 334 */     return this.delegate.preRegister(server, name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mq.server.jmx.Topic
 * JD-Core Version:    0.6.0
 */