/*     */ package org.jboss.mq.server.jmx;
/*     */ 
/*     */ import java.util.List;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.jms.server.destination.QueueService;
/*     */ import org.jboss.managed.api.ManagedOperation.Impact;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementOperation;
/*     */ import org.jboss.managed.api.annotation.ManagementProperties;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Queue"), properties=ManagementProperties.EXPLICIT)
/*     */ public class Queue
/*     */   implements MBeanRegistration, QueueMBean
/*     */ {
/*     */   private QueueService delegate;
/*     */ 
/*     */   public Queue()
/*     */   {
/*  55 */     this.delegate = new QueueService();
/*     */   }
/*     */ 
/*     */   public Queue(boolean createProgramatically) {
/*  59 */     this.delegate = new QueueService(createProgramatically);
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*  64 */     this.delegate.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  74 */     this.delegate.create();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void destroy()
/*     */   {
/*  84 */     this.delegate.destroy();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The write-cache size, can only be set when queue is stopped")
/*     */   public int getDownCacheSize()
/*     */   {
/*  96 */     return this.delegate.getDownCacheSize();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The in-memory message limit, can only be set when queue is stopped")
/*     */   public int getFullSize()
/*     */   {
/* 106 */     return this.delegate.getFullSize();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public String getJNDIName()
/*     */   {
/* 117 */     return this.delegate.getJNDIName();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*     */   public int getMessageCount()
/*     */     throws Exception
/*     */   {
/* 127 */     return this.delegate.getMessageCount();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public String getName()
/*     */   {
/* 137 */     return this.delegate.getName();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="he paging size, can only be set when queue is stopped")
/*     */   public int getPageSize()
/*     */   {
/* 147 */     return this.delegate.getPageSize();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public ObjectName getServerPeer()
/*     */   {
/* 157 */     return this.delegate.getServerPeer();
/*     */   }
/*     */ 
/*     */   public ObjectName getServiceName() {
/* 161 */     return this.delegate.getServiceName();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*     */   public boolean isCreatedProgrammatically()
/*     */   {
/* 171 */     return this.delegate.isCreatedProgrammatically();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all mesages with the selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listMessages(String arg0)
/*     */     throws Exception
/*     */   {
/* 181 */     return this.delegate.listAllMessages(arg0);
/*     */   }
/*     */   @ManagementOperation(description="List all mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listAllMessages() throws Exception {
/* 186 */     return this.delegate.listAllMessages();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listDurableMessages() throws Exception {
/* 192 */     return this.delegate.listDurableMessages();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listDurableMessages(String selector) throws Exception {
/* 198 */     return this.delegate.listDurableMessages(selector);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listNonDurableMessages() throws Exception {
/* 204 */     return this.delegate.listNonDurableMessages();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="List all non durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listNonDurableMessages(String selector) throws Exception {
/* 210 */     return this.delegate.listNonDurableMessages(selector);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Reset the message counter", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void resetMessageCounter() throws Exception {
/* 216 */     this.delegate.resetMessageCounter();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Remove all messages in the queue", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void removeAllMessages()
/*     */     throws Exception
/*     */   {
/* 226 */     this.delegate.removeAllMessages();
/*     */   }
/*     */ 
/*     */   public void setDownCacheSize(int arg0)
/*     */   {
/* 235 */     this.delegate.setDownCacheSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setFullSize(int arg0)
/*     */   {
/* 244 */     this.delegate.setFullSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setJNDIName(String arg0)
/*     */     throws Exception
/*     */   {
/* 253 */     this.delegate.setJNDIName(arg0);
/*     */   }
/*     */ 
/*     */   public void setPageSize(int arg0)
/*     */   {
/* 262 */     this.delegate.setPageSize(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(Element arg0)
/*     */     throws Exception
/*     */   {
/* 271 */     this.delegate.setSecurityConfig(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityConf(Element arg0) throws Exception {
/* 275 */     this.delegate.setSecurityConfig(arg0);
/*     */   }
/*     */ 
/*     */   public void setSecurityManager(ObjectName arg0)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setServerPeer(ObjectName arg0)
/*     */   {
/* 288 */     this.delegate.setServerPeer(arg0);
/*     */   }
/*     */ 
/*     */   public void setDestinationManager(ObjectName arg0) throws Exception {
/* 292 */     ObjectName peer = new ObjectName("jboss.messaging:service=ServerPeer");
/* 293 */     this.delegate.setServerPeer(peer);
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 303 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void stop()
/*     */   {
/* 313 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   public void setMessageCounterHistoryDayLimit(int arg0)
/*     */   {
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION})
/*     */   public ObjectName getExpiryDestination() {
/* 323 */     return this.delegate.getExpiryQueue();
/*     */   }
/*     */ 
/*     */   public void setExpiryDestination(ObjectName destination)
/*     */   {
/*     */     try
/*     */     {
/* 330 */       this.delegate.setExpiryQueue(destination);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 334 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 339 */     return this.delegate.toString();
/*     */   }
/*     */ 
/*     */   public void postDeregister() {
/* 343 */     this.delegate.postDeregister();
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone) {
/* 347 */     this.delegate.postRegister(registrationDone);
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception {
/* 351 */     this.delegate.preDeregister();
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception
/*     */   {
/* 356 */     return this.delegate.preRegister(server, name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mq.server.jmx.Queue
 * JD-Core Version:    0.6.0
 */