/*     */ package org.jboss.monitor;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.TreeSet;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.NonSerializableFactory;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class EntityLockMonitor extends ServiceMBeanSupport
/*     */   implements EntityLockMonitorMBean
/*     */ {
/*     */   public static final String JNDI_NAME = "EntityLockMonitor";
/*  56 */   protected HashMap monitorMap = new HashMap();
/*  57 */   protected long contenders = 0L;
/*  58 */   protected long maxContenders = 0L;
/*  59 */   protected ArrayList times = new ArrayList();
/*  60 */   protected long contentions = 0L;
/*  61 */   protected long totalTime = 0L;
/*  62 */   protected long sumContenders = 0L;
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*  76 */     bind();
/*     */ 
/*  78 */     this.log.info("EntityLockMonitor started");
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/*     */     try {
/*  84 */       unbind();
/*     */     }
/*     */     catch (Exception ignored) {
/*     */     }
/*  88 */     this.log.info("EntityLockMonitor stopped");
/*     */   }
/*     */ 
/*     */   public synchronized long getAverageContenders()
/*     */   {
/*  98 */     if (this.contentions == 0L)
/*     */     {
/* 100 */       return 0L;
/*     */     }
/*     */ 
/* 104 */     return this.sumContenders / this.contentions;
/*     */   }
/*     */ 
/*     */   public synchronized long getMaxContenders()
/*     */   {
/* 113 */     return this.maxContenders;
/*     */   }
/*     */ 
/*     */   public synchronized long getMedianWaitTime()
/*     */   {
/* 121 */     if (this.times.size() < 1)
/*     */     {
/* 123 */       return 0L;
/*     */     }
/*     */ 
/* 126 */     Long[] alltimes = (Long[])(Long[])this.times.toArray(new Long[this.times.size()]);
/* 127 */     long[] thetimes = new long[alltimes.length];
/* 128 */     for (int i = 0; i < thetimes.length; i++)
/*     */     {
/* 130 */       thetimes[i] = alltimes[i].longValue();
/*     */     }
/* 132 */     Arrays.sort(thetimes);
/* 133 */     return thetimes[(thetimes.length / 2)];
/*     */   }
/*     */ 
/*     */   public synchronized long getTotalContentions()
/*     */   {
/* 141 */     return this.contentions;
/*     */   }
/*     */ 
/*     */   public Set listMonitoredBeans()
/*     */   {
/* 151 */     synchronized (this.monitorMap)
/*     */     {
/* 153 */       return new TreeSet(this.monitorMap.keySet());
/*     */     }
/*     */   }
/*     */ 
/*     */   public LockMonitor getLockMonitor(String jndiName)
/*     */   {
/* 164 */     synchronized (this.monitorMap)
/*     */     {
/* 166 */       return (LockMonitor)this.monitorMap.get(jndiName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String printLockMonitor()
/*     */   {
/* 175 */     StringBuffer rtn = new StringBuffer();
/* 176 */     rtn.append("<table width=\"1\" border=\"1\">");
/* 177 */     rtn.append("<tr><td><b>EJB JNDI-NAME</b></td><td><b>Total Lock Time</b></td><td><b>Num Contentions</b></td><td><b>Time Outs</b></td><td><b>Max Contenders</b></td></tr>");
/* 178 */     synchronized (this.monitorMap)
/*     */     {
/* 180 */       Iterator it = this.monitorMap.keySet().iterator();
/* 181 */       while (it.hasNext())
/*     */       {
/* 183 */         rtn.append("<tr>");
/* 184 */         String jndiName = (String)it.next();
/* 185 */         rtn.append("<td>");
/* 186 */         rtn.append(jndiName);
/* 187 */         rtn.append("</td>");
/* 188 */         LockMonitor lm = (LockMonitor)this.monitorMap.get(jndiName);
/* 189 */         rtn.append("<td>");
/* 190 */         rtn.append("" + lm.getTotalTime());
/* 191 */         rtn.append("</td><td>");
/* 192 */         rtn.append("" + lm.getNumContentions());
/* 193 */         rtn.append("</td><td>");
/* 194 */         rtn.append("" + lm.getTimeouts());
/* 195 */         rtn.append("</td><td>");
/* 196 */         rtn.append("" + lm.getMaxContenders());
/* 197 */         rtn.append("</td></tr>");
/*     */       }
/*     */     }
/* 200 */     rtn.append("</table>");
/* 201 */     return rtn.toString();
/*     */   }
/*     */ 
/*     */   public synchronized void clearMonitor()
/*     */   {
/* 209 */     this.contenders = 0L;
/* 210 */     this.maxContenders = 0L;
/* 211 */     this.times.clear();
/* 212 */     this.contentions = 0L;
/* 213 */     this.totalTime = 0L;
/* 214 */     this.sumContenders = 0L;
/*     */ 
/* 216 */     synchronized (this.monitorMap)
/*     */     {
/* 218 */       Iterator it = this.monitorMap.keySet().iterator();
/* 219 */       while (it.hasNext())
/*     */       {
/* 221 */         String jndiName = (String)it.next();
/* 222 */         LockMonitor lm = (LockMonitor)this.monitorMap.get(jndiName);
/* 223 */         lm.reset();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void incrementContenders()
/*     */   {
/* 232 */     this.contenders += 1L;
/* 233 */     this.contentions += 1L;
/* 234 */     this.sumContenders += this.contenders;
/*     */ 
/* 236 */     if (this.contenders > this.maxContenders)
/*     */     {
/* 238 */       this.maxContenders = this.contenders;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void decrementContenders(long time)
/*     */   {
/* 244 */     this.times.add(new Long(time));
/* 245 */     this.contenders -= 1L;
/*     */   }
/*     */ 
/*     */   public LockMonitor getEntityLockMonitor(String jndiName)
/*     */   {
/* 250 */     LockMonitor lm = null;
/*     */ 
/* 252 */     synchronized (this.monitorMap)
/*     */     {
/* 254 */       lm = (LockMonitor)this.monitorMap.get(jndiName);
/* 255 */       if (lm == null)
/*     */       {
/* 257 */         lm = new LockMonitor(this);
/* 258 */         this.monitorMap.put(jndiName, lm);
/*     */       }
/*     */     }
/* 261 */     return lm;
/*     */   }
/*     */ 
/*     */   private void bind()
/*     */     throws NamingException
/*     */   {
/* 268 */     Context ctx = new InitialContext();
/*     */ 
/* 271 */     NonSerializableFactory.bind("EntityLockMonitor", this);
/*     */ 
/* 275 */     StringRefAddr addr = new StringRefAddr("nns", "EntityLockMonitor");
/* 276 */     Reference ref = new Reference(EntityLockMonitor.class.getName(), addr, NonSerializableFactory.class.getName(), null);
/* 277 */     ctx.bind("EntityLockMonitor", ref);
/*     */   }
/*     */ 
/*     */   private void unbind() throws NamingException
/*     */   {
/* 282 */     new InitialContext().unbind("EntityLockMonitor");
/* 283 */     NonSerializableFactory.unbind("EntityLockMonitor");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.monitor.EntityLockMonitor
 * JD-Core Version:    0.6.0
 */