/*     */ package org.jboss.metatype.plugins.types;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Type;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.LinkedHashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.metatype.api.annotations.CompositeKey;
/*     */ import org.jboss.metatype.api.annotations.Generic;
/*     */ import org.jboss.metatype.api.types.ArrayMetaType;
/*     */ import org.jboss.metatype.api.types.CollectionMetaType;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.EnumMetaType;
/*     */ import org.jboss.metatype.api.types.GenericMetaType;
/*     */ import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
/*     */ import org.jboss.metatype.api.types.ImmutableTableMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.metatype.api.types.TableMetaType;
/*     */ import org.jboss.metatype.spi.types.MetaTypeBuilder;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.EnumConstantInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ import org.jboss.reflect.spi.InterfaceInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class DefaultMetaTypeFactory extends MetaTypeFactory
/*     */ {
/*     */   public static final String MAP_KEY = "key";
/*     */   public static final String MAP_VALUE = "value";
/*  75 */   public static final String[] MAP_INDEX_NAMES = { "key" };
/*     */ 
/*  78 */   public static final String[] MAP_ITEM_NAMES = { "key", "value" };
/*     */ 
/*  85 */   private static Configuration configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*     */   {
/*     */     public Configuration run()
/*     */     {
/*  89 */       return new PropertyConfiguration();
/*     */     }
/*     */   });
/*     */ 
/*  95 */   private TypeInfo objectTypeInfo = configuration.getTypeInfo(Object.class);
/*     */ 
/*  98 */   private Map<Class, WeakReference<MetaTypeBuilder>> builders = new WeakHashMap();
/*     */ 
/*     */   public DefaultMetaTypeFactory()
/*     */   {
/* 106 */     setBuilder(Class.class, ClassMetaTypeBuilder.INSTANCE);
/*     */   }
/*     */ 
/*     */   public MetaType resolve(Type type)
/*     */   {
/* 112 */     TypeInfo typeInfo = configuration.getTypeInfo(type);
/* 113 */     return resolve(typeInfo);
/*     */   }
/*     */ 
/*     */   public MetaType resolve(TypeInfo typeInfo)
/*     */   {
/* 125 */     MetaType result = (MetaType)typeInfo.getAttachment(MetaType.class);
/* 126 */     if (result == null)
/*     */     {
/* 129 */       result = generate(typeInfo);
/*     */ 
/* 132 */       typeInfo.setAttachment(MetaType.class.getName(), result);
/*     */     }
/*     */ 
/* 136 */     return result;
/*     */   }
/*     */ 
/*     */   public void setBuilder(Class<?> clazz, MetaTypeBuilder builder)
/*     */   {
/* 141 */     synchronized (this.builders)
/*     */     {
/* 143 */       if (builder == null)
/* 144 */         this.builders.remove(clazz);
/* 145 */       this.builders.put(clazz, new WeakReference(builder));
/*     */     }
/*     */   }
/*     */ 
/*     */   public MetaType generate(TypeInfo typeInfo)
/*     */   {
/* 157 */     MetaType result = isBuilder(typeInfo);
/* 158 */     if (result != null) {
/* 159 */       return result;
/*     */     }
/* 161 */     result = isGeneric(typeInfo);
/* 162 */     if (result != null) {
/* 163 */       return result;
/*     */     }
/* 165 */     if (typeInfo.isEnum()) {
/* 166 */       return generateEnum((EnumInfo)typeInfo);
/*     */     }
/* 168 */     ClassInfo annotationType = isAnnotation(typeInfo);
/* 169 */     if (annotationType != null) {
/* 170 */       return generateAnnotation(annotationType);
/*     */     }
/* 172 */     if (typeInfo.isArray()) {
/* 173 */       return generateArray((ArrayInfo)typeInfo);
/*     */     }
/* 175 */     if (typeInfo.isCollection()) {
/* 176 */       return generateCollection((ClassInfo)typeInfo);
/*     */     }
/* 178 */     if (typeInfo.isMap()) {
/* 179 */       return generateMap((ClassInfo)typeInfo);
/*     */     }
/* 181 */     result = SimpleMetaType.isSimpleType(typeInfo.getName());
/* 182 */     if (result != null) {
/* 183 */       return result;
/*     */     }
/* 185 */     return generateBean((ClassInfo)typeInfo);
/*     */   }
/*     */ 
/*     */   public EnumMetaType generateEnum(EnumInfo typeInfo)
/*     */   {
/* 196 */     EnumConstantInfo[] constants = typeInfo.getEnumConstants();
/* 197 */     List validValues = new ArrayList(constants.length);
/* 198 */     for (EnumConstantInfo constant : constants)
/* 199 */       validValues.add(constant.getName());
/* 200 */     return new EnumMetaType(typeInfo.getName(), validValues);
/*     */   }
/*     */ 
/*     */   public ClassInfo isAnnotation(TypeInfo typeInfo)
/*     */   {
/* 211 */     if (typeInfo.isAnnotation()) {
/* 212 */       return (ClassInfo)typeInfo;
/*     */     }
/* 214 */     if ((typeInfo instanceof ClassInfo))
/*     */     {
/* 216 */       ClassInfo classInfo = (ClassInfo)typeInfo;
/* 217 */       InterfaceInfo[] interfaces = classInfo.getInterfaces();
/* 218 */       if (interfaces != null)
/*     */       {
/* 220 */         for (int i = 0; i < interfaces.length; i++)
/*     */         {
/* 222 */           if (interfaces[i].isAnnotation()) {
/* 223 */             return interfaces[i];
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 229 */     return null;
/*     */   }
/*     */ 
/*     */   public CompositeMetaType generateAnnotation(ClassInfo typeInfo)
/*     */   {
/* 240 */     return generateBean(typeInfo);
/*     */   }
/*     */ 
/*     */   public ArrayMetaType generateArray(ArrayInfo typeInfo)
/*     */   {
/* 251 */     int dimension = 1;
/* 252 */     TypeInfo componentType = typeInfo.getComponentType();
/* 253 */     while (componentType.isArray())
/*     */     {
/* 255 */       dimension++;
/* 256 */       componentType = ((ArrayInfo)componentType).getComponentType();
/*     */     }
/* 258 */     MetaType componentMetaType = resolve(componentType);
/* 259 */     return new ArrayMetaType(dimension, componentMetaType, componentType.isPrimitive());
/*     */   }
/*     */ 
/*     */   public CollectionMetaType generateCollection(ClassInfo typeInfo)
/*     */   {
/* 271 */     TypeInfo elementType = this.objectTypeInfo;
/*     */ 
/* 273 */     TypeInfo[] types = typeInfo.getActualTypeArguments();
/* 274 */     if (types != null) {
/* 275 */       elementType = types[0];
/*     */     }
/* 277 */     MetaType elementMetaType = resolve(elementType);
/* 278 */     return new CollectionMetaType(typeInfo.getName(), elementMetaType);
/*     */   }
/*     */ 
/*     */   public TableMetaType generateMap(ClassInfo typeInfo)
/*     */   {
/* 289 */     TypeInfo keyType = this.objectTypeInfo;
/* 290 */     TypeInfo valueType = this.objectTypeInfo;
/*     */ 
/* 292 */     TypeInfo[] types = typeInfo.getActualTypeArguments();
/* 293 */     if (types != null)
/*     */     {
/* 295 */       keyType = types[0];
/* 296 */       valueType = types[1];
/*     */     }
/* 298 */     return createMapType(keyType, valueType);
/*     */   }
/*     */ 
/*     */   public TableMetaType createMapType(TypeInfo keyType, TypeInfo valueType)
/*     */   {
/* 310 */     String name = Map.class.getName();
/* 311 */     MetaType[] itemTypes = { resolve(keyType), resolve(valueType) };
/* 312 */     CompositeMetaType entryType = createMapEntryType(itemTypes);
/* 313 */     return new ImmutableTableMetaType(name, name, entryType, MAP_INDEX_NAMES);
/*     */   }
/*     */ 
/*     */   public static CompositeMetaType createMapEntryType(MetaType[] itemTypes)
/*     */   {
/* 324 */     String entryName = Map.Entry.class.getName();
/* 325 */     return new ImmutableCompositeMetaType(entryName, entryName, MAP_ITEM_NAMES, MAP_ITEM_NAMES, itemTypes);
/*     */   }
/*     */ 
/*     */   public CompositeMetaType generateBean(ClassInfo typeInfo)
/*     */   {
/* 336 */     BeanInfo beanInfo = configuration.getBeanInfo(typeInfo);
/* 337 */     MutableCompositeMetaType result = new MutableCompositeMetaType(typeInfo.getName(), typeInfo.getName());
/* 338 */     typeInfo.setAttachment(MetaType.class.getName(), result);
/*     */ 
/* 340 */     Set keys = null;
/* 341 */     Set properties = beanInfo.getProperties();
/* 342 */     if ((properties != null) && (properties.size() > 0))
/*     */     {
/* 344 */       for (PropertyInfo property : properties)
/*     */       {
/* 346 */         String name = property.getName();
/* 347 */         if (!"class".equals(name))
/*     */         {
/* 349 */           TypeInfo itemTypeInfo = property.getType();
/* 350 */           MetaType metaType = resolve(itemTypeInfo);
/* 351 */           result.addItem(name, name, metaType);
/* 352 */           if (property.isAnnotationPresent(CompositeKey.class))
/*     */           {
/* 354 */             if (keys == null)
/* 355 */               keys = new LinkedHashSet();
/* 356 */             keys.add(name);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 361 */     if (keys != null)
/* 362 */       result.setKeys(keys);
/* 363 */     result.freeze();
/* 364 */     return result;
/*     */   }
/*     */ 
/*     */   public MetaType isBuilder(TypeInfo typeInfo)
/*     */   {
/* 375 */     MetaTypeBuilder builder = null;
/* 376 */     synchronized (this.builders)
/*     */     {
/* 378 */       WeakReference weak = (WeakReference)this.builders.get(typeInfo.getType());
/* 379 */       if (weak != null)
/* 380 */         builder = (MetaTypeBuilder)weak.get();
/*     */     }
/* 382 */     if (builder == null)
/* 383 */       return null;
/* 384 */     return builder.buildMetaType();
/*     */   }
/*     */ 
/*     */   public GenericMetaType isGeneric(TypeInfo typeInfo)
/*     */   {
/* 395 */     if (!(typeInfo instanceof ClassInfo)) {
/* 396 */       return null;
/*     */     }
/* 398 */     ClassInfo classInfo = (ClassInfo)typeInfo;
/* 399 */     Generic generic = (Generic)classInfo.getUnderlyingAnnotation(Generic.class);
/* 400 */     if (generic != null)
/* 401 */       return new GenericMetaType(typeInfo.getName(), typeInfo.getName());
/* 402 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.plugins.types.DefaultMetaTypeFactory
 * JD-Core Version:    0.6.0
 */