/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ 
/*     */ public class SimpleValueSupport<T extends Serializable> extends AbstractMetaValue
/*     */   implements SimpleValue<T>
/*     */ {
/*     */   private static final long serialVersionUID = 8473043036261557127L;
/*     */   private SimpleMetaType<T> metaType;
/*     */   private T value;
/*     */ 
/*     */   public static <T extends Serializable> SimpleValue<T> wrap(T object)
/*     */   {
/*  56 */     if (object == null)
/*  57 */       return null;
/*  58 */     String className = object.getClass().getName();
/*  59 */     SimpleMetaType metaType = SimpleMetaType.resolve(className);
/*  60 */     return new SimpleValueSupport(metaType, object);
/*     */   }
/*     */ 
/*     */   public SimpleValueSupport(SimpleMetaType<T> metaType, T value)
/*     */   {
/*  72 */     if (metaType == null)
/*  73 */       throw new IllegalArgumentException("Null simple meta type");
/*  74 */     this.metaType = metaType;
/*  75 */     setValue(value);
/*     */   }
/*     */ 
/*     */   public SimpleMetaType<T> getMetaType()
/*     */   {
/*  80 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public T getValue()
/*     */   {
/*  90 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(T value)
/*     */   {
/* 100 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 106 */     if (obj == this) {
/* 107 */       return true;
/*     */     }
/* 109 */     if ((obj == null) || (!(obj instanceof SimpleValue))) {
/* 110 */       return false;
/*     */     }
/* 112 */     SimpleValue other = (SimpleValue)obj;
/* 113 */     if (!this.metaType.equals(other.getMetaType())) {
/* 114 */       return false;
/*     */     }
/* 116 */     Object otherValue = other.getValue();
/* 117 */     if ((this.value == null) && (otherValue == null))
/* 118 */       return true;
/* 119 */     if ((this.value == null) && (otherValue != null))
/* 120 */       return false;
/* 121 */     return this.value.equals(otherValue);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 127 */     if (this.value == null)
/* 128 */       return 0;
/* 129 */     return this.value.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 135 */     return this.metaType + ":" + this.value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.SimpleValueSupport
 * JD-Core Version:    0.6.0
 */