/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import org.jboss.metatype.api.types.EnumMetaType;
/*     */ 
/*     */ public class EnumValueSupport extends AbstractMetaValue
/*     */   implements EnumValue
/*     */ {
/*     */   private static final long serialVersionUID = -6472212391813711803L;
/*     */   private EnumMetaType metaType;
/*     */   private String value;
/*     */ 
/*     */   public EnumValueSupport(EnumMetaType metaType, String value)
/*     */   {
/*  53 */     if (metaType == null)
/*  54 */       throw new IllegalArgumentException("Null enum meta type");
/*  55 */     this.metaType = metaType;
/*  56 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public EnumValueSupport(EnumMetaType metaType, Enum value)
/*     */   {
/*  66 */     this(metaType, value.name());
/*     */   }
/*     */ 
/*     */   public EnumMetaType getMetaType()
/*     */   {
/*  71 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/*  81 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/*  91 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  97 */     if (obj == this) {
/*  98 */       return true;
/*     */     }
/* 100 */     if ((obj == null) || (!(obj instanceof EnumValue))) {
/* 101 */       return false;
/*     */     }
/* 103 */     EnumValue other = (EnumValue)obj;
/* 104 */     if (!this.metaType.equals(other.getMetaType())) {
/* 105 */       return false;
/*     */     }
/* 107 */     Object otherValue = other.getValue();
/* 108 */     if ((this.value == null) && (otherValue == null))
/* 109 */       return true;
/* 110 */     if ((this.value == null) && (otherValue != null))
/* 111 */       return false;
/* 112 */     return this.value.equals(otherValue);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 118 */     if (this.value == null)
/* 119 */       return 0;
/* 120 */     return this.value.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 126 */     return this.metaType + ":" + this.value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.EnumValueSupport
 * JD-Core Version:    0.6.0
 */