/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.metatype.api.types.ArrayMetaType;
/*     */ 
/*     */ public class ArrayValueSupport<T extends Serializable> extends AbstractMetaValue
/*     */   implements ArrayValue<T>
/*     */ {
/*     */   private static final long serialVersionUID = 1131827130033538066L;
/*     */   private ArrayMetaType<T> metaType;
/*     */   private Object value;
/*     */ 
/*     */   public ArrayValueSupport(ArrayMetaType<T> metaType)
/*     */   {
/*  58 */     if (metaType == null)
/*  59 */       throw new IllegalArgumentException("Null array meta type");
/*  60 */     this.metaType = metaType;
/*     */   }
/*     */ 
/*     */   public ArrayValueSupport(ArrayMetaType<T> metaType, Object value)
/*     */   {
/*  72 */     this(metaType);
/*  73 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public ArrayMetaType<T> getMetaType()
/*     */   {
/*  78 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/*  88 */     return this.value;
/*     */   }
/*     */ 
/*     */   public int getLength()
/*     */   {
/*  97 */     return Array.getLength(this.value);
/*     */   }
/*     */ 
/*     */   public Object getValue(int index)
/*     */   {
/* 102 */     return Array.get(this.value, index);
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/* 107 */     return new ArrayValueIterator(this.value);
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/* 117 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 123 */     if (obj == this) {
/* 124 */       return true;
/*     */     }
/* 126 */     if ((obj == null) || (!(obj instanceof ArrayValue))) {
/* 127 */       return false;
/*     */     }
/* 129 */     ArrayValue other = (ArrayValue)obj;
/* 130 */     if (!this.metaType.equals(other.getMetaType())) {
/* 131 */       return false;
/*     */     }
/* 133 */     Object otherValue = other.getValue();
/* 134 */     if ((this.value == null) && (otherValue == null))
/* 135 */       return true;
/* 136 */     if ((this.value == null) && (otherValue != null)) {
/* 137 */       return false;
/*     */     }
/*     */ 
/* 140 */     boolean equals = false;
/* 141 */     if (((this.value instanceof Object[])) && ((otherValue instanceof Object[])))
/* 142 */       equals = Arrays.deepEquals((Object[])(Object[])this.value, (Object[])(Object[])otherValue);
/* 143 */     else if (((this.value instanceof byte[])) && ((otherValue instanceof byte[])))
/* 144 */       equals = Arrays.equals((byte[])(byte[])this.value, (byte[])(byte[])otherValue);
/* 145 */     else if (((this.value instanceof short[])) && ((otherValue instanceof short[])))
/* 146 */       equals = Arrays.equals((short[])(short[])this.value, (short[])(short[])otherValue);
/* 147 */     else if (((this.value instanceof int[])) && ((otherValue instanceof int[])))
/* 148 */       equals = Arrays.equals((int[])(int[])this.value, (int[])(int[])otherValue);
/* 149 */     else if (((this.value instanceof long[])) && ((otherValue instanceof long[])))
/* 150 */       equals = Arrays.equals((long[])(long[])this.value, (long[])(long[])otherValue);
/* 151 */     else if (((this.value instanceof char[])) && ((otherValue instanceof char[])))
/* 152 */       equals = Arrays.equals((char[])(char[])this.value, (char[])(char[])otherValue);
/* 153 */     else if (((this.value instanceof float[])) && ((otherValue instanceof float[])))
/* 154 */       equals = Arrays.equals((float[])(float[])this.value, (float[])(float[])otherValue);
/* 155 */     else if (((this.value instanceof double[])) && ((otherValue instanceof double[])))
/* 156 */       equals = Arrays.equals((double[])(double[])this.value, (double[])(double[])otherValue);
/* 157 */     else if (((this.value instanceof boolean[])) && ((otherValue instanceof boolean[])))
/* 158 */       equals = Arrays.equals((boolean[])(boolean[])this.value, (boolean[])(boolean[])otherValue);
/*     */     else
/* 160 */       equals = this.value.equals(otherValue);
/* 161 */     return equals;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 167 */     if (this.value == null)
/* 168 */       return 0;
/* 169 */     return this.value.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 175 */     return this.metaType + ":" + deepToString();
/*     */   }
/*     */ 
/*     */   public MetaValue clone()
/*     */   {
/* 181 */     ArrayValueSupport result = (ArrayValueSupport)super.clone();
/* 182 */     int length = getLength();
/* 183 */     if ((this.value != null) && (length > 0))
/*     */     {
/* 186 */       result.value = new Object[length];
/* 187 */       System.arraycopy(this.value, 0, result.value, 0, length);
/*     */     }
/* 189 */     return result;
/*     */   }
/*     */ 
/*     */   protected String deepToString()
/*     */   {
/*     */     String deepToString;
/*     */     String deepToString;
/* 199 */     if (this.value == null) {
/* 200 */       deepToString = "null";
/*     */     }
/*     */     else
/*     */     {
/*     */       String deepToString;
/* 201 */       if ((this.value instanceof byte[])) {
/* 202 */         deepToString = Arrays.toString((byte[])(byte[])this.value);
/*     */       }
/*     */       else
/*     */       {
/*     */         String deepToString;
/* 203 */         if ((this.value instanceof short[])) {
/* 204 */           deepToString = Arrays.toString((short[])(short[])this.value);
/*     */         }
/*     */         else
/*     */         {
/*     */           String deepToString;
/* 205 */           if ((this.value instanceof int[])) {
/* 206 */             deepToString = Arrays.toString((int[])(int[])this.value);
/*     */           }
/*     */           else
/*     */           {
/*     */             String deepToString;
/* 207 */             if ((this.value instanceof long[])) {
/* 208 */               deepToString = Arrays.toString((long[])(long[])this.value);
/*     */             }
/*     */             else
/*     */             {
/*     */               String deepToString;
/* 209 */               if ((this.value instanceof char[])) {
/* 210 */                 deepToString = Arrays.toString((char[])(char[])this.value);
/*     */               }
/*     */               else
/*     */               {
/*     */                 String deepToString;
/* 211 */                 if ((this.value instanceof float[])) {
/* 212 */                   deepToString = Arrays.toString((float[])(float[])this.value);
/*     */                 }
/*     */                 else
/*     */                 {
/*     */                   String deepToString;
/* 213 */                   if ((this.value instanceof double[])) {
/* 214 */                     deepToString = Arrays.toString((double[])(double[])this.value);
/*     */                   }
/*     */                   else
/*     */                   {
/*     */                     String deepToString;
/* 215 */                     if ((this.value instanceof boolean[])) {
/* 216 */                       deepToString = Arrays.toString((boolean[])(boolean[])this.value);
/*     */                     }
/*     */                     else
/*     */                     {
/*     */                       String deepToString;
/* 217 */                       if ((this.value instanceof Object[]))
/* 218 */                         deepToString = Arrays.deepToString((Object[])(Object[])this.value);
/*     */                       else
/* 220 */                         deepToString = this.value.toString(); 
/*     */                     }
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 221 */     return deepToString;
/*     */   }
/*     */   private static class ArrayValueIterator<T> implements Iterator<T> {
/*     */     private int index;
/*     */     private int length;
/*     */     private Object array;
/*     */ 
/*     */     ArrayValueIterator(Object array) {
/* 232 */       this.array = array;
/* 233 */       this.index = 0;
/* 234 */       this.length = Array.getLength(array);
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 239 */       return this.index < this.length;
/*     */     }
/*     */ 
/*     */     public T next()
/*     */     {
/* 245 */       return Array.get(this.array, this.index++);
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 250 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.ArrayValueSupport
 * JD-Core Version:    0.6.0
 */