/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.util.Date;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ 
/*     */ public class SimpleMetaType<T extends Serializable> extends AbstractMetaType<T>
/*     */ {
/*     */   private static final long serialVersionUID = 6786422588217893696L;
/*     */   private transient int cachedHashCode;
/*     */   private transient String cachedToString;
/*  94 */   public static final SimpleMetaType<BigDecimal> BIGDECIMAL = new SimpleMetaType(BigDecimal.class.getName());
/*  95 */   public static final SimpleMetaType<BigInteger> BIGINTEGER = new SimpleMetaType(BigInteger.class.getName());
/*  96 */   public static final SimpleMetaType<Boolean> BOOLEAN = new SimpleMetaType(Boolean.class.getName());
/*  97 */   public static final SimpleMetaType<Byte> BYTE = new SimpleMetaType(Byte.class.getName());
/*  98 */   public static final SimpleMetaType<Character> CHARACTER = new SimpleMetaType(Character.class.getName());
/*  99 */   public static final SimpleMetaType<Date> DATE = new SimpleMetaType(Date.class.getName());
/* 100 */   public static final SimpleMetaType<Double> DOUBLE = new SimpleMetaType(Double.class.getName());
/* 101 */   public static final SimpleMetaType<Float> FLOAT = new SimpleMetaType(Float.class.getName());
/* 102 */   public static final SimpleMetaType<Integer> INTEGER = new SimpleMetaType(Integer.class.getName());
/* 103 */   public static final SimpleMetaType<Long> LONG = new SimpleMetaType(Long.class.getName());
/* 104 */   public static final SimpleMetaType<Short> SHORT = new SimpleMetaType(Short.class.getName());
/* 105 */   public static final SimpleMetaType<String> STRING = new SimpleMetaType(String.class.getName());
/* 106 */   public static final SimpleMetaType<Name> NAMEDOBJECT = new SimpleMetaType(Name.class.getName());
/* 107 */   public static final SimpleMetaType VOID = new SimpleMetaType(Void.class.getName());
/*     */ 
/*     */   public static SimpleMetaType resolve(String className)
/*     */   {
/* 119 */     SimpleMetaType result = isSimpleType(className);
/* 120 */     if (result != null)
/* 121 */       return result;
/* 122 */     throw new IllegalArgumentException("Class is not a simple type: " + className);
/*     */   }
/*     */ 
/*     */   public static SimpleMetaType isSimpleType(String className)
/*     */   {
/* 135 */     if (className == null)
/* 136 */       throw new IllegalArgumentException("Null class name");
/* 137 */     if (className.equals(STRING.getClassName()))
/* 138 */       return STRING;
/* 139 */     if ((className.equals(INTEGER.getClassName())) || (className.equals(Integer.TYPE.getName())))
/* 140 */       return INTEGER;
/* 141 */     if ((className.equals(BOOLEAN.getClassName())) || (className.equals(Boolean.TYPE.getName())))
/* 142 */       return BOOLEAN;
/* 143 */     if ((className.equals(LONG.getClassName())) || (className.equals(Long.TYPE.getName())))
/* 144 */       return LONG;
/* 145 */     if ((className.equals(BYTE.getClassName())) || (className.equals(Byte.TYPE.getName())))
/* 146 */       return BYTE;
/* 147 */     if ((className.equals(CHARACTER.getClassName())) || (className.equals(Character.TYPE.getName())))
/* 148 */       return CHARACTER;
/* 149 */     if ((className.equals(DOUBLE.getClassName())) || (className.equals(Double.TYPE.getName())))
/* 150 */       return DOUBLE;
/* 151 */     if ((className.equals(FLOAT.getClassName())) || (className.equals(Float.TYPE.getName())))
/* 152 */       return FLOAT;
/* 153 */     if ((className.equals(SHORT.getClassName())) || (className.equals(Short.TYPE.getName())))
/* 154 */       return SHORT;
/* 155 */     if (className.equals(BIGDECIMAL.getClassName()))
/* 156 */       return BIGDECIMAL;
/* 157 */     if (className.equals(BIGINTEGER.getClassName()))
/* 158 */       return BIGINTEGER;
/* 159 */     if ((className.equals(VOID.getClassName())) || (className.equals(Void.TYPE.getName())))
/* 160 */       return VOID;
/* 161 */     if (className.equals(DATE.getClassName()))
/* 162 */       return DATE;
/* 163 */     if (className.equals(NAMEDOBJECT.getClassName()))
/* 164 */       return NAMEDOBJECT;
/* 165 */     return null;
/*     */   }
/*     */ 
/*     */   private SimpleMetaType(String className)
/*     */   {
/* 177 */     super(className);
/* 178 */     this.cachedHashCode = getClassName().hashCode();
/* 179 */     StringBuilder buffer = new StringBuilder(SimpleMetaType.class.getSimpleName());
/* 180 */     buffer.append(":");
/* 181 */     buffer.append(getClassName());
/* 182 */     this.cachedToString = buffer.toString();
/*     */   }
/*     */ 
/*     */   public boolean isSimple()
/*     */   {
/* 188 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 194 */     if ((obj == null) || (!(obj instanceof SimpleValue))) {
/* 195 */       return false;
/*     */     }
/* 197 */     SimpleValue value = (SimpleValue)obj;
/* 198 */     return equals(value.getMetaType());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 204 */     if (this == obj)
/* 205 */       return true;
/* 206 */     if ((obj == null) || (!(obj instanceof SimpleMetaType)))
/* 207 */       return false;
/* 208 */     SimpleMetaType other = (SimpleMetaType)obj;
/* 209 */     return getClassName().equals(other.getClassName());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 215 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 221 */     return this.cachedToString;
/*     */   }
/*     */ 
/*     */   private Object readResolve()
/*     */     throws ObjectStreamException
/*     */   {
/* 232 */     return resolve(getClassName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.SimpleMetaType
 * JD-Core Version:    0.6.0
 */