/*     */ package org.jboss.metamodel.descriptor;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ResourceRef extends Ref
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(ResourceRef.class);
/*     */   private String resRefName;
/*     */   private String resType;
/*     */   private String resAuth;
/*     */   private String resSharingScope;
/*     */   private String mappedName;
/*     */   private String jndiName;
/*     */   private String resourceName;
/*     */   private String resUrl;
/*     */ 
/*     */   public String getResUrl()
/*     */   {
/*  55 */     return this.resUrl;
/*     */   }
/*     */ 
/*     */   public void setResUrl(String resUrl)
/*     */   {
/*  60 */     this.resUrl = resUrl;
/*     */   }
/*     */ 
/*     */   public String getResourceName()
/*     */   {
/*  65 */     return this.resourceName;
/*     */   }
/*     */ 
/*     */   public void setResourceName(String resourceName)
/*     */   {
/*  70 */     this.resourceName = resourceName;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  75 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  80 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getMappedName()
/*     */   {
/*  85 */     return this.mappedName;
/*     */   }
/*     */ 
/*     */   public void setMappedName(String mappedName)
/*     */   {
/*  90 */     this.mappedName = mappedName;
/*     */   }
/*     */ 
/*     */   public String getResRefName()
/*     */   {
/*  95 */     return this.resRefName;
/*     */   }
/*     */ 
/*     */   public void setResRefName(String resRefName)
/*     */   {
/* 100 */     this.resRefName = resRefName;
/*     */   }
/*     */ 
/*     */   public String getResType()
/*     */   {
/* 105 */     return this.resType;
/*     */   }
/*     */ 
/*     */   public void setResType(String resType)
/*     */   {
/* 110 */     this.resType = resType;
/*     */   }
/*     */ 
/*     */   public String getResAuth()
/*     */   {
/* 115 */     return this.resAuth;
/*     */   }
/*     */ 
/*     */   public void setResAuth(String resAuth)
/*     */   {
/* 120 */     this.resAuth = resAuth;
/*     */   }
/*     */ 
/*     */   public String getAuthorizationType()
/*     */   {
/* 125 */     return this.resAuth;
/*     */   }
/*     */ 
/*     */   public String getResSharingScope()
/*     */   {
/* 134 */     return this.resSharingScope;
/*     */   }
/*     */ 
/*     */   public void setResSharingScope(String resSharingScope)
/*     */   {
/* 139 */     this.resSharingScope = resSharingScope;
/*     */   }
/*     */ 
/*     */   public boolean isShareable()
/*     */   {
/* 145 */     return (this.resSharingScope == null) || (this.resSharingScope.equals("Shareable"));
/*     */   }
/*     */ 
/*     */   public void merge(ResourceRef ref)
/*     */   {
/* 152 */     if (ref.getJndiName() != null)
/*     */     {
/* 154 */       setJndiName(ref.getJndiName());
/*     */ 
/* 156 */       String mappedName = ref.getJndiName();
/* 157 */       if (mappedName.startsWith("java:"))
/* 158 */         setMappedName(ref.getJndiName());
/*     */       else {
/* 160 */         setMappedName("java:" + ref.getJndiName());
/*     */       }
/*     */     }
/* 163 */     if (ref.getResourceName() != null)
/*     */     {
/* 165 */       setResourceName(ref.getResourceName());
/*     */ 
/* 167 */       String mappedName = ref.getResourceName();
/* 168 */       if (mappedName.startsWith("java:"))
/* 169 */         setMappedName(ref.getResourceName());
/*     */       else
/* 171 */         setMappedName("java:" + ref.getResourceName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 177 */     StringBuffer sb = new StringBuffer(100);
/* 178 */     sb.append("[" + getClass().getName() + ": ");
/* 179 */     sb.append("resRefName=").append(this.resRefName);
/* 180 */     sb.append(", jndiName=").append(this.jndiName);
/* 181 */     sb.append(", resourceName=").append(this.resourceName);
/* 182 */     sb.append(", resType=").append(this.resType);
/* 183 */     sb.append(", mappedName=").append(this.mappedName);
/* 184 */     sb.append(", injectionTarget=").append(this.injectionTarget);
/* 185 */     sb.append("]");
/* 186 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metamodel.descriptor.ResourceRef
 * JD-Core Version:    0.6.0
 */