/*     */ package org.jboss.metamodel.descriptor;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ResourceEnvRef extends Ref
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(ResourceEnvRef.class);
/*     */   private String resRefName;
/*     */   private String resType;
/*     */   private String resAuth;
/*     */   private String resSharingScope;
/*     */   private String mappedName;
/*     */   private String jndiName;
/*     */   private String resourceName;
/*     */ 
/*     */   public String getResourceName()
/*     */   {
/*  53 */     return this.resourceName;
/*     */   }
/*     */ 
/*     */   public void setResourceName(String resourceName)
/*     */   {
/*  58 */     this.resourceName = resourceName;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  63 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  68 */     this.jndiName = jndiName;
/*  69 */     this.mappedName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getMappedName()
/*     */   {
/*  74 */     return this.mappedName;
/*     */   }
/*     */ 
/*     */   public void setMappedName(String mappedName)
/*     */   {
/*  79 */     this.mappedName = mappedName;
/*     */   }
/*     */ 
/*     */   public String getResRefName()
/*     */   {
/*  84 */     return this.resRefName;
/*     */   }
/*     */ 
/*     */   public void setResRefName(String resRefName)
/*     */   {
/*  89 */     this.resRefName = resRefName;
/*     */   }
/*     */ 
/*     */   public String getResType()
/*     */   {
/*  94 */     return this.resType;
/*     */   }
/*     */ 
/*     */   public void setResType(String resType)
/*     */   {
/*  99 */     this.resType = resType;
/*     */   }
/*     */ 
/*     */   public String getResAuth()
/*     */   {
/* 104 */     return this.resAuth;
/*     */   }
/*     */ 
/*     */   public void setResAuth(String resAuth)
/*     */   {
/* 109 */     this.resAuth = resAuth;
/*     */   }
/*     */ 
/*     */   public String getAuthorizationType()
/*     */   {
/* 114 */     return this.resAuth;
/*     */   }
/*     */ 
/*     */   public String getResSharingScope()
/*     */   {
/* 119 */     return this.resSharingScope;
/*     */   }
/*     */ 
/*     */   public void setResSharingScope(String resSharingScope)
/*     */   {
/* 124 */     this.resSharingScope = resSharingScope;
/*     */   }
/*     */ 
/*     */   public boolean isShareable()
/*     */   {
/* 130 */     return (this.resSharingScope == null) || (this.resSharingScope.equals("Shareable"));
/*     */   }
/*     */ 
/*     */   public void merge(ResourceEnvRef ref)
/*     */   {
/* 137 */     if (ref.getJndiName() != null)
/*     */     {
/* 139 */       setJndiName(ref.getJndiName());
/*     */ 
/* 141 */       setMappedName(ref.getJndiName());
/*     */     }
/*     */ 
/* 144 */     if (ref.getResourceName() != null)
/*     */     {
/* 146 */       setResourceName(ref.getResourceName());
/*     */ 
/* 148 */       String mappedName = ref.getResourceName();
/* 149 */       if (mappedName.startsWith("java:"))
/* 150 */         setMappedName(ref.getResourceName());
/*     */       else
/* 152 */         setMappedName("java:" + ref.getResourceName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 158 */     StringBuffer sb = new StringBuffer(100);
/* 159 */     sb.append("[ResourceEnvRef:");
/* 160 */     sb.append("resRefName=").append(this.resRefName);
/* 161 */     sb.append(",resType=").append(this.resType);
/* 162 */     sb.append(",jndiName=").append(this.jndiName);
/* 163 */     sb.append(",mappedName=").append(this.mappedName);
/* 164 */     sb.append("]");
/* 165 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metamodel.descriptor.ResourceEnvRef
 * JD-Core Version:    0.6.0
 */