/*     */ package org.jboss.metadata.web.spec;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.TreeSet;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ 
/*     */ public class WebResourceCollectionMetaData extends NamedMetaDataWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public static final Set<String> ALL_HTTP_METHODS;
/*     */   public static final String[] ALL_HTTP_METHOD_NAMES;
/*  63 */   private List<String> urlPatterns = new ArrayList();
/*  64 */   private List<String> httpMethods = new ArrayList();
/*     */ 
/*     */   public static String[] getMissingHttpMethods(Collection<String> httpMethods)
/*     */   {
/*  74 */     String[] methods = new String[0];
/*  75 */     if ((httpMethods.size() > 0) && (!httpMethods.containsAll(ALL_HTTP_METHODS)))
/*     */     {
/*  77 */       HashSet missingMethods = new HashSet(ALL_HTTP_METHODS);
/*  78 */       missingMethods.removeAll(httpMethods);
/*  79 */       methods = new String[missingMethods.size()];
/*  80 */       missingMethods.toArray(methods);
/*     */     }
/*  82 */     return methods;
/*     */   }
/*     */ 
/*     */   public String getWebResourceName()
/*     */   {
/*  87 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setWebResourceName(String webResourceName) {
/*  91 */     super.setName(webResourceName);
/*     */   }
/*     */ 
/*     */   public List<String> getUrlPatterns()
/*     */   {
/*  96 */     return this.urlPatterns;
/*     */   }
/*     */   @XmlElement(name="url-pattern")
/*     */   public void setUrlPatterns(List<String> urlPatterns) {
/* 101 */     this.urlPatterns = urlPatterns;
/*     */   }
/*     */ 
/*     */   public List<String> getHttpMethods()
/*     */   {
/* 106 */     return this.httpMethods;
/*     */   }
/*     */   @XmlElement(name="http-method")
/*     */   public void setHttpMethods(List<String> httpMethods) {
/* 111 */     this.httpMethods = httpMethods;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  50 */     TreeSet tmp = new TreeSet();
/*  51 */     tmp.add("GET");
/*  52 */     tmp.add("POST");
/*  53 */     tmp.add("PUT");
/*  54 */     tmp.add("DELETE");
/*  55 */     tmp.add("HEAD");
/*  56 */     tmp.add("OPTIONS");
/*  57 */     tmp.add("TRACE");
/*  58 */     ALL_HTTP_METHODS = Collections.unmodifiableSortedSet(tmp);
/*  59 */     ALL_HTTP_METHOD_NAMES = new String[ALL_HTTP_METHODS.size()];
/*  60 */     ALL_HTTP_METHODS.toArray(ALL_HTTP_METHOD_NAMES);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.web.spec.WebResourceCollectionMetaData
 * JD-Core Version:    0.6.0
 */