/*     */ package org.jboss.metadata.spi.stack;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.security.BasicPermission;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class MetaDataStackPermission extends BasicPermission
/*     */ {
/*     */   private static final long serialVersionUID = 5661980843569388590L;
/*  52 */   static MetaDataStackPermission MODIFY = new MetaDataStackPermission("modify");
/*     */ 
/*  55 */   static MetaDataStackPermission PEEK = new MetaDataStackPermission("peek");
/*     */   private transient boolean allNames;
/*     */ 
/*     */   public MetaDataStackPermission(String name)
/*     */   {
/*  69 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public MetaDataStackPermission(String name, String actions)
/*     */   {
/*  82 */     super(name, actions);
/*  83 */     init(name, actions);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  91 */     StringBuffer buffer = new StringBuffer(100);
/*  92 */     buffer.append(getClass().getName()).append(":");
/*  93 */     buffer.append(" name=").append(getName());
/*  94 */     buffer.append(" actions=").append(getActions());
/*  95 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 111 */     if (!(p instanceof MetaDataStackPermission)) {
/* 112 */       return false;
/*     */     }
/* 114 */     return this.allNames == true;
/*     */   }
/*     */ 
/*     */   public PermissionCollection newPermissionCollection()
/*     */   {
/* 124 */     return new MetaDataStackPermissionCollection();
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
/*     */   {
/* 129 */     ois.defaultReadObject();
/* 130 */     init(getName(), getActions());
/*     */   }
/*     */ 
/*     */   private void init(String name, String actions)
/*     */   {
/* 145 */     if (name == null) {
/* 146 */       throw new NullPointerException("name cannot be null");
/*     */     }
/* 148 */     if ((actions != null) && (actions.length() > 0)) {
/* 149 */       throw new IllegalArgumentException("actions must be null or empty");
/*     */     }
/* 151 */     if ((!name.equals("*")) && (!name.equals("modify")) && (!name.equals("peek")))
/*     */     {
/* 154 */       throw new IllegalArgumentException("Unknown name: " + name);
/* 155 */     }this.allNames = name.equals("*");
/*     */   }
/*     */ 
/*     */   class MetaDataStackPermissionCollection extends PermissionCollection
/*     */   {
/*     */     private static final long serialVersionUID = 3256442516797665329L;
/* 167 */     private HashSet<Permission> permissions = new HashSet();
/*     */     private boolean hasAll;
/*     */ 
/*     */     MetaDataStackPermissionCollection()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void add(Permission p)
/*     */     {
/* 174 */       if (isReadOnly())
/* 175 */         throw new SecurityException("Collection is read-only");
/* 176 */       if ((p instanceof MetaDataStackPermission))
/* 177 */         this.permissions.add(p);
/* 178 */       if (p.getName().equals("*"))
/* 179 */         this.hasAll = true;
/*     */     }
/*     */ 
/*     */     public boolean implies(Permission p)
/*     */     {
/* 184 */       boolean implies = false;
/* 185 */       if ((p instanceof MetaDataStackPermission))
/*     */       {
/* 187 */         implies = this.hasAll;
/* 188 */         if (!implies)
/* 189 */           implies = this.permissions.contains(p);
/*     */       }
/* 191 */       return implies;
/*     */     }
/*     */ 
/*     */     public Enumeration<Permission> elements()
/*     */     {
/* 196 */       Iterator iter = this.permissions.iterator();
/* 197 */       return new Enumeration(iter)
/*     */       {
/*     */         public boolean hasMoreElements()
/*     */         {
/* 201 */           return this.val$iter.hasNext();
/*     */         }
/*     */ 
/*     */         public Permission nextElement()
/*     */         {
/* 206 */           return (Permission)this.val$iter.next();
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.stack.MetaDataStackPermission
 * JD-Core Version:    0.6.0
 */