/*     */ package org.jboss.metadata.spi.scope;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ 
/*     */ public class ScopeLevel
/*     */   implements Serializable, Comparable<ScopeLevel>
/*     */ {
/*     */   private static final long serialVersionUID = 9090783215048463821L;
/*  39 */   private static final ConcurrentHashMap<String, Integer> levelsByName = new ConcurrentHashMap();
/*     */   private final int level;
/*     */   private final String name;
/*     */ 
/*     */   public static int getScopeLevel(String name)
/*     */   {
/*  55 */     Integer result = (Integer)levelsByName.get(name);
/*  56 */     if (result != null) {
/*  57 */       return result.intValue();
/*     */     }
/*  59 */     return 0;
/*     */   }
/*     */ 
/*     */   public ScopeLevel(int level, String name)
/*     */   {
/*  70 */     if (level <= 0)
/*  71 */       throw new IllegalArgumentException("Invalid level");
/*  72 */     if (name == null) {
/*  73 */       throw new IllegalArgumentException("Null name");
/*     */     }
/*  75 */     this.level = level;
/*  76 */     this.name = name;
/*  77 */     levelsByName.put(name, Integer.valueOf(level));
/*     */   }
/*     */ 
/*     */   public int getLevel()
/*     */   {
/*  82 */     return this.level;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  87 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  92 */     return this.name;
/*     */   }
/*     */ 
/*     */   public int compareTo(ScopeLevel o)
/*     */   {
/*  97 */     return this.level - o.level;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 102 */     if (object == this)
/* 103 */       return true;
/* 104 */     if ((object == null) || (!(object instanceof ScopeLevel))) {
/* 105 */       return false;
/*     */     }
/* 107 */     ScopeLevel other = (ScopeLevel)object;
/* 108 */     return this.level == other.level;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 113 */     return this.level;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.scope.ScopeLevel
 * JD-Core Version:    0.6.0
 */