/*     */ package org.jboss.metadata.spi.retrieval.basic;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.loader.MetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ 
/*     */ public class BasicAnnotationsItem extends BasicItem<Annotation[]>
/*     */   implements AnnotationsItem
/*     */ {
/*     */   private AnnotationItem[] annotationItems;
/*     */   private Annotation[] annotations;
/*     */ 
/*     */   public BasicAnnotationsItem(MetaDataLoader loader, AnnotationItem[] annotationItems)
/*     */   {
/*  53 */     super(loader);
/*     */ 
/*  55 */     if (annotationItems == null) {
/*  56 */       throw new IllegalArgumentException("Null annotation items");
/*     */     }
/*  58 */     this.annotationItems = annotationItems;
/*     */ 
/*  60 */     if (annotationItems.length == 0)
/*  61 */       this.annotations = MetaData.NO_ANNOTATIONS;
/*     */   }
/*     */ 
/*     */   public Annotation[] getValue()
/*     */   {
/*  66 */     if (this.annotations == null)
/*     */     {
/*  68 */       Annotation[] temp = new Annotation[this.annotationItems.length];
/*  69 */       for (int i = 0; i < temp.length; i++)
/*  70 */         temp[i] = this.annotationItems[i].getAnnotation();
/*  71 */       this.annotations = temp;
/*     */     }
/*  73 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public AnnotationItem[] getAnnotations()
/*     */   {
/*  78 */     return this.annotationItems;
/*     */   }
/*     */ 
/*     */   public boolean isCachable()
/*     */   {
/*  83 */     if (!super.isCachable()) {
/*  84 */       return false;
/*     */     }
/*  86 */     for (AnnotationItem item : this.annotationItems)
/*     */     {
/*  88 */       if (!item.isCachable()) {
/*  89 */         return false;
/*     */       }
/*     */     }
/*  92 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/*  97 */     if (!super.isValid()) {
/*  98 */       return false;
/*     */     }
/* 100 */     for (AnnotationItem item : this.annotationItems)
/*     */     {
/* 102 */       if (!item.isValid()) {
/* 103 */         return false;
/*     */       }
/*     */     }
/* 106 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem
 * JD-Core Version:    0.6.0
 */