/*     */ package org.jboss.metadata.serviceref;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NamingException;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.jboss.CallPropertyMetaData;
/*     */ import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
/*     */ import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ParamValueMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PortComponentRef;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ 
/*     */ public class ServiceReferenceHandler
/*     */ {
/*  69 */   private final Logger log = Logger.getLogger(ServiceReferenceHandler.class);
/*     */   private ServiceRefHandler delegate;
/*     */ 
/*     */   public ServiceReferenceHandler()
/*     */   {
/*  75 */     if (this.delegate == null)
/*     */     {
/*  77 */       SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/*  78 */       this.delegate = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class)).getServiceRefHandler();
/*     */     }
/*     */ 
/*  81 */     if (this.delegate == null)
/*  82 */       this.log.warn("ServiceRefHandler not available");
/*     */   }
/*     */ 
/*     */   public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceReferenceMetaData sref) throws NamingException
/*     */   {
/*  87 */     if (this.delegate != null)
/*     */     {
/*  89 */       if (!sref.isProcessed())
/*     */       {
/*  91 */         ServiceRefMetaData spiRef = getUnifiedServiceRefMetaData(vfsRoot, sref);
/*  92 */         this.delegate.bindServiceRef(encCtx, encName, vfsRoot, loader, spiRef);
/*  93 */         sref.setProcessed(true);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private UnifiedServiceRefMetaData getUnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, ServiceReferenceMetaData sref)
/*     */   {
/* 100 */     UnifiedServiceRefMetaData result = new UnifiedServiceRefMetaData(vfsRoot);
/* 101 */     result.setServiceRefName(sref.getServiceRefName());
/* 102 */     result.setServiceInterface(sref.getServiceInterface());
/* 103 */     result.setServiceRefType(sref.getServiceRefType());
/* 104 */     result.setWsdlFile(sref.getWsdlFile());
/* 105 */     result.setMappingFile(sref.getJaxrpcMappingFile());
/* 106 */     result.setServiceQName(sref.getServiceQname());
/* 107 */     result.setAnnotatedElement(sref.getAnnotatedElement());
/* 108 */     result.setProcessed(sref.isProcessed());
/*     */ 
/* 110 */     List pcRefs = sref.getPortComponentRef();
/* 111 */     if (pcRefs != null)
/*     */     {
/* 113 */       for (PortComponentRef pcRef : pcRefs)
/*     */       {
/* 115 */         UnifiedPortComponentRefMetaData upcRef = getUnifiedPortComponentRefMetaData(result, pcRef);
/* 116 */         if ((upcRef.getServiceEndpointInterface() != null) || (upcRef.getPortQName() != null))
/* 117 */           result.addPortComponentRef(upcRef);
/*     */         else {
/* 119 */           this.log.warn("Ignore <port-component-ref> without <service-endpoint-interface> and <port-qname>: " + upcRef);
/*     */         }
/*     */       }
/*     */     }
/* 123 */     ServiceReferenceHandlersMetaData srHandlers = sref.getHandlers();
/* 124 */     if (srHandlers != null)
/*     */     {
/* 126 */       Iterator it = srHandlers.iterator();
/* 127 */       while (it.hasNext())
/*     */       {
/* 129 */         ServiceReferenceHandlerMetaData srHandlerMetaData = (ServiceReferenceHandlerMetaData)it.next();
/* 130 */         UnifiedHandlerMetaData uHandlerMetaData = getUnifiedHandlerMetaData(srHandlerMetaData);
/* 131 */         result.addHandler(uHandlerMetaData);
/*     */       }
/*     */     }
/*     */ 
/* 135 */     ServiceReferenceHandlerChainsMetaData srHandlerChains = sref.getHandlerChains();
/* 136 */     if (srHandlerChains != null)
/*     */     {
/* 138 */       UnifiedHandlerChainsMetaData uHandlerChains = new UnifiedHandlerChainsMetaData();
/* 139 */       List srHandlerChainList = srHandlerChains.getHandlers();
/* 140 */       for (ServiceReferenceHandlerChainMetaData srHandlerChain : srHandlerChainList)
/*     */       {
/* 142 */         UnifiedHandlerChainMetaData uHandlerChain = new UnifiedHandlerChainMetaData();
/* 143 */         uHandlerChain.setServiceNamePattern(srHandlerChain.getServiceNamePattern());
/* 144 */         uHandlerChain.setPortNamePattern(srHandlerChain.getPortNamePattern());
/* 145 */         uHandlerChain.setProtocolBindings(srHandlerChain.getProtocolBindings());
/* 146 */         List srHandlerChainHandlers = srHandlerChain.getHandler();
/* 147 */         Iterator it = srHandlerChainHandlers.iterator();
/* 148 */         while (it.hasNext())
/*     */         {
/* 150 */           ServiceReferenceHandlerMetaData srHandlerMetaData = (ServiceReferenceHandlerMetaData)it.next();
/* 151 */           UnifiedHandlerMetaData uHandlerMetaData = getUnifiedHandlerMetaData(srHandlerMetaData);
/* 152 */           uHandlerChain.addHandler(uHandlerMetaData);
/*     */         }
/* 154 */         uHandlerChains.addHandlerChain(uHandlerChain);
/*     */       }
/* 156 */       result.setHandlerChains(uHandlerChains);
/*     */     }
/*     */ 
/* 159 */     if ((sref instanceof JBossServiceReferenceMetaData))
/*     */     {
/* 161 */       JBossServiceReferenceMetaData jbRef = (JBossServiceReferenceMetaData)sref;
/* 162 */       result.setServiceImplClass(jbRef.getServiceClass());
/* 163 */       result.setConfigName(jbRef.getConfigName());
/* 164 */       result.setConfigFile(jbRef.getConfigFile());
/* 165 */       result.setWsdlOverride(jbRef.getWsdlOverride());
/* 166 */       result.setHandlerChain(jbRef.getHandlerChain());
/*     */     }
/* 168 */     return result;
/*     */   }
/*     */ 
/*     */   private UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd)
/*     */   {
/* 173 */     UnifiedHandlerMetaData uhmd = new UnifiedHandlerMetaData();
/* 174 */     uhmd.setHandlerName(srhmd.getHandlerName());
/* 175 */     uhmd.setHandlerClass(srhmd.getHandlerClass());
/* 176 */     List initParams = srhmd.getInitParam();
/* 177 */     if (initParams != null)
/*     */     {
/* 179 */       for (ParamValueMetaData initParam : initParams)
/*     */       {
/* 181 */         UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
/* 182 */         param.setParamName(initParam.getParamName());
/* 183 */         param.setParamValue(initParam.getParamValue());
/* 184 */         uhmd.addInitParam(param);
/*     */       }
/*     */     }
/* 187 */     List soapHeaders = srhmd.getSoapHeader();
/* 188 */     if (soapHeaders != null)
/*     */     {
/* 190 */       for (QName soapHeader : soapHeaders)
/*     */       {
/* 192 */         uhmd.addSoapHeader(soapHeader);
/*     */       }
/*     */     }
/* 195 */     List soapRoles = srhmd.getSoapRole();
/* 196 */     if (soapRoles != null)
/*     */     {
/* 198 */       for (String soapRole : soapRoles)
/*     */       {
/* 200 */         uhmd.addSoapRole(soapRole);
/*     */       }
/*     */     }
/* 203 */     List portNames = srhmd.getPortName();
/* 204 */     if (portNames != null)
/*     */     {
/* 206 */       for (String portName : portNames)
/*     */       {
/* 208 */         uhmd.addPortName(portName);
/*     */       }
/*     */     }
/* 211 */     return uhmd;
/*     */   }
/*     */ 
/*     */   private UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData usref, PortComponentRef pcref)
/*     */   {
/* 216 */     UnifiedPortComponentRefMetaData result = new UnifiedPortComponentRefMetaData(usref);
/* 217 */     result.setServiceEndpointInterface(pcref.getServiceEndpointInterface());
/* 218 */     result.setEnableMTOM(Boolean.valueOf(pcref.isEnableMtom()));
/* 219 */     result.setPortComponentLink(pcref.getPortComponentLink());
/* 220 */     if ((pcref instanceof JBossPortComponentRef))
/*     */     {
/* 222 */       JBossPortComponentRef jbpcref = (JBossPortComponentRef)pcref;
/* 223 */       result.setPortQName(jbpcref.getPortQname());
/* 224 */       result.setConfigName(jbpcref.getConfigName());
/* 225 */       result.setConfigFile(jbpcref.getConfigFile());
/* 226 */       List stubProps = jbpcref.getStubProperties();
/* 227 */       if (stubProps != null)
/*     */       {
/* 229 */         for (StubPropertyMetaData stubProp : stubProps)
/*     */         {
/* 231 */           UnifiedStubPropertyMetaData prop = new UnifiedStubPropertyMetaData();
/* 232 */           prop.setPropName(stubProp.getPropName());
/* 233 */           prop.setPropValue(stubProp.getPropValue());
/* 234 */           result.addStubProperty(prop);
/*     */         }
/*     */       }
/* 237 */       List callProps = jbpcref.getCallProperties();
/* 238 */       if (callProps != null)
/*     */       {
/* 240 */         for (CallPropertyMetaData callProp : callProps)
/*     */         {
/* 242 */           UnifiedCallPropertyMetaData prop = new UnifiedCallPropertyMetaData();
/* 243 */           prop.setPropName(callProp.getPropName());
/* 244 */           prop.setPropValue(callProp.getPropValue());
/* 245 */           result.addCallProperty(prop);
/*     */         }
/*     */       }
/*     */     }
/* 249 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.serviceref.ServiceReferenceHandler
 * JD-Core Version:    0.6.0
 */