/*     */ package org.jboss.metadata.plugins.loader.thread;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.security.AccessController;
/*     */ import org.jboss.metadata.plugins.loader.AbstractMutableMetaDataLoader;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.Item;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class ThreadLocalMetaDataLoader extends AbstractMutableMetaDataLoader
/*     */ {
/*  50 */   public static final ThreadLocalMetaDataLoader INSTANCE = new ThreadLocalMetaDataLoader();
/*     */ 
/*  52 */   private static final GetThreadName GET_THREAD_NAME = new GetThreadName();
/*     */ 
/*  55 */   private ThreadLocal<MemoryMetaDataLoader> threadLocal = new ThreadLocal();
/*     */ 
/*  58 */   private final BasicAnnotationsItem NO_ANNOTATIONS = new BasicAnnotationsItem(this, BasicAnnotationsItem.NO_ANNOTATION_ITEMS);
/*     */ 
/*  61 */   private final BasicMetaDatasItem NO_META_DATA = new BasicMetaDatasItem(this, BasicMetaDatasItem.NO_META_DATA_ITEMS);
/*     */ 
/*     */   private static final ScopeKey getThreadScopeKey()
/*     */   {
/*  70 */     String name = (String)AccessController.doPrivileged(GET_THREAD_NAME);
/*  71 */     Scope scope = new Scope(CommonLevels.THREAD, name);
/*  72 */     return new ScopeKey(scope);
/*     */   }
/*     */ 
/*     */   private ThreadLocalMetaDataLoader()
/*     */   {
/*  80 */     super(true);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  88 */     this.threadLocal.set(null);
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/*  93 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/*  94 */     if (delegate == null) {
/*  95 */       return getThreadScopeKey();
/*     */     }
/*  97 */     return delegate.getScope();
/*     */   }
/*     */ 
/*     */   public <T> boolean isCachable(Item<T> item)
/*     */   {
/* 104 */     return false;
/*     */   }
/*     */ 
/*     */   public ValidTime getValidTime()
/*     */   {
/* 109 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 110 */     if (delegate == null)
/* 111 */       return super.getValidTime();
/* 112 */     return delegate.getValidTime();
/*     */   }
/*     */ 
/*     */   public void invalidate()
/*     */   {
/* 117 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 118 */     if (delegate == null)
/* 119 */       super.invalidate();
/*     */     else
/* 121 */       delegate.invalidate();
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/* 126 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 127 */     if (delegate == null)
/* 128 */       return this.NO_ANNOTATIONS;
/* 129 */     return delegate.retrieveAnnotations();
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 134 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 135 */     if (delegate == null)
/* 136 */       return null;
/* 137 */     return delegate.retrieveAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T addAnnotation(T annotation)
/*     */   {
/* 142 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 143 */     if (delegate == null)
/*     */     {
/* 145 */       delegate = new MemoryMetaDataLoader(getThreadScopeKey(), false, true);
/* 146 */       this.threadLocal.set(delegate);
/*     */     }
/* 148 */     return delegate.addAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T removeAnnotation(Class<T> annotationType)
/*     */   {
/* 153 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 154 */     if (delegate == null)
/* 155 */       return null;
/* 156 */     return delegate.removeAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveMetaData()
/*     */   {
/* 161 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 162 */     if (delegate == null)
/* 163 */       return this.NO_META_DATA;
/* 164 */     return delegate.retrieveMetaData();
/*     */   }
/*     */ 
/*     */   public <T> MetaDataItem<T> retrieveMetaData(Class<T> type)
/*     */   {
/* 169 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 170 */     if (delegate == null)
/* 171 */       return null;
/* 172 */     return delegate.retrieveMetaData(type);
/*     */   }
/*     */ 
/*     */   public MetaDataItem retrieveMetaData(String name)
/*     */   {
/* 177 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 178 */     if (delegate == null)
/* 179 */       return null;
/* 180 */     return delegate.retrieveMetaData(name);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(T metaData, Class<T> type)
/*     */   {
/* 185 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 186 */     if (delegate == null)
/*     */     {
/* 188 */       delegate = new MemoryMetaDataLoader(getThreadScopeKey(), false, true);
/* 189 */       this.threadLocal.set(delegate);
/*     */     }
/* 191 */     return delegate.addMetaData(metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Class<T> type)
/*     */   {
/* 196 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 197 */     if (delegate == null)
/* 198 */       return null;
/* 199 */     return delegate.removeMetaData(type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(String name, T metaData, Class<T> type)
/*     */   {
/* 204 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 205 */     if (delegate == null)
/*     */     {
/* 207 */       delegate = new MemoryMetaDataLoader(getThreadScopeKey(), false, true);
/* 208 */       this.threadLocal.set(delegate);
/*     */     }
/* 210 */     return delegate.addMetaData(name, metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(String name, Class<T> type)
/*     */   {
/* 215 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 216 */     if (delegate == null)
/* 217 */       return null;
/* 218 */     return delegate.removeMetaData(name, type);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 223 */     MemoryMetaDataLoader delegate = (MemoryMetaDataLoader)this.threadLocal.get();
/* 224 */     return (delegate == null) || (delegate.isEmpty());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.thread.ThreadLocalMetaDataLoader
 * JD-Core Version:    0.6.0
 */