/*    */ package org.jboss.metadata.javaee.support;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.LinkedHashMap;
/*    */ import java.util.Map;
/*    */ import java.util.Map.Entry;
/*    */ 
/*    */ public class NonNullLinkedHashMap<K, V> extends LinkedHashMap<K, V>
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -5239003812587497285L;
/*    */ 
/*    */   public V put(K key, V value)
/*    */   {
/* 53 */     if (key == null)
/* 54 */       throw new IllegalArgumentException("Null key");
/* 55 */     if (value == null)
/* 56 */       throw new IllegalArgumentException("Null value");
/* 57 */     return super.put(key, value);
/*    */   }
/*    */ 
/*    */   public void putAll(Map<? extends K, ? extends V> m)
/*    */   {
/* 63 */     if (m == null)
/* 64 */       throw new IllegalArgumentException("Null map");
/* 65 */     for (Map.Entry entry : m.entrySet())
/*    */     {
/* 67 */       if (entry.getKey() == null)
/* 68 */         throw new IllegalArgumentException("Map contains a null key: " + m);
/* 69 */       if (entry.getValue() == null)
/* 70 */         throw new IllegalArgumentException("Map contains a null value: " + m);
/*    */     }
/* 72 */     super.putAll(m);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.NonNullLinkedHashMap
 * JD-Core Version:    0.6.0
 */