/*     */ package org.jboss.metadata.javaee.support;
/*     */ 
/*     */ public class JavaEEMetaDataUtil
/*     */ {
/*     */   public static <T extends MergeableMappedMetaData<T>, M extends MappedMetaData<T>> M mergeJBossXml(M merged, M overriden, M mapped, String context, boolean mustOverride)
/*     */   {
/*  48 */     return merge(merged, overriden, mapped, context, "ejb-jar.xml", "jboss.xml", mustOverride);
/*     */   }
/*     */ 
/*     */   public static <T extends MergeableMappedMetaData<T>, M extends MappedMetaData<T>> M merge(M merged, M overriden, M mapped, String context, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/*  69 */     if (merged == null) {
/*  70 */       throw new IllegalArgumentException("Null merged");
/*     */     }
/*     */ 
/*  73 */     if ((overriden == null) && (mapped == null)) {
/*  74 */       return merged;
/*     */     }
/*     */ 
/*  77 */     if ((overriden == null) || (overriden.isEmpty()))
/*     */     {
/*  81 */       if (mapped == null) {
/*  82 */         return merged;
/*     */       }
/*  84 */       if ((!mapped.isEmpty()) && (mustOverride))
/*  85 */         throw new IllegalStateException(overridenFile + " has no " + context + "s but " + overrideFile + " has " + mapped.keySet());
/*  86 */       if (mapped != merged)
/*  87 */         merged.addAll(mapped);
/*  88 */       return merged;
/*     */     }
/*     */ 
/*  93 */     for (MergeableMappedMetaData original : overriden)
/*     */     {
/*  95 */       String key = original.getKey();
/*  96 */       if ((mapped != null) && (mapped.containsKey(key)))
/*     */       {
/*  98 */         MergeableMappedMetaData override = (MergeableMappedMetaData)mapped.get(key);
/*  99 */         MergeableMappedMetaData tnew = (MergeableMappedMetaData)override.merge(original);
/* 100 */         merged.add(tnew);
/*     */       }
/*     */       else
/*     */       {
/* 104 */         merged.add(original);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 109 */     if (mapped != null)
/*     */     {
/* 111 */       for (MergeableMappedMetaData override : mapped)
/*     */       {
/* 113 */         String key = override.getKey();
/* 114 */         if (merged.containsKey(key))
/*     */           continue;
/* 116 */         if (mustOverride)
/* 117 */           throw new IllegalStateException(key + " in " + overrideFile + ", but not in " + overridenFile);
/* 118 */         merged.add(override);
/*     */       }
/*     */     }
/*     */ 
/* 122 */     return merged;
/*     */   }
/*     */ 
/*     */   public static <C extends MappableMetaData, O extends MappedMetaData<C>, T extends MappableMetaDataWithOverride<C>, M extends MappedMetaDataWithOverride<C, T, O>> M mergeOverrideJBossXml(M merged, O overriden, M mapped, String context, boolean mustOverride)
/*     */   {
/* 145 */     return mergeOverride(merged, overriden, mapped, context, "ejb-jar.xml", "jboss.xml", mustOverride);
/*     */   }
/*     */ 
/*     */   public static <C extends MappableMetaData, O extends MappedMetaData<C>, T extends MappableMetaDataWithOverride<C>, M extends MappedMetaDataWithOverride<C, T, O>> M mergeOverrideJBossCMPXml(M merged, O overriden, M mapped, String context, boolean mustOverride)
/*     */   {
/* 154 */     return mergeOverride(merged, overriden, mapped, context, "ejb-jar.xml", "jbosscmp-jdbc.xml", mustOverride);
/*     */   }
/*     */ 
/*     */   public static <C extends MappableMetaData, O extends MappedMetaData<C>, T extends MappableMetaDataWithOverride<C>, M extends MappedMetaDataWithOverride<C, T, O>> M mergeOverride(M merged, O overriden, M mapped, String context, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/* 179 */     if (merged == null) {
/* 180 */       throw new IllegalArgumentException("Null merged");
/*     */     }
/*     */ 
/* 183 */     if ((overriden == null) && (mapped == null)) {
/* 184 */       return merged;
/*     */     }
/*     */ 
/* 187 */     if ((overriden == null) || (overriden.isEmpty()))
/*     */     {
/* 189 */       if ((!mapped.isEmpty()) && (mustOverride))
/* 190 */         throw new IllegalStateException(overridenFile + " has no " + context + "s but " + overrideFile + " has " + mapped.keySet());
/* 191 */       return mapped;
/*     */     }
/*     */ 
/* 195 */     if (overriden != null)
/*     */     {
/* 197 */       for (MappableMetaData c : overriden)
/*     */       {
/* 200 */         String key = c.getKey();
/* 201 */         MappableMetaDataWithOverride t = null;
/* 202 */         if (mapped != null) {
/* 203 */           t = (MappableMetaDataWithOverride)mapped.get(key);
/*     */         }
/*     */ 
/* 206 */         if (t == null) {
/* 207 */           t = merged.createOverride(c);
/*     */         }
/*     */ 
/* 211 */         if (t != null)
/*     */         {
/* 214 */           t.setOverridenMetaData(c);
/* 215 */           merged.add(t);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 221 */     if ((mapped != null) && (!mapped.isEmpty()))
/*     */     {
/* 223 */       for (MappableMetaDataWithOverride t : mapped)
/*     */       {
/* 225 */         String key = t.getKey();
/* 226 */         if (merged.get(key) == null)
/*     */         {
/* 228 */           if (mustOverride) {
/* 229 */             throw new IllegalStateException(key + " in " + overrideFile + ", but not in " + overridenFile);
/*     */           }
/* 231 */           merged.createOriginal(t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 236 */     return merged;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.JavaEEMetaDataUtil
 * JD-Core Version:    0.6.0
 */