/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import javax.persistence.PersistenceContextType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
/*     */ 
/*     */ @XmlType(name="persistence-context-refType")
/*     */ public class PersistenceContextReferenceMetaData extends ResourceInjectionMetaDataWithDescriptions
/*     */   implements MergeableMappedMetaData<PersistenceContextReferenceMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 994249685587171979L;
/*     */   private String persistenceUnitName;
/*     */   private PersistenceContextType persistenceContextType;
/*     */   private PropertiesMetaData properties;
/*     */ 
/*     */   public String getPersistenceContextRefName()
/*     */   {
/*  70 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setPersistenceContextRefName(String persistenceContextRefName)
/*     */   {
/*  81 */     setName(persistenceContextRefName);
/*     */   }
/*     */ 
/*     */   public String getPersistenceUnitName()
/*     */   {
/*  91 */     return this.persistenceUnitName;
/*     */   }
/*     */ 
/*     */   public void setPersistenceUnitName(String persistenceUnitName)
/*     */   {
/* 102 */     if (persistenceUnitName == null)
/* 103 */       throw new IllegalArgumentException("Null persistenceUnitName");
/* 104 */     this.persistenceUnitName = persistenceUnitName;
/*     */   }
/*     */ 
/*     */   public PersistenceContextType getPersistenceContextType()
/*     */   {
/* 114 */     return this.persistenceContextType;
/*     */   }
/*     */ 
/*     */   @XmlJavaTypeAdapter(PersistenceContextTypeAdapter.class)
/*     */   public void setPersistenceContextType(PersistenceContextType persistenceContextType)
/*     */   {
/* 126 */     if (persistenceContextType == null)
/* 127 */       throw new IllegalArgumentException("Null persistenceContextType");
/* 128 */     this.persistenceContextType = persistenceContextType;
/*     */   }
/*     */ 
/*     */   public PropertiesMetaData getProperties()
/*     */   {
/* 138 */     return this.properties;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="persistence-property")
/*     */   public void setProperties(PropertiesMetaData properties)
/*     */   {
/* 150 */     if (properties == null)
/* 151 */       throw new IllegalArgumentException("Null properties");
/* 152 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public PersistenceContextReferenceMetaData merge(PersistenceContextReferenceMetaData original)
/*     */   {
/* 157 */     PersistenceContextReferenceMetaData merged = new PersistenceContextReferenceMetaData();
/* 158 */     merged.merge(this, original);
/* 159 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(PersistenceContextReferenceMetaData override, PersistenceContextReferenceMetaData original)
/*     */   {
/* 164 */     super.merge(override, original);
/* 165 */     PersistenceContextReferenceMetaData merged = new PersistenceContextReferenceMetaData();
/* 166 */     merged.merge(this, original);
/*     */ 
/* 168 */     if ((override != null) && (override.persistenceUnitName != null))
/* 169 */       this.persistenceUnitName = override.persistenceUnitName;
/* 170 */     else if ((original != null) && (original.persistenceUnitName != null))
/* 171 */       this.persistenceUnitName = original.persistenceUnitName;
/* 172 */     if ((override != null) && (override.persistenceContextType != null))
/* 173 */       this.persistenceContextType = override.persistenceContextType;
/* 174 */     else if ((original != null) && (original.persistenceContextType != null))
/* 175 */       this.persistenceContextType = original.persistenceContextType;
/* 176 */     if ((override != null) && (override.properties != null))
/*     */     {
/* 178 */       if (this.properties == null)
/* 179 */         this.properties = new PropertiesMetaData();
/* 180 */       this.properties.addAll(override.properties);
/*     */     }
/* 182 */     if ((original != null) && (original.properties != null))
/*     */     {
/* 184 */       if (this.properties == null)
/* 185 */         this.properties = new PropertiesMetaData();
/* 186 */       this.properties.addAll(original.properties);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData
 * JD-Core Version:    0.6.0
 */