/*     */ package org.jboss.metadata.javaee.jboss;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class RunAsIdentityMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String principalName;
/*     */   private String roleName;
/*  45 */   private HashSet<String> runAsRoles = new HashSet();
/*     */   private static final String ANOYMOUS_PRINCIPAL = "anonymous";
/*     */ 
/*     */   public RunAsIdentityMetaData(String roleName, String principalName)
/*     */   {
/*  54 */     if (principalName == null)
/*  55 */       principalName = "anonymous";
/*  56 */     if (roleName == null) {
/*  57 */       throw new IllegalArgumentException("The run-as identity must have at least one role");
/*     */     }
/*  59 */     this.principalName = principalName;
/*  60 */     this.roleName = roleName;
/*  61 */     this.runAsRoles.add(roleName);
/*     */   }
/*     */ 
/*     */   public RunAsIdentityMetaData(String roleName, String principalName, Set<String> extraRoleNames)
/*     */   {
/*  69 */     this(roleName, principalName);
/*     */ 
/*  72 */     if (extraRoleNames != null)
/*     */     {
/*  74 */       for (String extraRoleName : extraRoleNames)
/*     */       {
/*  76 */         this.runAsRoles.add(extraRoleName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getPrincipalName()
/*     */   {
/*  83 */     return this.principalName;
/*     */   }
/*     */ 
/*     */   public String getRoleName() {
/*  87 */     return this.roleName;
/*     */   }
/*     */ 
/*     */   public Set<String> getRunAsRoles()
/*     */   {
/*  96 */     return new HashSet(this.runAsRoles);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(String role)
/*     */   {
/* 101 */     return this.runAsRoles.contains(role);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Set<String> methodRoles)
/*     */   {
/* 109 */     if (methodRoles != null)
/* 110 */       for (String role : methodRoles)
/*     */       {
/* 112 */         if (doesUserHaveRole(role))
/* 113 */           return true;
/*     */       }
/* 115 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 124 */     return "[roles=" + this.runAsRoles + ",principal=" + getPrincipalName() + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData
 * JD-Core Version:    0.6.0
 */