/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ 
/*     */ @XmlType(name="ejb-relationship-roleType")
/*     */ public class RelationRoleMetaData extends NamedMetaDataWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = 16044363266734061L;
/*     */   private MultiplicityType multiplicityType;
/*     */   private EmptyMetaData cascadedDelete;
/*     */   private RelationMetaData relation;
/*     */   private RelationRoleSourceMetaData roleSource;
/*     */   private CMRFieldMetaData cmrField;
/*     */ 
/*     */   public String getEjbRelationshipRoleName()
/*     */   {
/*  72 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setEjbRelationshipRoleName(String ejbRelationshipRoleName)
/*     */   {
/*  83 */     setName(ejbRelationshipRoleName);
/*     */   }
/*     */ 
/*     */   public MultiplicityType getMultiplicity()
/*     */   {
/*  93 */     return this.multiplicityType;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="multiplicity")
/*     */   public void setMultiplicity(MultiplicityType multiplicityType)
/*     */   {
/* 105 */     if (multiplicityType == null)
/* 106 */       throw new IllegalArgumentException("Null multiplicityType");
/* 107 */     this.multiplicityType = multiplicityType;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean isMultiplicityOne()
/*     */   {
/* 118 */     return this.multiplicityType == MultiplicityType.One;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean isMultiplicityMany()
/*     */   {
/* 129 */     return this.multiplicityType == MultiplicityType.Many;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public boolean isCascadedDelete() {
/* 135 */     return this.cascadedDelete != null;
/*     */   }
/*     */ 
/*     */   public EmptyMetaData getCascadeDelete()
/*     */   {
/* 145 */     return this.cascadedDelete;
/*     */   }
/*     */ 
/*     */   public void setCascadeDelete(EmptyMetaData cascadedDelete)
/*     */   {
/* 155 */     this.cascadedDelete = cascadedDelete;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public RelationMetaData getRelation()
/*     */   {
/* 166 */     return this.relation;
/*     */   }
/*     */ 
/*     */   void setRelation(RelationMetaData relation)
/*     */   {
/* 177 */     if (relation == null)
/* 178 */       throw new IllegalArgumentException("Null relation");
/* 179 */     this.relation = relation;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public RelationRoleMetaData getRelatedRole()
/*     */   {
/* 190 */     if (this.relation == null)
/* 191 */       throw new IllegalStateException("Relation has not been set");
/* 192 */     return this.relation.getRelatedRole(this);
/*     */   }
/*     */ 
/*     */   public RelationRoleSourceMetaData getRoleSource()
/*     */   {
/* 202 */     return this.roleSource;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="relationship-role-source")
/*     */   public void setRoleSource(RelationRoleSourceMetaData roleSource)
/*     */   {
/* 214 */     if (roleSource == null)
/* 215 */       throw new IllegalArgumentException("Null roleSource");
/* 216 */     this.roleSource = roleSource;
/*     */   }
/*     */ 
/*     */   public CMRFieldMetaData getCmrField()
/*     */   {
/* 226 */     return this.cmrField;
/*     */   }
/*     */ 
/*     */   public void setCmrField(CMRFieldMetaData cmrField)
/*     */   {
/* 237 */     if (cmrField == null)
/* 238 */       throw new IllegalArgumentException("Null cmrField");
/* 239 */     this.cmrField = cmrField;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.RelationRoleMetaData
 * JD-Core Version:    0.6.0
 */