/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.metadata.merge.MergeUtil;
/*     */ 
/*     */ public class MethodsMetaData extends ArrayList<MethodMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = -1713776894150257182L;
/*     */ 
/*     */   public boolean matches(String methodName, Class[] params, MethodInterfaceType interfaceType)
/*     */   {
/*  49 */     return matches(methodName, getParametersAsStrings(params), interfaceType);
/*     */   }
/*     */ 
/*     */   public boolean matches(String methodName, String[] params, MethodInterfaceType interfaceType)
/*     */   {
/*  62 */     if (isEmpty()) {
/*  63 */       return false;
/*     */     }
/*  65 */     for (MethodMetaData method : this)
/*     */     {
/*  67 */       if (method.matches(methodName, params, interfaceType))
/*  68 */         return true;
/*     */     }
/*  70 */     return false;
/*     */   }
/*     */ 
/*     */   public MethodMetaData bestMatch(String methodName, Class[] params, MethodInterfaceType interfaceType, MethodMetaData bestMatch)
/*     */   {
/*  84 */     return bestMatch(methodName, getParametersAsStrings(params), interfaceType, bestMatch);
/*     */   }
/*     */ 
/*     */   public MethodMetaData bestMatch(String methodName, String[] params, MethodInterfaceType interfaceType, MethodMetaData bestMatch)
/*     */   {
/*  98 */     if (isEmpty()) {
/*  99 */       return bestMatch;
/*     */     }
/* 101 */     for (MethodMetaData method : this)
/*     */     {
/* 103 */       if (method.matches(methodName, params, interfaceType))
/*     */       {
/* 106 */         if (bestMatch == null) {
/* 107 */           bestMatch = method;
/*     */         }
/* 109 */         else if ("*".equals(bestMatch.getMethodName())) {
/* 110 */           bestMatch = method;
/*     */         }
/* 112 */         else if (method.getMethodParams() != null)
/* 113 */           bestMatch = method;
/*     */       }
/*     */     }
/* 116 */     return bestMatch;
/*     */   }
/*     */ 
/*     */   public MethodsMetaData getMethodsByEjbName(String ejbName)
/*     */   {
/* 128 */     if (ejbName == null) {
/* 129 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 131 */     MethodsMetaData result = null;
/* 132 */     for (MethodMetaData method : this)
/*     */     {
/* 134 */       if (ejbName.equals(method.getEjbName()))
/*     */       {
/* 136 */         if (result == null)
/* 137 */           result = new MethodsMetaData();
/* 138 */         result.add(method);
/*     */       }
/*     */     }
/* 141 */     return result;
/*     */   }
/*     */ 
/*     */   private String[] getParametersAsStrings(Class[] classes)
/*     */   {
/* 152 */     if (classes == null) {
/* 153 */       return null;
/*     */     }
/* 155 */     String[] out = new String[classes.length];
/* 156 */     for (int i = 0; i < out.length; i++)
/*     */     {
/* 158 */       String brackets = "";
/* 159 */       Class cls = classes[i];
/* 160 */       while (cls.isArray())
/*     */       {
/* 162 */         brackets = brackets + "[]";
/* 163 */         cls = cls.getComponentType();
/*     */       }
/* 165 */       out[i] = (cls.getName() + brackets);
/*     */     }
/* 167 */     return out;
/*     */   }
/*     */ 
/*     */   public void merge(MethodsMetaData override, MethodsMetaData original)
/*     */   {
/* 172 */     MergeUtil.merge(this, override, original);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.MethodsMetaData
 * JD-Core Version:    0.6.0
 */